/*
 *  XML utilities (e.g. escaping)
 */

XmlUtil = {};

XmlUtil.escTab = {};
XmlUtil.initEscTab = function () {
	var i, c, v;

	for (i = 0; i < 256; i++) {
		c = String.fromCharCode(i);
		if (c === '<') {
			v = '&lt;';
		} else if (c === '>') {
			v = '&gt;';
		} else if (c === '\'') {
			v = '&apos;';
		} else if (c === '"') {
			v = '&quot;';
		} else if (c === '&') {
			v = '&amp;';
		} else if (i < 0x20 || i > 0x7e) {
			v = '&#x' + i.toString(16) + ';';
		} else {
			v = c;
		}
		XmlUtil.escTab[i] = v;
	}
};
XmlUtil.initEscTab();

XmlUtil.xmlEscape = function (str) {
	var i, n, c, t, res, esc;

	esc = XmlUtil.escTab;
	res = [];

	for (i = 0, n = str.length; i < n; i++) {
		var c = str.charCodeAt(i);
		t = esc[c];
		if (t) {
			res.push(t);
		} else {
			// Codepoints > 0xff
			res.push('&#x' + c.toString(16) + ';');
		}
	}
	return res.join('');
};

XmlUtil.formatTime = function (t) {
	// XXX: better way to get seconds resolution without manual
	// date formatting?
	return t.toISOString().replace('.000Z', 'Z');
};
