// Hide and Seek Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     draggable (Boolean): If true the view will follow the cursor position between the touch start and touch end.
//     alpha (Number): Amount of transparency amount ranging from 0 (completely transparent) to 0.5 to 1 (completely opaque). 
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     ignoreTransparentPixels (Boolean): If true the hotspot will register only if the pixel's alpha component under touch position is greater than 0.
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Hide and Seek Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after all the hidden items are found.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a target item is touched.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     items: A random item is selected at the start of each round to be the correct item.
//         Available States:
//             HIDDEN: Initial state of the label.
//             DRAG: Displayed when the item is being dragged.
//             FOUND: Displayed after the item is found.
//         Properties:
//             mask: Optional view coupled with an item.
//                 Properties:
//                     wiggleOnTouch (Boolean): A touch will cause the mask's item to vibrate.
//                     foundOnTouch (Boolean): A touch will cause the mask' item to be found.
//                     touchDisabled (Boolean): Touch events on the mask will be ignored.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "mozilla_thumb_256x256_OhSayCanYouSeeShapes.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "HTML_startscreen_etm_president_ipad.jpg",
	audioEnabled: true,
	audioFilename: "president-game.mp3",
	audio: { //just music
		states: [
			{
				name: "music", 
				startTime: 103.1,
				duration: 18.145,
				loop: true
			}
		]
	},
	rounds: [
		{ //Round 1
			audio: {  //round 1 intro and payoff
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 14.1
					}, {
						name: "payoff",
						startTime: 14.8,
						duration: 6.35
					}
				]
			},
			background: {
				filename: "Background_Oval_Office.png"
			},
			payoff: {
				type: "Payoff",
				x: 351,
				y: 378,
				states: [
					{
						type: "Default",
						filename: "01_President_Elmo_sprite_start.png"
					},
					{
						type: "Success",
						filename: "01_President_Elmo_sprite.png",
						numFrames: 14
					}
				]
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden", //the item appearing in its hidden state, can be partial image
									filename: "Oval_1.png", //make a rectangle marquee in Photoshop to get the bounding rectangle of the object and export as transparent png
									x: 496, //x,y coordinates of objects can be found by opening the object in Photoshop, add on a layer mask to show the bounding rectangle, take the ruler tool and measure from top to bottom. Take this number and subtract 100 px. The x,y coordinates will then be placed here.
									y: 133
								},{
									type: "Drag", //item appearing in draggable state, should be full image even if hidden was partial
									filename: "Oval_1.png",
									x: 496,
									y: 133,
									draggable: true
								},{
									type: "Found", //found animation
									filename: "Oval_1_sprite.png",
									x: 484,
									y: 124,
									numFrames: 15
								}
							]
						},{
							states: [
								{
									type: "Hidden", 
									filename: "Oval_2.png", 
									x: 790,
									y: 371
								},{
									type: "Drag", 
									filename: "Oval_2.png",
									x: 790,
									y: 371,
									draggable: true
								},{
									type: "Found",
									filename: "Oval_2_sprite.png",
									x: 606,
									y: 248,
									numFrames: 15
								}
							]
						},{
							states: [
								{
									type: "Hidden", 
									filename: "Oval_3.png", 
									x: 887, 
									y: 540
								},{
									type: "Drag", 
									filename: "Oval_3.png",
									x: 887,
									y: 540,
									draggable: true
								},{
									type: "Found", 
									filename: "Oval_3_sprite.png",
									x: 710,
									y: 492,
									numFrames: 20
								}
							]
						},{
							states: [
								{
									type: "Hidden", 
									filename: "Oval_4.png", 
									x: 888, 
									y: 376
								},{
									type: "Drag", 
									filename: "Oval_4.png",
									x: 888,
									y: 376,
									draggable: true
								},{
									type: "Found", 
									filename: "Oval_4_sprite.png",
									x: 872,
									y: 210,
									numFrames: 17
								}
							]
						},{
							states: [
								{
									type: "Hidden", 
									filename: "Oval_5.png", 
									x: 351, 
									y: 345
								},{
									type: "Drag", 
									filename: "Oval_5.png",
									x: 351,
									y: 345,
									draggable: true
								},{
									type: "Found", 
									filename: "Oval_5_sprite.png",
									x: 342,
									y: 300,
									numFrames: 13
								}
							]
						},{
							states: [
								{
									type: "Hidden", 
									filename: "Oval_6.png", 
									x: 78, 
									y: 502
								},{
									type: "Drag", 
									filename: "Oval_6.png",
									x: 78,
									y: 502,
									draggable: true
								},{
									type: "Found", 
									filename: "Oval_6_sprite.png",
									x: 60,
									y: 493,
									numFrames: 13
								}
							]
						}
					]
				}
			]
		},
		{ //Round 2
			audio: { //round 2 intro and payoff
				states: [
					{
						name: "intro",
						startTime: 22,
						duration: 13.7
					}, {
						name: "payoff",
						startTime: 37,
						duration: 6.8
					}
				]
			},
			background: {
				filename: "Background_Capitol_Building.png"
			},
			payoff: {
				type: "Payoff",
				x: 791,
				y: 502,
				states: [
					{
						type: "Default",
						filename: "02_President_Elmo_sprite_start.png"
					},
					{
						type: "Success",
						filename: "02_President_Elmo_sprite.png",
						numFrames: 17
					}
				]
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Rectangle_1.png", 
									x: 222, 
									y: 301
								},{
									type: "Drag", 
									filename: "Rectangle_1.png",
									x: 222,
									y: 301,
									draggable: true
								},{
									type: "Found", 
									filename: "Rectangle_1_sprite.png",
									x: 18,
									y: 150,
									numFrames: 16
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Rectangle_2.png", 
									x: 169, 
									y: 458
								},{
									type: "Drag", 
									filename: "Rectangle_2.png",
									x: 169,
									y: 458,
									draggable: true
								},{
									type: "Found", 
									filename: "Rectangle_2_sprite.png",
									x: 155,
									y: 431,
									numFrames: 16
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Rectangle_3.png", 
									x: 293, 
									y: 415
								},{
									type: "Drag", 
									filename: "Rectangle_3.png",
									x: 293,
									y: 415,
									draggable: true
								},{
									type: "Found", 
									filename: "Rectangle_3_sprite.png",
									x: 278,
									y: 245,
									numFrames: 17
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Rectangle_4.png", 
									x: 620, 
									y: 415
								},{
									type: "Drag", 
									filename: "Rectangle_4.png",
									x: 620,
									y: 415,
									draggable: true
								},{
									type: "Found", 
									filename: "Rectangle_4_sprite.png",
									x: 610,
									y: 399,
									numFrames: 16
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Rectangle_5.png", 
									x: 732, 
									y: 458
								},{
									type: "Drag", 
									filename: "Rectangle_5.png",
									x: 732,
									y: 458,
									draggable: true
								},{
									type: "Found", 
									filename: "Rectangle_5_sprite.png",
									x: 718,
									y: 425,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Rectangle_6.png", 
									x: 764, 
									y: 301
								},{
									type: "Drag", 
									filename: "Rectangle_6.png",
									x: 764,
									y: 301,
									draggable: true
								},{
									type: "Found", 
									filename: "Rectangle_6_sprite.png",
									x: 745,
									y: 290,
									numFrames: 15
								}
							]
						}
					]
				}
			]
		},
		{ //Round 3
			
			audio: { //round 2 intro and payoff
				states: [
					{
						name: "intro",
						startTime: 83,
						duration: 11.1
					}, {
						name: "payoff",
						startTime: 95,
						duration: 6.7
					}
				]
			},
			background: {
				filename: "Background_Lincoln_Memorial.png"
			},
			payoff: {
				type: "Payoff",
				x: 562,
				y: 454,
				states: [
					{
						type: "Default",
						filename: "03_President_Elmo_sprite_start.png"
					},
					{
						type: "Success",
						filename: "03_President_Elmo_sprite.png",
						numFrames: 18
					}
				]
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Square_1.png", 
									x: 52, 
									y: 486
								},{
									type: "Drag", 
									filename: "Square_1.png",
									x: 52,
									y: 486,
									draggable: true
								},{
									type: "Found", 
									filename: "Square_1_sprite.png",
									x: 39,
									y: 473,
									numFrames: 15
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Square_2.png", 
									x: 734, 
									y: 391
								},{
									type: "Drag", 
									filename: "Square_2.png",
									x: 734,
									y: 391,
									draggable: true
								},{
									type: "Found", 
									filename: "Square_2_sprite.png",
									x: 716,
									y: 204,
									numFrames: 14
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Square_3.png", 
									x: 282, 
									y: 160
								},{
									type: "Drag", 
									filename: "Square_3.png",
									x: 282,
									y: 160,
									draggable: true
								},{
									type: "Found", 
									filename: "Square_3_sprite.png",
									x: 240,
									y: 124,
									numFrames: 17
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Square_4.png", 
									x: 622, 
									y: 103
								},{
									type: "Drag", 
									filename: "Square_4.png",
									x: 622,
									y: 103,
									draggable: true
								},{
									type: "Found", 
									filename: "Square_4_sprite.png",
									x: 609,
									y: 90,
									numFrames: 20
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Square_5.png", 
									x: 174, 
									y: 384
								},{
									type: "Drag", 
									filename: "Square_5.png",
									x: 174,
									y: 384,
									draggable: true
								},{
									type: "Found", 
									filename: "Square_5_sprite.png",
									x: 166,
									y: 374,
									numFrames: 15
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Square_6.png", 
									x: 852, 
									y: 487
								},{
									type: "Drag", 
									filename: "Square_6.png",
									x: 852,
									y: 487,
									draggable: true
								},{
									type: "Found", 
									filename: "Square_6_sprite.png",
									x: 626,
									y: 416,
									numFrames: 21
								}
							]
						}
					]
				}
			]
		},
		{ //Round 4
			audio: { //round 4 intro and payoff
				states: [
					{
						name: "intro",
						startTime: 45,
						duration: 10.4
					}, {
						name: "payoff",
						startTime: 55.8,
						duration: 6.4
					}
				]
			},
			background: {
				filename: "Background_Jefferson_Memorial.png"
			},
			
			payoff: {
				type: "Payoff",
				x: 490,
				y: 460,
				states: [
					{
						type: "Default",
						filename: "04_President_Elmo_sprite_start.png"
					},
					{
						type: "Success",
						filename: "04_President_Elmo_sprite.png",
						numFrames: 18
					}
				]
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Hexagon_1.png", 
									x: 446, 
									y: 92
								},{
									type: "Drag", 
									filename: "Hexagon_1.png",
									x: 446,
									y: 92,
									draggable: true
								},{
									type: "Found", 
									filename: "Hexagon_1_sprite.png",
									x: 434,
									y: 66,
									numFrames: 15
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Hexagon_2.png", 
									x: 206, 
									y: 358
								},{
									type: "Drag", 
									filename: "Hexagon_2.png",
									x: 206,
									y: 358,
									draggable: true
								},{
									type: "Found", 
									filename: "Hexagon_2_sprite.png",
									x: 185,
									y: 335,
									numFrames: 13
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Hexagon_3.png", 
									x: 343, 
									y: 485
								},{
									type: "Drag", 
									filename: "Hexagon_3.png",
									x: 343,
									y: 485,
									draggable: true
								},{
									type: "Found", 
									filename: "Hexagon_3_sprite.png",
									x: 330,
									y: 470,
									numFrames: 11
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Hexagon_4.png", 
									x: 691, 
									y: 394
								},{
									type: "Drag", 
									filename: "Hexagon_4.png",
									x: 691,
									y: 394,
									draggable: true
								},{
									type: "Found", 
									filename: "Hexagon_4_sprite.png",
									x: 671,
									y: 195,
									numFrames: 14
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Hexagon_5.png", 
									x: 68, 
									y: 488
								},{
									type: "Drag", 
									filename: "Hexagon_5.png",
									x: 68,
									y: 488,
									draggable: true
								},{
									type: "Found", 
									filename: "Hexagon_5_sprite.png",
									x: 59,
									y: 475,
									numFrames: 19
								}
							]
						}
					]
				}
			]
		},
		{ //Round 5
			audio: { //round 5 intro and payoff
				states: [
					{
						name: "intro",
						startTime: 62.9,
						duration: 10.9
					}, {
						name: "payoff",
						startTime: 74.8,
						duration: 6.6
					}
				]
			},
			background: {
				filename: "Background_Washington_Monument.png"
			},
			payoff: {
				type: "Payoff",
				x: 752,
				y: 489,
				states: [
					{
						type: "Default",
						filename: "05_President_Elmo_sprite_start.png"
					},
					{
						type: "Success",
						filename: "05_President_Elmo_sprite.png",
						numFrames: 18
					}
				]
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Triangle_1.png", 
									x: 61, 
									y: 315
								},{
									type: "Drag", 
									filename: "Triangle_1.png",
									x: 61,
									y: 315,
									draggable: true
								},{
									type: "Found", 
									filename: "Triangle_1_sprite.png",
									x: 39,
									y: 113,
									numFrames: 18
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Triangle_2.png", 
									x: 333, 
									y: 84
								},{
									type: "Drag", 
									filename: "Triangle_2.png",
									x: 333,
									y: 84,
									draggable: true
								},{
									type: "Found", 
									filename: "Triangle_2_sprite.png",
									x: 323,
									y: 62,
									numFrames: 16
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Triangle_3.png", 
									x: 329, 
									y: 313
								},{
									type: "Drag", 
									filename: "Triangle_3.png",
									x: 329,
									y: 313,
									draggable: true
								},{
									type: "Found", 
									filename: "Triangle_3_sprite.png",
									x: 261,
									y: 275,
									numFrames: 15
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Triangle_4.png", 
									x: 480, 
									y: 359
								},{
									type: "Drag", 
									filename: "Triangle_4.png",
									x: 480,
									y: 359,
									draggable: true
								},{
									type: "Found", 
									filename: "Triangle_4_sprite.png",
									x: 456,
									y: 185,
									numFrames: 16
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Triangle_5.png", 
									x: 751, 
									y: 173
								},{
									type: "Drag", 
									filename: "Triangle_5.png",
									x: 751,
									y: 173,
									draggable: true
								},{
									type: "Found", 
									filename: "Triangle_5_sprite.png",
									x: 721,
									y: 154,
									numFrames: 14
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Triangle_6.png", 
									x: 618, 
									y: 488
								},{
									type: "Drag", 
									filename: "Triangle_6.png",
									x: 618,
									y: 488,
									draggable: true
								},{
									type: "Found", 
									filename: "Triangle_6_sprite.png",
									x: 597,
									y: 448,
									numFrames: 16
								}
							]
						}
					]
				}
			]
		}
	]
};