Shaders = {"underwater_effect_fragment_shader": "\n    uniform sampler2D sampler;\n    uniform vec2 dimensions;\n    uniform float time;\n\n    varying vec2 tex;\n\n    void main()\n    {\n        // Shift texture lookup sideways depending on Y coordinate + time\n        vec2 pos = tex + vec2(6.0*sin(pow(tex.y, 2.0)*20.0+time)/dimensions.x, 0.0);\n        vec4 color = texture2D(sampler, pos);\n\n        // Vignette effect (brightest at center, darker towards edges)\n        float lum = 1.0 - length(tex - vec2(0.5, 0.5));\n\n        // blue-green'ish tint base color\n        vec4 tint = vec4(0.0, 0.01, 0.05, 1.0);\n\n        // Vignette color is also blue-green'ish\n        vec4 vignette = vec4(lum * 0.7, lum * 0.9, lum, 1.0);\n\n        gl_FragColor = tint + vignette * color;\n    }\n", "gles_combined_effect_fragment_shader": "\n    uniform sampler2D sampler;\n    uniform vec2 dimensions;\n    uniform float time;\n\n    varying vec2 tex;\n\n    void main()\n    {\n        // Shift texture lookup sideways depending on Y coordinate + time\n        vec2 pos = tex + vec2(6.0*sin(pow(tex.y, 2.0)*20.0+time)/dimensions.x, 0.0);\n        float radius = 15.0 * abs(0.3 - tex.y) / dimensions.x;\n        vec4 color = 0.2 * texture2D(sampler, pos)\n                     + 0.4 * texture2D(sampler, pos + vec2(radius, 0))\n                     + 0.4 * texture2D(sampler, pos + vec2(0, -radius));\n\n        // Vignette effect (brightest at center, darker towards edges)\n        float lum = 1.0 - length(tex - vec2(0.5, 0.5));\n\n        gl_FragColor = color * lum;\n    }\n", "draw_sprites_fragment_shader": "\n    uniform sampler2D sampler;\n    uniform vec4 color;\n\n    varying vec2 tex;\n\n    void main()\n    {\n        gl_FragColor = color * texture2D(sampler, tex);\n    }\n", "sepia_effect_fragment_shader": "\n    uniform sampler2D sampler;\n\n    varying vec2 tex;\n\n    void main()\n    {\n        vec4 color = texture2D(sampler, tex);\n        float mean = (color.x + color.y + color.z) / 3.0;\n        gl_FragColor = vec4(mean * 1.2, mean * 1.1, mean, 1);\n    }\n", "draw_sprites_vertex_shader": "\n    attribute vec4 position;\n    attribute vec2 texcoord;\n\n    uniform vec2 size;\n    uniform vec2 offset;\n    uniform float scale;\n\n    varying vec2 tex;\n\n    void main()\n    {\n        gl_Position.x = 2.0 * (position.x*scale + offset.x) / size.x - 1.0;\n        gl_Position.y = 1.0 - 2.0 * (position.y*scale + offset.y) / size.y;\n        gl_Position.z = 0.0;\n        gl_Position.w = 1.0;\n\n        tex = texcoord;\n    }\n", "blur_effect_fragment_shader": "\n    uniform sampler2D sampler;\n    uniform vec2 dimensions;\n\n    varying vec2 tex;\n\n    void main()\n    {\n        float radius = 10.0 * abs(0.3 - tex.y);\n        vec2 offset = vec2(radius / dimensions.x, radius / dimensions.y);\n        gl_FragColor = 0.3 * texture2D(sampler, tex)\n                     + 0.1 * texture2D(sampler, tex + vec2(0, -offset.y))\n                     + 0.1 * texture2D(sampler, tex + vec2(0, offset.y))\n                     + 0.1 * texture2D(sampler, tex + vec2(-offset.x, 0))\n                     + 0.1 * texture2D(sampler, tex + vec2(offset.x, 0))\n                     + 0.075 * texture2D(sampler, tex + vec2(-offset.x, -offset.y))\n                     + 0.075 * texture2D(sampler, tex + vec2(offset.x, offset.y))\n                     + 0.075 * texture2D(sampler, tex + vec2(-offset.x, offset.y))\n                     + 0.075 * texture2D(sampler, tex + vec2(offset.x, -offset.y));\n    }\n", "effect_vertex_shader": "\nattribute vec4 position;\nattribute vec2 texcoord;\n\nvarying vec2 tex;\n\nvoid main()\n{\n    gl_Position = position;\n    tex = texcoord;\n}\n"} ;
