/*!
 * EventEmitter v4.2.9 - git.io/ee
 * Oliver Caldwell
 * MIT license
 * @preserve
 */
(function(){"use strict";function EventEmitter(){}function indexOfListener(listeners,listener){for(var i=listeners.length;i--;)if(listeners[i].listener===listener)return i;return-1}function alias(name){return function(){return this[name].apply(this,arguments)}}var proto=EventEmitter.prototype,exports=this,originalGlobalValue=exports.EventEmitter;proto.getListeners=function(evt){var response,key,events=this._getEvents();if(evt instanceof RegExp){response={};for(key in events)events.hasOwnProperty(key)&&evt.test(key)&&(response[key]=events[key])}else response=events[evt]||(events[evt]=[]);return response},proto.flattenListeners=function(listeners){var i,flatListeners=[];for(i=0;i<listeners.length;i+=1)flatListeners.push(listeners[i].listener);return flatListeners},proto.getListenersAsObject=function(evt){var response,listeners=this.getListeners(evt);return listeners instanceof Array&&(response={},response[evt]=listeners),response||listeners},proto.addListener=function(evt,listener){var key,listeners=this.getListenersAsObject(evt),listenerIsWrapped="object"==typeof listener;for(key in listeners)listeners.hasOwnProperty(key)&&-1===indexOfListener(listeners[key],listener)&&listeners[key].push(listenerIsWrapped?listener:{listener:listener,once:!1});return this},proto.on=alias("addListener"),proto.addOnceListener=function(evt,listener){return this.addListener(evt,{listener:listener,once:!0})},proto.once=alias("addOnceListener"),proto.defineEvent=function(evt){return this.getListeners(evt),this},proto.defineEvents=function(evts){for(var i=0;i<evts.length;i+=1)this.defineEvent(evts[i]);return this},proto.removeListener=function(evt,listener){var index,key,listeners=this.getListenersAsObject(evt);for(key in listeners)listeners.hasOwnProperty(key)&&(index=indexOfListener(listeners[key],listener),-1!==index&&listeners[key].splice(index,1));return this},proto.off=alias("removeListener"),proto.addListeners=function(evt,listeners){return this.manipulateListeners(!1,evt,listeners)},proto.removeListeners=function(evt,listeners){return this.manipulateListeners(!0,evt,listeners)},proto.manipulateListeners=function(remove,evt,listeners){var i,value,single=remove?this.removeListener:this.addListener,multiple=remove?this.removeListeners:this.addListeners;if("object"!=typeof evt||evt instanceof RegExp)for(i=listeners.length;i--;)single.call(this,evt,listeners[i]);else for(i in evt)evt.hasOwnProperty(i)&&(value=evt[i])&&("function"==typeof value?single.call(this,i,value):multiple.call(this,i,value));return this},proto.removeEvent=function(evt){var key,type=typeof evt,events=this._getEvents();if("string"===type)delete events[evt];else if(evt instanceof RegExp)for(key in events)events.hasOwnProperty(key)&&evt.test(key)&&delete events[key];else delete this._events;return this},proto.removeAllListeners=alias("removeEvent"),proto.emitEvent=function(evt,args){var listener,i,key,response,listeners=this.getListenersAsObject(evt);for(key in listeners)if(listeners.hasOwnProperty(key))for(i=listeners[key].length;i--;)listener=listeners[key][i],listener.once===!0&&this.removeListener(evt,listener.listener),response=listener.listener.apply(this,args||[]),response===this._getOnceReturnValue()&&this.removeListener(evt,listener.listener);return this},proto.trigger=alias("emitEvent"),proto.emit=function(evt){var args=Array.prototype.slice.call(arguments,1);return this.emitEvent(evt,args)},proto.setOnceReturnValue=function(value){return this._onceReturnValue=value,this},proto._getOnceReturnValue=function(){return this.hasOwnProperty("_onceReturnValue")?this._onceReturnValue:!0},proto._getEvents=function(){return this._events||(this._events={})},EventEmitter.noConflict=function(){return exports.EventEmitter=originalGlobalValue,EventEmitter},"function"==typeof define&&define.amd?define(function(){return EventEmitter}):"object"==typeof module&&module.exports?module.exports=EventEmitter:exports.EventEmitter=EventEmitter}).call(this);/**
 * @file
 * File picker and finder for device storages on Firefox OS devices
 *
 * This library provides an easy-to-use asynchronous interface for other Firefox OS apps to search for files
 * on Firefox OS devices. The library is based on an event-based architecture, letting developers build
 * beautiful asynchronous API for their apps.
 *
 * The `Finder` library is best used by developers looking to pick a file from the `sdcard` for their apps.
 *
 * This library depends on [EventEmitter](https://github.com/Wolfy87/EventEmitter) by Wolfy87, included with the
 * package.
 *
 * @version 1.1.3
 * @license The MIT License (MIT)
 * @author Applait Technologies LLP
 * @copyright Copyright (c) 2014 Applait Technologies LLP
 */
var Applait=Applait||{};Applait.Finder=function(options){this.options=options||{},this.type=this.options.type||"sdcard",this.hidden=this.options.hidden||!1,this.casesensitive=this.options.caseSensitive||!1,this.minsearchlength=this.options.minSearchLength&&"number"==typeof this.options.minSearchLength?options.minSearchLength:3,this.debugmode=this.options.debugMode?!0:!1,this.storages=navigator.getDeviceStorages&&navigator.getDeviceStorages(this.type),this.searchcompletecount=0,this.filematchcount=0,this.searchkey=""},Applait.Finder.prototype=new EventEmitter,Applait.Finder.prototype.checkhidden=function(fullpath){return"/"===fullpath[fullpath.indexOf(".")-1]&&this.hidden!==!0?!1:!0},Applait.Finder.prototype.search=function(needle){var self=this;return self.reset(),self.searchkey=self.casesensitive?needle.trim():needle.trim().toLowerCase(),self.searchkey.length<self.minsearchlength?(self.log("searchCancelled",["Search string should be at least "+self.minsearchlength+" characters"]),self.emitEvent("searchCancelled",["Search string should be at least "+self.minsearchlength+" characters"]),null):self.storagecount()<1?(self.log("empty",[self.searchkey]),self.emitEvent("empty",[self.searchkey]),null):(self.log("searchBegin",[self.searchkey]),self.emitEvent("searchBegin",[self.searchkey]),void self.storages.forEach(function(storage){var cursor=storage.enumerate();self.log("storageSearchBegin",[storage.storageName,self.searchkey]),self.emitEvent("storageSearchBegin",[storage.storageName,self.searchkey]),cursor.onsuccess=function(){if(this.result){var file=this.result,fileinfo=self.splitname(file.name);self.matchname(fileinfo.name,file.name)&&(self.filematchcount++,self.log("fileFound",[file,fileinfo,storage.storageName]),self.emitEvent("fileFound",[file,fileinfo,storage.storageName])),this.done?(self.searchcompletecount++,self.log("storageSearchComplete",[storage.storageName,self.searchkey]),self.emitEvent("storageSearchComplete",[storage.storageName,self.searchkey])):this.continue()}else self.searchcompletecount++,self.log("storageSearchComplete",[storage.storageName,self.searchkey]),self.emitEvent("storageSearchComplete",[storage.storageName,self.searchkey]);self.searchcompletecount===self.storagecount()&&(self.log("searchComplete",[self.searchkey,self.filematchcount]),self.emitEvent("searchComplete",[self.searchkey,self.filematchcount]))},cursor.onerror=function(){self.log("error",["Error accessing device storage '"+storage.storageName+"'",this.error]),self.emitEvent("error",["Error accessing device storage '"+storage.storageName+"'",this.error])}}))},Applait.Finder.prototype.splitname=function(filename){return filename=filename.split(/[\\/]/),{name:filename.pop(),path:filename.join("/")}},Applait.Finder.prototype.storagecount=function(){return this.storages&&this.storages.length?this.storages.length:0},Applait.Finder.prototype.reset=function(){this.filematchcount=0,this.searchcompletecount=0,this.searchkey=""},Applait.Finder.prototype.log=function(message,args){this.debugmode&&console.log(message,args)},Applait.Finder.prototype.matchname=function(name,fullpath){return name=this.casesensitive?name.trim():name.trim().toLowerCase(),name.indexOf(this.searchkey)>-1&&this.checkhidden(fullpath)};