// Ionic Starter App

// angular.module is a global place for creating, registering and retrieving Angular modules
// 'starter' is the name of this angular module example (also set in a <body> attribute in index.html)
// the 2nd parameter is an array of 'requires'
angular.module('starter', ['ionic','starter.controllers','starter.services','angular-cache'])
// it's mandatory to extends the list of acceptable protocol to "app", which is 
// used by FirefoxOS packaged apps, otherwise URL using data binding would be 
// prefixed as "unsafe" by angular 
// cf. https://developer.mozilla.org/en-US/Apps/Tools_and_frameworks/common_libraries_and_frameworks
.config(['$compileProvider', function($compileProvider) 
{
  $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|app):/);
  $compileProvider.imgSrcSanitizationWhitelist(/^\s*(https?|ftp|mailto|app):/);
}])

.run(function($ionicPlatform, $ionicConfig) 
{
  $ionicPlatform.ready(function() 
  {
    $ionicConfig.views.maxCache(20);
    // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
    // for form inputs)
  /*  if(window.cordova && window.cordova.plugins.Keyboard) {
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
    }
    if(window.StatusBar) {
      StatusBar.styleDefault();
    }*/
  });
    
    
})

/**
 * New directive to create a handler fired when the binding is complete on the 
 *  element
 */ 
.directive('onBindingComplete', function() 
{
  return {
    link: function postLink(aScope, someElements, someAttributes) 
    {
      someElements.ready(function()
      {
        aScope.$eval(someAttributes.onBindingComplete);
      });
    },
  };
})

   
.config(function($stateProvider, $urlRouterProvider) {


$stateProvider


 
.state('live.today', 
{
  cache: true,
  url: '/today',
  views: 
  {
    matches: 
    {
      templateUrl: 'matches.html',
    }
  },
  data: 
  {
    nbDays: 0
  }
})

.state('live.yesterday', 
{
  cache: true,
  url: '/yesterday',
  views: 
  {
    matches: 
    {
      templateUrl: 'matches.html'
    }
  },
  data: 
  {
    nbDays: -1
  }
})

.state('live.tomorrow', 
{
  cache: true,
  url: '/tomorrow',
  views: 
  {
    matches: 
    {
      templateUrl: 'matches.html'
    }
  },
  data: 
  {
    nbDays: 1
  }
  
})



 .state('match.composition', 
{
  cache: false,
  url: '/composition',
  views: {
    matchDetailtabContent: 
    {
      templateUrl: 'composition.html'
    }
  }
})

.state('match.resume', 
{
  cache: false,
  url: '/resume',
  views: {
    matchDetailtabContent: 
    {
      templateUrl: 'resume.html'
    }
  }
})

.state('live', 
{
  cache: true,
  url: '/live',
  views: 
  {
    live: 
    {
      templateUrl: 'live.html'
    }
  },
  resolve:
  {
    // be sure the locale data is loaded 
    'LocaleManagerData':function(LocaleManager)
    {
      return LocaleManager.promise;
    }
  }
})

.state('match', 
{
  cache: false,
  url: '/match',
  views: 
  {
    live: 
    {
      templateUrl: 'match_details.html'
    }
  },
  controller: 'match',
  resolve:
  {
    // be sure the locale data is loaded 
    'LocaleManagerData':function(LocaleManager)
    {
      return LocaleManager.promise;
    }
  }
})

.state('news', 
{
  cache:true,
  url: '/news/:index',
  views: 
  {
    news: 
    {
      templateUrl: 'news.html'
    }
  },
  resolve:
  {
    // be sure the locale data is loaded 
    'LocaleManagerData':function(LocaleManager)
    {
      return LocaleManager.promise;
    }
  }
})
    
    
.state('home', {
  cache:true,
  url: '/home',
  views: {
    home: {
      templateUrl: 'home.html'
    }
  },
  resolve:
  {
    // be sure the locale data is loaded 
    'LocaleManagerData':function(LocaleManager)
    {
      return LocaleManager.promise;
    }
  }
})    

.state('homenews', 
{
  cache: true,
  url: '/homenews/:index',
  views: 
  {
    home: 
    {
      templateUrl: 'news.html',
    },
  },
  resolve:
  {
    // be sure the locale data is loaded 
    'LocaleManagerData':function(LocaleManager)
    {
      return LocaleManager.promise;
    }
  },
  data: 
  {
    pageTitle: "HOME_HEADLINESTITLE",
    category: 1
  }
})    
    

    
$urlRouterProvider.otherwise('/home');
    

})


