angular.module('starter.controllers', ['angularMoment','dcbImgFallback'])
// make LocaleManager available in all views
.run(function ($rootScope, LocaleManager,amMoment,$interval,$timeout) 
{    
  $rootScope.Locale = LocaleManager;
  $rootScope.appConfig = appConfig;
  $rootScope.setCurrentMatch = function(aMatch) 
  {
    $rootScope.match=aMatch;
    $rootScope.callingPage="#/live/"+((aMatch.day==LocaleManager.getLabel("DAY_TOMORROW"))?"tomorrow":(aMatch.day==LocaleManager.getLabel("DAY_YESTERDAY"))?"yesterday":"today");
  }
  amMoment.changeLocale(LocaleManager.getLocale());
  // periodically check if an update is available
  $interval(function()
  {
    var pending = navigator.mozApps.getSelf();
    pending.onsuccess = function () 
    {
      // Save the App object that is returned
      var application = this.result;
      if (application)
      {
        var pending=application.checkForUpdate();
        pending.onsuccess=function()
        {
        };
      }
    };
  },appConfig.checkForUpdatePeriod);
})

/**
 * Manage the home page
 */ 
.controller('home', function($scope, $state, newsFactory, matchesFactory, $ionicSlideBoxDelegate,LocaleManager,$element,$timeout,$ionicHistory) 
{

  console.log('reloading home');
  $scope.displayHeadlineCarousel=false;
  $scope.displayNewsCarousel=false;
  $scope.displayMatchCarousel=false;
  var view_element=$element.parent();
  function invalidateCache_()
  {
    console.log("invalidate cache for home");
    view_element.data('$noCache',true);
    $ionicHistory.viewHistory().histories[$scope.$historyId].cursor=-1;
    $ionicHistory.viewHistory().histories[$scope.$historyId].stack=[];
  }
  var cache_timeout=$timeout(invalidateCache_,appConfig.cacheMaxAge.news);

  // get the headline news
  newsFactory.getHeadlineNews()
  .then(
  function (response) 
  {
    $scope.headlineNews = response.data;
    $ionicSlideBoxDelegate.$getByHandle('home-headlines-carousel').loop(true);
    $scope.displayHeadlineCarousel=true;
  },
  function()
  {
    invalidateCache_(); 
    $timeout.cancel(cache_timeout);
  });
  newsFactory.getNews(0,0)
  .then(function (response) 
  {
      $scope.news = response.data;
      $ionicSlideBoxDelegate.$getByHandle('home-news-carousel').update();
      $ionicSlideBoxDelegate.$getByHandle('home-news-carousel').loop(true);
      $scope.displayNewsCarousel=true;
  },
  function()
  {
    invalidateCache_(); 
    $timeout.cancel(cache_timeout);
  })
  .finally(function ()
  {
  });
  matchesFactory.getMatchesSortedByCompetitions(0)
  .then(function (aResponse) 
  {
    if (!Object.keys(aResponse.data).length)
    {
      $scope.noMatchAvailable=LocaleManager.getLabel("MATCH_NOMATCHAVAILABLE");
    }
    else
    {
      $scope.matches = aResponse.allMatches;
      $ionicSlideBoxDelegate.$getByHandle('home-match-carousel').update();
      $ionicSlideBoxDelegate.$getByHandle('home-match-carousel').loop(true);
      $scope.displayMatchCarousel=true;
    }
  },
  function()
  {
    invalidateCache_(); 
    $timeout.cancel(cache_timeout);
  })
})

/**
 * Manage the matches, the number of days before or after today is passed as 
 * data by the current state (cf. app.js)
 */ 
.controller('matches', function($rootScope,$scope,matchesFactory,LocaleManager,$state,$ionicLoading,$timeout,$ionicHistory,$element) 
{
  // show a loader when showing the screen
  $ionicLoading.show(
  {
    content: 'Loading',
    animation: 'fade-in',
    showBackdrop: true,
    maxWidth: 200,
    showDelay: 0
  });
  var nb_days=0;
  // get parameters from current state, if any
  if ($state.current.data)
  {
    nb_days=$state.current.data.nbDays;
  }
  console.log('reloading matches for '+nb_days);
  var view_element=$element.parent().parent().parent();
  function invalidateCache_()
  {
    console.log("invalidate cache for matches");
    view_element.data('$noCache',true);
    $ionicHistory.viewHistory().histories[$scope.$historyId].cursor=-1;
    $ionicHistory.viewHistory().histories[$scope.$historyId].stack=[];
  }
  var cache_timeout=$timeout(invalidateCache_,appConfig.cacheMaxAge.matches);

  // actually get the data for the games
  matchesFactory.getMatchesSortedByCompetitions(nb_days)
  .then(function (aResponse) 
  {
    if (!Object.keys(aResponse.data).length)
      $scope.noMatchAvailable=LocaleManager.getLabel("MATCH_NOMATCHAVAILABLE");
    $scope.MatchesByCompetition = aResponse.data;
  },
  function()
  {
    invalidateCache_(); 
    $timeout.cancel(cache_timeout);
  })
  .finally(function() 
  {
    $ionicLoading.hide();
  });
  
  
})

/**
 * Manage match detail
 * The current match is passed via the rootscope (it's quite a dirty way of 
 * doing, but I've no other idea for now)
 */  
.controller('match', function($rootScope,$scope, $state,$timeout,$q,$ionicLoading,$ionicHistory,matchesFactory,LocaleManager) 
{
  // show a loader when showing the screen
  $ionicLoading.show(
  {
    content: 'Loading',
    animation: 'fade-in',
    showBackdrop: true,
    maxWidth: 200,
    showDelay: 0
  });
  var current_match=$rootScope.match;
  $rootScope.noInfoMessage=null;
  $rootScope.events=null;
  $rootScope.lineup = null;    
  $rootScope.team1 = null; 
  $rootScope.team2 = null; 
  
  $q.all([matchesFactory.getSummary(current_match.idMatch), matchesFactory.getLineup(current_match.idMatch)])
  .then(function (aResponse) 
  {
    $rootScope.events=aResponse[0].data;
    $rootScope.lineup = aResponse[1].data;    
    $rootScope.team1 = $scope.lineup.team1; 
    $rootScope.team2 = $scope.lineup.team2; 
    $state.go("match.resume");
  }, function(aResponse)
  {
    $rootScope.noInfoMessage=LocaleManager.getLabel("MATCH_NODATAAVAILABLE");
  })
  .finally(function() 
  {
    $ionicLoading.hide();
  });


  if ((current_match.status>6)&&(current_match.status<=14))
  {
    $scope.counter = 60;
    $scope.onTimeout = function()
    {
        if ($scope.counter > 0) 
        {
            $scope.counter--;
            mytimeout = $timeout($scope.onTimeout,1000);
        }
        else 
        {
          $rootScope.$broadcast('refreshr'); 
          $scope.counter = 60;
          $scope.onTimeout();
        }
    }
    var mytimeout = $timeout($scope.onTimeout,1000);
  }       
  
})


/**
 *  Manage resume
 */ 
.controller('resume', function($rootScope,$scope,  matchesFactory) 
{
  $scope.$on('refreshr', function (event) 
  {
    matchesFactory.getSummary($rootScope.match.idMatch)
    .then(function (response) 
    {
      $scope.events = response.data;
    });
 }) 
 
})

/**
 * Manage composition
 */ 
.controller('composition', function($rootScope,$scope, matchesFactory) 
{
  // nothing to do yet (would be good to add the link to wikipedia)
})


/**
 * Manage news
 */ 
.controller('news', function($scope, newsFactory, $ionicSlideBoxDelegate,$ionicLoading,$stateParams,$state,LocaleManager,$element,$timeout,$ionicHistory) 
{
  console.log('reloading news');
  var view_element=$element.parent();
  function invalidateCache_()
  {
    console.log("invalidate cache for news");
    view_element.data('$noCache',true);
    $ionicHistory.viewHistory().histories[$scope.$historyId].cursor=-1;
    $ionicHistory.viewHistory().histories[$scope.$historyId].stack=[];
  }
  var cache_timeout=$timeout(invalidateCache_,appConfig.cacheMaxAge.news);


  // show a loader when showing the screen
  $ionicLoading.show(
  {
    content: 'Loading',
    animation: 'fade-in',
    showBackdrop: true,
    maxWidth: 200,
    showDelay: 0
  });
  
  var category, has_more_news=true;
  // get parameters from current state, if any
  if (($state.current.data)&&($state.current.data.pageTitle))
    $scope.pageTitle=LocaleManager.getLabel($state.current.data.pageTitle);
  else
    $scope.pageTitle=LocaleManager.getLabel("HOME_NEWSTITLE");
  if ($state.current.data)
    category=$state.current.data.category;

  // get the current index from URL parameters
  $scope.myActiveSlide=$stateParams.index;


  // actually get the news
  newsFactory.getNews(category,0)
  .then(function(aResponse) 
  {
    has_more_news=!((aResponse.data.length==0)||(aResponse.data.length!=10))
    $scope.news = aResponse.data;
  },
  function()
  {
    invalidateCache_(); 
    $timeout.cancel(cache_timeout);
  })
  .finally(function() 
  {
    $ionicLoading.hide();
  });



  /**
   * Check if there are some news before
   */
  $scope.hasPreviousNews=function()
  {
    return $ionicSlideBoxDelegate.currentIndex();
  }
       
  /**
   * Check if there are some news after the current one
   */
  $scope.hasNextNews=function()
  {
    return has_more_news||($ionicSlideBoxDelegate.currentIndex()!=($scope.news.length-1));
  }
       
  /**
   * Check if there are more news to load
   */
  $scope.hasMoreNews=function()
  {
    return has_more_news;
  }
       
  /**
   * Handle slide changes
   */         
  $scope.slideHasChanged = function(anIndex) 
  {
    if ($scope.currentPlayingVideoPlayer)
    {
      $scope.currentPlayingVideoPlayer.stopVideo();
      $scope.currentPlayingVideoPlayer=null;
    }
    var nb_news= $scope.news.length;
    if(anIndex == nb_news)
    { 
      newsFactory.getNews(category,nb_news)
      .then(function (aResponse) 
      {
        has_more_news=!((aResponse.data.length==0)||(aResponse.data.length!=10));
        $scope.news.push.apply($scope.news,aResponse.data);
        $ionicSlideBoxDelegate.update();    
      },function() 
      {
        // if we are on the very slide (the one with the spinner), go one slide back
        if ($ionicSlideBoxDelegate.currentIndex() == ($ionicSlideBoxDelegate.slidesCount()-1))
        {
          $ionicSlideBoxDelegate.previous();
        }
      })       
    }
  };    
    
  /**
   * handle click on header left button
   */         
  $scope.next = function () 
  {
      $ionicSlideBoxDelegate.next();
  };

  /**
   * handle click on header right button
   */         
  $scope.previous = function () 
  {
      $ionicSlideBoxDelegate.previous();
  }; 
  
  /**
   * Parse the HTML code generated from the description of the article and add
   * target=top to all <a> with href   
   */       
  $scope.preventExternalLinksInDescription=function(anArticle)
  {
    var top_node=document.getElementById("desc"+anArticle.idNews);
    if (top_node)
    {
      var anchors=top_node.getElementsByTagName('A');
      for (var i=0;i<anchors.length;i++)
      {
        if (!anchors[i].target)
          anchors[i].setAttribute("target","top");
      }
    }
  }


  /**
   * Manage dailymotion videos   
   */       
  $scope.manageDMVideo=function(anArticle)
  {
    var player = DM.player("dmp"+anArticle.idNews, {video: anArticle.video,params: {fullscreen: 0,autoplay:1}});
    player.addEventListener("apiready", function(anEvent)
    {
      // this is to prevent top links that could happen on the video player 
      anEvent.target.setAttribute("sandbox","allow-forms allow-pointer-lock allow-popups allow-same-origin allow-scripts");
    });
    player.addEventListener("play", function(anEvent)
    {
      $scope.currentPlayingVideoPlayer=anEvent.target;
    });
    player.stopVideo=function()
    {
      this.pause();
      // this is a strange workaround for a DM bug on firefox : once a DM video 
      // has been played, there is no way to play another video, even from 
      // youtube. I guess it's a matter of kind of missing unlocking resources.
      // the only solution I found is to actually delete and recreate the player
      var player_parent=this.parentNode,player_id=this.id, player_stop_video_function=this.stopVideo;
      player_parent.removeChild(this);
      var div=document.createElement("div");
      div.setAttribute('id',player_id);
      player_parent.appendChild(div);
      var player2 = DM.player(div, {video: anArticle.video,params: {fullscreen: 0,autoplay:1}});
      player2.stopVideo=player_stop_video_function;
      player2.addEventListener("apiready", function(anEvent)
      {
        // this is to prevent top links that could happen on the video player 
        anEvent.target.setAttribute("sandbox","allow-forms allow-pointer-lock allow-popups allow-same-origin allow-scripts");
      });      
      player2.addEventListener("play", function(anEvent)
      {
        $scope.currentPlayingVideoPlayer=anEvent.target;
      });
    };
  }
  
  
  /**
   * Manage youtube videos   
   */       
  $scope.manageYTVideo=function(anArticle)
  {
    var player = new YT.Player("ytp"+anArticle.idNews, 
    {
      videoId: anArticle.video,
      events:{
        onStateChange:function(anEvent)
        {
          if ((anEvent.data==-1)||(anEvent.data==1)||(anEvent.data==3))
            $scope.currentPlayingVideoPlayer=anEvent.target;
        }
      }
    });
    // this is to prevent top links that could happen on the video player 
    document.getElementById("ytp"+anArticle.idNews).setAttribute("sandbox","allow-forms allow-pointer-lock allow-popups allow-same-origin allow-scripts");
  }
  
  
  
  
  

})




