angular.module('starter.services', [])
.factory('LocaleManager', function ($http) 
{
  var LocaleManager=
  {
    labels_:{}
  };
  
   /**
    * return the label for the specified key
    */       
  LocaleManager.getLabel=function(aKey)
  {
    return this.labels_[aKey]
  }
  
  /**
   * Return the female ordinal label for the specified number
   */
   LocaleManager.getOrdinalF=function(anIndex)
   {
    return ""+anIndex+(this.labels_["ORDINALF_"+anIndex]||this.labels_["ORDINALF_"+anIndex])
   }     
  
  /**
   * Return the locale
   */     
  LocaleManager.getLocale=function()
  {
    if (navigator.language.indexOf('en')==0)
      return "en";
    if (navigator.language.indexOf('fr')==0)
      return "fr";
    for (var i=0;i<navigator.languages.length;i++)
    {
      if (navigator.languages[i].indexOf('en')==0)
        return "en";
      if (navigator.languages[i].indexOf('fr')==0)
        return "fr";
    }
    return LocaleManager.getDefaultLocale_(); 
  }
  
  /**
   * Return the default locale
   */     
  LocaleManager.getDefaultLocale_=function()
  {
    return "fr";
  }
  
  /**
   * Asynchronously load the locale data
   */     
  LocaleManager.promise = $http.get('locales/'+LocaleManager.getLocale()+'.json').success(
    function (someData) 
    {
      LocaleManager.labels_= someData;
    });

  return LocaleManager;
})





.factory('newsFactory', function ($http,CacheFactory,LocaleManager) 
{
	var news={};

  /**
   * Return the cache to be used
   */
  news.getCache_=function()
  {
	  var cache=CacheFactory.get('newsCache');            
    if (!cache)
    {
    	return CacheFactory.createCache('newsCache', 
      {
        maxAge: appConfig.cacheMaxAge.news, 
        deleteOnExpire: 'passive' // expired items are deleted only when requested 
      });
    }
  	return cache;
  }
  
  /**
   *  Send a "user" request, i.e. a request that require the user token
   *  First send a request to get this token if not available    
   */
	news.sendUserRequest_ = function(aRequest)
	{
		if (!this.authentToken_)
		{
			return $http({method:"POST",url:appConfig.URL+"social/identity/auth/bydeviceid/toto",headers: {'X-SocialAPI-Service-Name': 'ofc'}}).then
				(
					function(aResponse)
					{
						this.authentToken_=aResponse.token;
						var headers=aRequest.headers||(aRequest.headers={});
						headers.token=this.authentToken_;
						return $http(aRequest);
					},
					this.onHttpError_
				)
		}
		else
		{
			var headers=aRequest.headers||(aRequest.headers={});
			headers.token=this.authentToken_;
			return $http(aRequest);
		}
	}

  /**
   *  return the news
   */
	news.getNews = function(aCategory,anOffset,aNbNews=10)
	{
    var url=appConfig.URL+"ofc/news";
	  if (aCategory)
	  {
	   url=url+"/category/"+aCategory;
    }
    url=url+"?offset="+anOffset+"&limit="+aNbNews;
		var promise=$http({method:"GET",url:url,cache:this.getCache_()});
		promise.then(null,this.onHttpError_);
		return promise;
	}
	
  /**
   *  return the headline news
   */
	news.getHeadlineNews = function()
	{
		return this.getNews(1,0);
	}
	
	/**
	 * manage error cases
	 */
	news.onHttpError_ = function(anObject)
	{
    alert(LocaleManager.getLabel("ERROR_CANTGETNEWS"));
	}

  return news;

})





/**
 * Factory for games (matches)
 */ 
.factory('matchesFactory', ['$http','CacheFactory','$q', 'LocaleManager',function ($http,CacheFactory,$q,LocaleManager) 
{
	var matches={};
	
  /**
   * Return the cache to be used for matches
   */
  matches.getCacheMatches_=function()
  {
	  var cache=CacheFactory.get('matchesCache');            
    if (!cache)
    {
    	return CacheFactory.createCache('matchesCache', 
      {
        maxAge: appConfig.cacheMaxAge.matches, 
        deleteOnExpire: 'passive' // expired items are deleted only when requested 
      });
    }
  	return cache;
  }
  
  /**
   * Return the cache to be used for competitions and groups
   */
  matches.getCacheCompetitions_=function()
  {
	  var cache=CacheFactory.get('competitionsCache');            
    if (!cache)
    {
    	return CacheFactory.createCache('competitionsCache', 
      {
        maxAge: appConfig.cacheMaxAge.competitions, 
        deleteOnExpire: 'passive' // expired items are deleted only when requested 
      });
    }
  	return cache;
  }
  

  /**
   *  return the specified date as a String
   */
  matches.formatDateAsParameter_=function(aDate)
  {
    return ""+aDate.getFullYear()+"-"+(aDate.getMonth()+1)+"-"+(aDate.getDate());
  }
  
  /**
   *  return the competitions
   *    
   */
  matches.getCompetitions=function()
  {
    var promise=$http({method:"GET",url:appConfig.URL+"/ofc/competitions",cache:this.getCacheCompetitions_()});
    promise.then(null,this.onHttpError_);
    return promise;  
  } 

  /**
   *  return the groups
   */
  matches.getGroups=function()
  {
    var promise=$http({method:"GET",url:appConfig.URL+"/ofc/groups",cache:this.getCacheCompetitions_()});
    promise.then(null,this.onHttpError_);
    return promise;  
  } 


  /**
   *  return the matches
   *  aNbDays : the number of day after today (negative to get before today)   
   */
	matches.getMatches = function(aNbDays=0)
	{
	  var zis=this;
    // compute the date param
//    var date=new Date(2015,5,6);
    var date=new Date();
    date.setDate(date.getDate()+aNbDays)  
    date_param=this.formatDateAsParameter_(date);
    // actually get the games and enrich them with newstartdate and day 
    return $http({method:"GET",url:appConfig.URL+"/ofc/matches?date="+date_param,cache:this.getCacheMatches_()})
	   .then(function(aResponse)
	   {
        var matches=aResponse.data;
        var today_date=new Date();
        // go through the matches
        for (var i=0;i<matches.length;i++)
        {
          // add a statusString
          if ((matches[i].status=="1")||(matches[i].status=="2")||(matches[i].status=="3")) matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS123");
          else if (matches[i].status=="4") matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS4");         
          else if (matches[i].status=="5")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS5");         
          else if (matches[i].status=="6")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS6");        
          else if (matches[i].status=="7")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS7");        
          else if (matches[i].status=="8")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS8");        
          else if (matches[i].status=="9")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS9");        
          else if (matches[i].status=="10")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS10");        
          else if (matches[i].status=="11")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS11");        
          else if (matches[i].status=="12")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS12");        
          else if (matches[i].status=="13")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS13");
          else if (matches[i].status=="14")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS14");
          else if (matches[i].status=="15")matches[i].statusStr=LocaleManager.getLabel("MATCH_STATUS15");
          // set the date as a string
          var start_date_str=matches[i].startDate;
          matches[i].newstartdate=zis.convertDate_(start_date_str);
          // set the day 
          var start_date=new Date(Date.parse(start_date_str.replace(' ', 'T') + "Z"));
          if (start_date.getDay()==today_date.getDay())
            matches[i].day=LocaleManager.getLabel("DAY_TODAY");
          else if (start_date.getTime() < today_date.getTime())
            matches[i].day=LocaleManager.getLabel("DAY_YESTERDAY");
          else
            matches[i].day=LocaleManager.getLabel("DAY_TOMORROW");
          // set the date
          matches[i].date=start_date_str.substring(0,10);
          // set the time
          matches[i].time=zis.convertDate_(start_date_str);
        }
        var deferred=$q.defer();
        deferred.resolve({data:matches});
        return deferred.promise;
     },this.onHttpError_);
	}



  /**
   *  return the matches sorted by competitions
   *  aNbDays : the number of day after today (negative to get before today)   
   */
	matches.getMatchesSortedByCompetitions = function(aNbDays=0)
	{
   	var zis=this;
    return $q.all([zis.getMatchesSortedByDate(aNbDays), zis.getCompetitions(),zis.getGroups()])
    .then(function (aResponse) 
    {
      var matches=aResponse[0].data;
      var competitions=aResponse[1].data;
      var groups=aResponse[2].data;
      // will list all the match of all competitions 
      var matches_by_competitions={};
      // go through the matches
      for (var i=0;i<matches.length;i++)
      {
        // manage group
        var match_group_id=matches[i].idGroup;
        if (match_group_id != -1)
        {
          for (var j=0;j<groups.length;j++)
          {
            if (groups[j].idGroup == match_group_id)
            {
              matches[i].groupName=groups[i].name;
              matches[i].groupNumDays=groups[i].numDays;
              matches[i].groupType=groups[i].type;
              if ((matches[i].groupType==2)&(matches[i].groupName=="Groupe Unique")) 
              { 
                matches[i].groupDescription=LocaleManager.getOrdinalF(matches[i].groupNumDays)+" "+LocaleManager.getLabel("MATCH_GROUPDAY");
              }
              else if ((matches[i].groupType==1)||(matches[i].groupType==2))
              { 
                matches[i].groupDescription = matches[i].groupName;
              }
            }
          }
        }
        // manage competition
        var match_competition_id=matches[i].idCompetition;
        // if the competition of the current match has already been registered 
        // in the list, add the match in this register
        if  (matches_by_competitions[match_competition_id])
        {
          matches_by_competitions[match_competition_id].matches.push(matches[i]);
          matches[i].competitionName=matches_by_competitions[match_competition_id].name;
        }
        // otherwise register the competition, try to find its name among the 
        // existing competitions and add the match 
        else
        {
          var match_by_competition={name:"",matches:[matches[i]]};
          matches_by_competitions[match_competition_id]=match_by_competition;
          for (var j=0;j<competitions.length;j++)
          {
            if (competitions[j].idCompetition == match_competition_id)
            {
              match_by_competition.name=competitions[j].name;
              matches[i].competitionName=competitions[j].name;
              break;
            }
          }
        }
      }
      var deferred=$q.defer();
      deferred.resolve({data:matches_by_competitions,allMatches:matches});
      return deferred.promise;
    });   
  }
   
 // Sort matches by date   
     matches.getMatchesSortedByDate = function(aNbDays=0)
  {
     var zis=this;
     var matchessorted =[];
     var date=new Date();
     date.setDate(date.getDate()+aNbDays)  
     return $q.all([zis.getMatches(0),zis.getMatches(1),zis.getMatches(-1)])
     .then(function (aResponse) 
      {
      var matches=aResponse[0].data.concat(aResponse[1].data).concat(aResponse[2].data);

     for (var i=0;i<matches.length;i++)  
         {
    
          var start_date_str=matches[i].startDate;
          matches[i].newstartdate=zis.convertDate_(start_date_str);
          var start_date=new Date(Date.parse(start_date_str.replace(' ', 'T') + "Z"));
          if (start_date.getDay()==date.getDay())
          matchessorted.push(matches[i]);     

         }
     var deferred=$q.defer();
     deferred.resolve({data:matchessorted});
     return deferred.promise;  
    
   
        
      }); 
           

  }
	
	/**
	 * Return the summary
	 */
	matches.getSummary = function(aMatchId)
  {
    var promise=$http({method:"GET",url:appConfig.URL+"/ofc/matches/"+aMatchId+"/events"/*,cache:this.getCache_()*/});
    promise.then(null,this.onHttpError_);
    return promise;  
  }      	
  
	/**
	 * Return the lineup
	 */
	matches.getLineup = function(aMatchId)
  { 
    var zis=this;
    var promise=$http({method:"GET",url:appConfig.URL+"/live/lineup/fr_lineup_"+aMatchId+".json"/*,cache:this.getCache_()*/});
    promise.then(function(aResponse)
    {
      var lineup=aResponse.data;
      lineup.team1 = lineup.team1.sort(zis.sortById_); 
      lineup.team2 = lineup.team2.sort(zis.sortById_);
      var deferred=$q.defer();
      deferred.resolve({data:lineup});
      return deferred.promise;
    },
    function(aResponse)
    {
      var deferred=$q.defer();
      deferred.resolve({data:""});
      return deferred.promise;
    });
    return promise;  
  } 
  
  /**
   *  convert the date
   */
  matches.convertDate_ = function(aDate) 
  {
    var dt = new Date(aDate.replace(' ', 'T') + "Z");
    var hours = dt.getHours();
    var minutes = dt.getMinutes().toString(); 
    if (minutes.length==1) minutes="0"+minutes;
    
    var rdate=""+hours+":"+minutes;
    return rdate;
  }
 
	
  /**
   *  compare to player (used to sort the lineup)
   */
  matches.sortById_ = function(aPlayer1, aPlayer2) 
  {
    return aPlayer1.idSpecificRole > aPlayer2.idSpecificRole
  }
 
	
	/**
	 * manage error cases
	 */
	matches.onHttpError_ = function(aResponse)
	{
    alert(LocaleManager.getLabel("ERROR_CANTGETMATCHES"));
	}

  return matches;

}]);