//
//	chapter_chooser_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function ChapterChooserController(base) {
  this.name = "chapter-chooser";
  this.base = base;
}


ChapterChooserController.prototype.init = function() {
  this.templates = [];

  this.base.loadTemplate(this, "main");
  this.base.loadTemplate(this, "list_item");
  this.base.loadTemplate(this, "list_divider");
	this.base.loadTemplate(this, "msg");

  this.chapters = {items: [
		{category:$L("Training"), title:$L("Training"), name:0},

		{category:$L("Chapter 1"), title:$L("In the Woods"), name:1},
		{category:$L("Chapter 1"), title:$L("Don't Leave the Path"), name:2},
		{category:$L("Chapter 1"), title:$L("Let's Go!"), name:3},
		//{category:$L("Chapter 1"), title:$L("Round"), name:15},
		
		{category:$L("Chapter 2"), title:$L("Connections"), name:4},
		{category:$L("Chapter 2"), title:$L("Watch Out!"), name:5},
		{category:$L("Chapter 2"), title:$L("Enlightened"), name:6},
		//{category:$L("Chapter 2"), title:$L("Bumper"), name:14},
		{category:$L("Chapter 2"), title:$L("Switch it On"), name:7},
		{category:$L("Chapter 2"), title:$L("You're Not Alone"), name:8},

		{category:$L("Chapter 3"), title:$L("Math Quiz"), name:9},
		{category:$L("Chapter 3"), title:$L("Lasers"), name:10},
		{category:$L("Chapter 3"), title:$L("A Bit of Everything"), name:11},
		{category:$L("Chapter 3"), title:$L("Attraction"), name:12},

		{category:$L("Impossible?!"), title:$L("Three Last Tricks"), name:13}
  ]};
}


ChapterChooserController.prototype.setup = function() {
  //Zepto('#screen').html(this.templates.main);

  Zepto("#buttonBack").html($L("Back"));

  // handle active/inactive
  for (var i=0; i<this.chapters.items.length; ++i) {
		this.chapters.items[i].disabled = !data.getChapterAvailable(this.chapters.items[i].name);
		
		this.chapters.items[i].cssclass = "title list-enabled";
		if (this.chapters.items[i].disabled) {
	    this.chapters.items[i].cssclass = "title list-disabled";
		}	
		//this.chapters.items[i].tap = this.chapters.items[i].disabled ? "" : 'x-Mojo-tap-highlight="momentarily"';
		
		this.chapters.items[i].icon = '';
		if (data.getChapterDone(this.chapters.items[i].name)) {
	    this.chapters.items[i].icon = '<img src="images/smilie.png" align="right" style="height:32px;" />';
		}
  }
  
  this.compiled_templates = {};
  this.compiled_templates.main = Handlebars.compile(this.templates.main);
  this.compiled_templates.list_item = Handlebars.compile(this.templates.list_item);
  this.compiled_templates.list_divider = Handlebars.compile(this.templates.list_divider);

  // draw
  var content = "";
  var cur_category = "";
  for (var item_id=0; item_id<this.chapters.items.length; item_id++) {
		if (this.chapters.items[item_id].category != cur_category) {
	    content = content + this.compiled_templates.list_divider({divider_label: this.chapters.items[item_id].category});
	    cur_category = this.chapters.items[item_id].category;
		}
		content = content +  this.compiled_templates.list_item(this.chapters.items[item_id]);
  }

  Zepto('#chapter_list').html(content);
}


ChapterChooserController.prototype.activate = function() {
  Zepto("#screen").on('click', Zepto.proxy(function(event) {
		this.handleClickEvent(event);
  }, this));
}


ChapterChooserController.prototype.show = function() {
  //Zepto('#content').css('visibility', 'visible');	
}


ChapterChooserController.prototype.deactivate = function() {
  Zepto("#screen").off('click');
  //Zepto('#content').css('display', 'none');
}


ChapterChooserController.prototype.handleClickEvent = function(event) {
  event.stopPropagation();
  var id = event.target.id;
  if ( id === "buttonBack" ) {
		this.base.showView(0)
  } else {
		var item = this.chapters.items[id];
		//var index = event.model.items.indexOf(event.item);

		if (typeof item != 'undefined') {
	    if (item.disabled) {
				document.getElementById("msg").style.position = "absolute";
				document.getElementById("msg").style.width = "270px";
				document.getElementById("msg").style.height = "auto";
				document.getElementById("msg").style.top = Math.round((480-133)/2)+"px";
				document.getElementById("msg").style.left = Math.round((320-270-2*2-2*6)/2)+"px";
				document.getElementById("msg").style.background = "rgba(230, 230, 230, 0.9)";
				document.getElementById("msg").style.border = "2px solid darkgray";
				document.getElementById("msg").style.padding = "6px";

				message_text = $L("These levels are only available in the full version of OrbLand! <br/><a target='_blank' href='https://marketplace.firefox.com/app/orbland'>Check it out in the Marketplace!</a>");
				
				message_compiled_template = Handlebars.compile(this.templates.msg);
				message_context = { title: 'OrbLand Labyrinth Free',
														text: new Handlebars.SafeString(message_text),
														ok_button_text: $L('Okay') };
				
				Zepto("#msg").html(message_compiled_template(message_context));
				
				Zepto("#msgOverlay").css('visibility', 'visible');;
				Zepto("#btnOk").on('click', function() {
					Zepto("#msgOverlay").css('visibility', 'hidden');
					Zepto("#btnOk").off('click');
				});
				
				return;
	    }
	    data.setCurrentChapter(item.name);
	    this.base.showView(2);
		}    
  }
}