//
//	info_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function InfoController(base) {
    this.name = "info";
    this.base = base;
}

InfoController.prototype.init = function() {
    this.templates = [];
    this.base.loadTemplate(this, "main");
    this.base.loadTemplate(this, "info_text", language.lang_code);
}


InfoController.prototype.setup = function() {
    //Zepto('#screen').html(this.templates.main);

    Zepto("#buttonBack").html($L("Back"));
    
    Zepto("#title").html("About OrbLand");//($L("About OrbLand"));
    if (!language.isBaseLanguage()) {
	Zepto("#info_text").html(this.templates.info_text);
    }
}


InfoController.prototype.activate =  function() {
    Zepto("#screen").on('click', 'button', Zepto.proxy(function(event) {
	this.handleClickEvent(event);
    }, this));
}


InfoController.prototype.show = function() {
    //Zepto('#content').css('visibility', 'visible');
}


InfoController.prototype.deactivate = function() {
    Zepto("#screen").off('click');
    //Zepto('#content').css('display', 'none');
}


InfoController.prototype.handleClickEvent = function(event) {
    var id = event.target.id;
    if ( id === "buttonBack" ) {
	this.base.showView(0);
    } 
}
