//
//	level_chooser_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function LevelChooserController(base) {
  this.name = "level-chooser";
  this.base = base;
}


LevelChooserController.prototype.init = function() {	

  //this.chapter = data.getCurrentChapter();

  this.chapter_info = [
		{title:$L("Training"), name:0, imgFolder:'images', info:$L("Try these levels first to get to know the Orb.")},
		{title:$L("In the Woods"), name:1, imgFolder:'images', info:$L("Guide the Orb to the exit of these dark woods.")},
		{title:$L("Don't Leave the Path"), name:2, imgFolder:'images', info:$L("Make sure the Orb does not fall off the edge.")},
		{title:$L("Let's Go!"), name:3, imgFolder:'images', info:$L("Try to find your way through these labyrinths.")},
		{title:$L("Connections"), name:4, imgFolder:'images', info:$L("The pipes will lead you to the goal. But be careful, some of them are tricky.")},
		{title:$L("Watch Out!"), name:5, imgFolder:'images', info:$L("Don't let the evil mines get you.")},
		{title:$L("Enlightened"), name:6, imgFolder:'images_stone', info:$L("Let the colors guide your way.")},
		{title:$L("Switch it On"), name:7, imgFolder:'images', info:$L("Hit the right switches to clear the way.")},
		{title:$L("You're Not Alone"), name:8, imgFolder:'images', info:$L("The Orb brought his friends. That doesn't mean it's getting easier.")},
		{title:$L("Math Quiz"), name:9, imgFolder:'images_stone', info:$L("Correct the equations to reach your goal.")},
		{title:$L("Lasers"), name:10, imgFolder:'images_stone', info:$L("Don't let them catch you on your way through the labyrinth.")},
		{title:$L("A Bit of Everything"), name:11, imgFolder:'images', info:$L("Guide the Orb through these little adventures.")},
		{title:$L("Attraction"), name:12, imgFolder:'images_stone', info:$L("Magnets might repel or attract the Orb. You never know.")},
		{title:$L("Three Last Tricks"), name:13, imgFolder:'images', info:$L("The last obstacles on the Orb's way to break free.")}
  ]; /*,
			 {title:$L("Bumper"), name:14, imgFolder:'images', info:$L("Bumpers..TODO!")},
			 {title:$L("Round"), name:15, imgFolder:'images', info:$L("Round...TODO!")}
			 ];*/

  this.templates = [];
  this.base.loadTemplate(this, "main");
  this.base.loadTemplate(this, "info_text");
  this.base.loadTemplate(this, "grid_tile");

}


LevelChooserController.prototype.setup = function() {
  //Zepto('#screen').html(this.templates.main);

  this.chapter = data.getCurrentChapter();
  this.lvlCount = data.lvlCount[this.chapter];

  var info_compiled_template = Handlebars.compile(this.templates.info_text);
  var info_content = "";

  var cur_chapter_info = this.chapter_info[this.chapter];
  info_content = info_compiled_template(cur_chapter_info);
  this.imgFolder = cur_chapter_info.imgFolder;
  
	if (this.imgFolder != "images") {
		Zepto("#content").css("background-image", "url('"+this.imgFolder+"/background.jpg')");
	}
  Zepto("#buttonBack").html($L("Back"));

  Zepto("#chapter_description").html(info_content);

  // init
  this.lastDoneLevel = 0;

  // populate grid with level previews
  var grid_content = "";
  var grid_tile_compiled_template = Handlebars.compile(this.templates.grid_tile);
  var grid_tile_context = {i: 0,
													 imgFolder: this.imgFolder};

  for (var i = 1; i <= this.lvlCount; ++i) {
		grid_tile_context.i = i
		grid_content += grid_tile_compiled_template(grid_tile_context);
  }
  grid_content += '<br />';

  Zepto("#levels_grid").html(grid_content);

  for (var cur_level = 1; cur_level <= this.lvlCount; ++cur_level) {
		var highscore = level_service.getHighscore(this.chapter, cur_level, settings.get("physics"));
		this.drawLevelPreview(cur_level, highscore);
  }
}


LevelChooserController.prototype.activate = function(event) {
  Zepto("#buttonBack").on('click', Zepto.proxy(function(event) {
		this.handleClickEvent(event);
  }, this));	

  for (var cur_level = 1; cur_level <= this.lvlCount; ++cur_level) {
		if (cur_level <= this.lastDoneLevel + 1) {
	    Zepto("#divlvl" + cur_level).on('click', Zepto.proxy(function(event) {
				this.handleClickEvent(event);
	    }, this));	
		}
  }
}


LevelChooserController.prototype.show = function() {
  //Zepto('#content').css('visibility', 'visible');
}


LevelChooserController.prototype.deactivate = function(event) {
  for (var cur_level = 1; cur_level <= this.lvlCount; ++cur_level) {
		if (cur_level <= this.lastDoneLevel + 1) {
	    Zepto("#divlvl" + cur_level).off('click');
		}
  }
  Zepto("#screen").off('click');
}


LevelChooserController.prototype.handleClickEvent = function(event) {
  event.stopPropagation();
  var id = event.target.id;
  if ( id === "buttonBack" ) {
		this.base.showView(1);
  } else {
		//data.setCurrentLevel(((event.target.id).split("lvl"))[1]);
		data.setCurrentLevel((id.split("lvl"))[1]);
		this.base.showView(3);
  }
}

//******************************

LevelChooserController.prototype.drawLevelPreview = function(level, highscore) {
  
  if (highscore["time"]) {
		Zepto("#highscore" + level).html(sprintf($L("Record: %s"), niceTime(highscore["time"])));
		this.lastDoneLevel = level;
  }

  if (level <= this.lastDoneLevel + 1) {
		Zepto("#lvl" + level).attr("src", "resources/levels/" + this.chapter + "/" + level + ".png");
		Zepto("#lvl" + level).attr("class", "level_preview");
		//this.controller.listen(("divlvl" + level), Mojo.Event.tap, this._lvlPreviewTap);
  } else {
		Zepto("#lvl" + level).attr("src", this.imgFolder + "/level_hidden.png");
		Zepto("#lvl" + level).attr("class", "level_preview-disabled");
  }
}

