//
//	main_menu_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function MainMenuController(base) {
    this.name = "main-menu";
    this.base = base;
}


MainMenuController.prototype.init = function() {
    this.templates = [];
    this.base.loadTemplate(this, "main");

    //require(['install-button']);
}


MainMenuController.prototype.setup = function() {
    //Zepto('#screen').html(this.templates.main);
    
    Zepto('#buttonStart').html($L('Start Game'));
    Zepto('#buttonLevelSelect').html($L('Select Level'));
    Zepto('#buttonSettings').html($L('Settings'));
    Zepto('#buttonInfo').html($L('Info'));

    Zepto('#buttonInstall').html($L('Install'));
}


MainMenuController.prototype.activate = function() {
    Zepto("#screen").on('click', 'button', Zepto.proxy(function(event) {
	this.handleClickEvent(event);
    }, this));
    
    //this.install_button = require(['install-button'], function(install_button) {install_button.init();});
}


MainMenuController.prototype.show = function() {
    //Zepto('#content').css('visibility', 'visible');
}


MainMenuController.prototype.deactivate = function() {
    //Zepto('#content').css('display', 'none');
    Zepto("#screen").off('click');
}


MainMenuController.prototype.handleClickEvent = function(event) {
    var id = event.target.id;
    if ( id === "buttonStart" ) {
	this.base.showView(3);
    } 
    else if ( id === "buttonLevelSelect" ) {
	this.base.showView(1);
    } 
    else if ( id === "buttonSettings" ) {
	this.base.showView(4);
    } 
    else if ( id === "buttonInfo" ) {
	this.base.showView(5);
    }
}

/*
  MainMenuController.prototype.updateInstallButton = function() {
  var btn = document.getElementById('buttonInstall');
  if(this.install.state == 'uninstalled') {
  btn.style.display = 'block';
  }
  else if(this.install.state == 'installed' || install.state == 'unsupported') {
  btn.style.display = 'none';
  }
  }

  MainMenuController.prototype.initInstallButton = function() {
  var btn = document.getElementById('buttonInstall');
  btn.addEventListener('click', function() {
  this.install();
  });

  this.install.on('change', this.updateInstallButton);
  
  this.install.on('error', function(e, err) {
  // Feel free to customize this
  alert('There was an error during installation.');
  });

  this.install.on('showiOSInstall', function() {
  // Feel free to customize this
  alert('To install, press the forward arrow in Safari ' +
  'and touch "Add to Home Screen"');
  });
  }
*/
