//
//	settings_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function SettingsController(base) {
  this.name = "settings";
  this.base = base;
}

SettingsController.prototype.init = function() {
  this.templates = [];
  this.base.loadTemplate(this, "main");
}


SettingsController.prototype.setup = function() {
  //Zepto('#screen').html(this.templates.main);

  Zepto("#buttonBack").html($L("Back"));
  Zepto("#title").html($L("Settings"));
  Zepto("#language_title").html($L("Language"));
  Zepto("#sound_title").html($L("Sound"));
  Zepto("#vibrate_title").html($L("Vibration"));
  Zepto("#reset_title").html($L("Reset"));

  for (var i in language.supported_languages) {
		var language_name = language.supported_languages[i];
		var language_code = language.supported_lang_codes[i];
		var selected = "";
		if (language_code === settings.get("language")) {
	    selected = "selected";
		}
		Zepto('#select_language').append("<option id='"+language_code+"'"+selected+">"+language_name+"</option>");
  }

  if(settings.get("sound")) {
		Zepto('#switch_sound').prop('checked', 'true');
  } else {
		Zepto('#switch_sound').removeAttr('checked');
  }

  if(settings.get("vibrate")) {
		Zepto('#switch_vibrate').prop('checked', 'true');
  } else {
		Zepto('#switch_vibrate').removeAttr('checked');
  }

}


SettingsController.prototype.activate =  function() {
  Zepto("#screen").on('click change', 'button,input,select', Zepto.proxy(function(event) {
		this.handleClickEvent(event);
  }, this));
	
	Zepto("#select_language").on('change', Zepto.proxy(function(event) {
		this.handleLanguageSelectEvent(event);
  }, this));
	
}


SettingsController.prototype.show = function() {
  //Zepto('#content').css('visibility', 'visible');
}


SettingsController.prototype.deactivate = function() {
  Zepto("*").off();
  //Zepto('#content').css('display', 'none');
}


SettingsController.prototype.handleClickEvent = function(event) {
  var id = event.target.id;
  if ( id === "buttonBack" ) {
		this.base.showView(0);

  } else if (id === "switch_sound") {
		if ( Zepto('#switch_sound').prop('checked') ) {
	    settings.set("sound", true);
		} else {
	    settings.set("sound", false);
		}

  }  else if (id === "switch_vibrate") {
		if ( Zepto('#switch_vibrate').prop('checked') ) {
	    settings.set("vibrate", true);
		} else {
	    settings.set("vibrate", false);
		}

  } else if (id === "switch_reset") {
		this.showResetConfirmation();
  }
}


SettingsController.prototype.handleLanguageSelectEvent = function(event) {
 	var select = Zepto('#select_language')[0];
	var selected_option_id = select.options[select.selectedIndex].id; 
	if (language.supported_lang_codes.indexOf(selected_option_id) != -1) {
	  settings.set("language", selected_option_id);
	  language.setLanguage(selected_option_id);
	  view_controller.reInitViews();
	  view_controller.reloadView();
	}
}


SettingsController.prototype.showResetConfirmation = function(event) {
	Zepto('#reset_confirmation_title').html($L('Confirmation'));
	Zepto('#reset_confirmation_text').html($L('Are you sure? All game data will be lost!'));
	Zepto('#reset_confirmation_btn_cancel').html($L('Cancel'));
	Zepto('#reset_confirmation_btn_ok').html($L('Reset'));
	
	Zepto('#reset_confirmation_btn_cancel').on('click',Zepto.proxy(function(event) {
		event.preventDefault();
		Zepto('#switch_reset').prop('checked', false);
		this.hideResetConfirmation();
	},this));

	Zepto('#reset_confirmation_btn_ok').on('click', function(event) {
		event.preventDefault();
		//localStorage.clear();
		data.storage.clear();
		level_service.storage.clear();
		window.location.href = 'index.html';
	});

	Zepto('#reset_confirmation').css('visibility', 'visible');
}

SettingsController.prototype.hideResetConfirmation = function() {
	Zepto('#reset_confirmation').css('visibility', 'hidden');

	Zepto('#reset_confirmation_btn_cancel').off();
	Zepto('#reset_confirmation_btn_ok').off();
}