//
//	view_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function ViewController() {
  this.init();
}


ViewController.prototype.init = function() {
  this.view_names = new Array("main-menu",
															"chapter-chooser", 
															"level-chooser", 
															"game", 
															"settings", 
															"info");

  this.view_controllers = new Array();
  this.view_controllers[0] = new MainMenuController(this);
  this.view_controllers[1] = new ChapterChooserController(this);
  this.view_controllers[2] = new LevelChooserController(this);
  this.view_controllers[3] = new GameController(this);
  this.view_controllers[4] = new SettingsController(this);
  this.view_controllers[5] = new InfoController(this);

  for (var i = 0; i < this.view_controllers.length; i++) {
		this.view_controllers[i].init();
  }

  this.view_id_history = [];
  this.current_view_id = null;

	this.fade_in_time = 50;
	this.fade_out_time = 10;

  this.storage = new Storage("view_controller");

  this._on_unload = this.on_unload.bind(this);
	this._on_load = this.on_load.bind(this);
}

ViewController.prototype.show = function() {
  var view_id_backup = this.storage.get("cur_view_id");
  if ([0,1,2,3,4,5].indexOf(view_id_backup) != -1) {
		this.showView(view_id_backup);
  } else {
		this.showView(0);
  }

	//prevent screen dimming
	if (window.navigator.requestWakeLock) {
		this.screen_wake_lock = window.navigator.requestWakeLock('screen');
		console.debug('screen wake lock requested');
	}

	//lock screen orientation
	if (window.screen.lockOrientation) {
		window.screen.lockOrientation('portrait-primary');
	} else {
		console.warn("screen.lockOrientation not available")
	}

	//set load (app-open) listener
  Zepto(window).on('load', this._on_load);

	//set unload (app-close) listener
  Zepto(window).on('unload', this._on_unload);
}

ViewController.prototype.reInitViews = function() {
  for (var i = 0; i < this.view_controllers.length; i++) {
		this.view_controllers[i].init();
  }
}


ViewController.prototype.showView = function(view_id) {	
	//check receipt 
	/*
	if (!receipts.validate() && view_id == 3) {
		if (this.current_view_id == 3) {
			view_id = 0;
		} else {
			return;
		}
	}
	*/

  var previous_view_id = this.current_view_id;
  this.current_view_id = view_id;
  this.storage.set("cur_view_id", view_id);

  if (previous_view_id != null) {
		this.view_controllers[previous_view_id].deactivate();
		this.view_id_history.push(previous_view_id);
		//TODO: save history?
  }

  //setup new view off screen
  Zepto('#content').attr('id', 'content_old');
  Zepto('#content_old').find('*').removeAttr('id');
  Zepto('#screen').append(this.view_controllers[view_id].templates.main);
  Zepto('#content').css('opacity', 0.0);
  var ready = this.view_controllers[view_id].setup();   
  if (ready || ready == null) {
		this.on_setupComplete();
  } else {
		Zepto(document).on("event_setupComplete", Zepto.proxy(function() { this.on_setupComplete(); }, this));
  }
}


ViewController.prototype.on_setupComplete = function() {
  Zepto(document).off("event_setupComplete");

  //transition to new view after setup and all images loaded
  //Zepto("#content_old").animate({opacity: 0.0}, this.fadeout_time, 'ease-out', function() { Zepto('#content_old').remove(); });
  Zepto('#content_old').remove();

	//this.on_viewReady();
  Zepto(document).ready(Zepto.proxy(function() { this.on_documentReady() }, this));
}


ViewController.prototype.on_documentReady = function() {
	this.waitForImages(Zepto('#screen'), Zepto.proxy(function() { this.on_viewReady(); }, this));
}


ViewController.prototype.on_viewReady = function() {
	/*
	Zepto("#content").animate({opacity: 1.0}, this.fade_in_time, 'ease-in', 
														Zepto.proxy(function() {
															//activate view handlers
															this.view_controllers[this.current_view_id].activate();
																
															//show
															this.view_controllers[this.current_view_id].show();
														}, this))
	*/
	//Zepto("#content").animate({opacity: 1.0}, this.fade_in_time, 'ease-in'); 
	Zepto("#content").css('opacity', 1.0); 
												
	//activate (view handlers etc.)
	this.view_controllers[this.current_view_id].activate();
	
	//show
	this.view_controllers[this.current_view_id].show();
}


ViewController.prototype.reloadView = function() {
  this.showView(this.current_view_id);
}


ViewController.prototype.navBack = function() {
  if (this.view_id_history.length > 0) {
		var last_view_id = this.view_id_history.pop();
		this.showView(last_view_id);
  } else {
		console.debug("view_controller.js: navBack() -> view history empty\n");
  }
}


ViewController.prototype.on_unload = function() {
  if (this.view_controllers[this.current_view_id].on_unload != null) {
		this.view_controllers[this.current_view_id].on_unload();
  }

	//release screen wake lock on close or idle (put to background) 
	/*if (window.navigator.requestWakeLock != null && this.screen_wake_lock) {
		console.debug('screen wake lock released');
		this.screen_wake_lock.unlock();
	}*/
}


ViewController.prototype.on_load = function() {
  if (this.view_controllers[this.current_view_id] != null) {
		this.view_controllers[this.current_view_id].show();
  }

	if (window.screen.lockOrientation) {
		window.screen.lockOrientation('portrait-primary');
	} else {
		console.warn("screen.lockOrientation not available")
	}

	//request new screen wake lock
	if (window.navigator.requestWakeLock != null && this.screen_wake_lock == null) {
		console.debug('new screen wake lock requested');
		this.screen_wake_lock = window.navigator.requestWakeLock('screen');
	}
}

ViewController.prototype.loadTemplate = function(controller, template_name, lang_code) {
  if (name == undefined) {
		template_name = "main";
  }

  if (lang_code == undefined || lang_code == language.base_lang_code) {
		var base_path = appPath + "views/";
  } else {
		var base_path = appPath + "resources/" + lang_code + "/views/"
  }

  var filename = base_path + controller.name + "/" + template_name + ".html"
  
  controller.templates[template_name] = "";
  Zepto.ajax({
		async: false,
		type: 'GET',
		dataType: 'text',
		url: filename,
		success: Zepto.proxy(function(data){
	    controller.templates[template_name] = data
		}, controller),
		error: function(xhr, type){
	    console.log('ViewController->loadTemplate: Ajax error!')
		}
  });
}


ViewController.prototype.waitForImages = function (obj, finishedCallback) {
  var allImgsLength = 0;
  var allImgsLoaded = 0;

  var img_only = false;

  // Ensure callbacks are functions.
  if (!Zepto.isFunction(finishedCallback)) {
		throw new TypeError('An invalid callback was supplied.');
  }

  // CSS properties which contain references to images.
  hasImageProperties = ['backgroundImage', 'listStyleImage', 'borderImage', 'borderCornerImage'];

  eventNamespace = "waitForImages";

  // `img` elements with valid `src` attribute not already loaded.
  uncached = function(obj) {
		// Ensure we are dealing with an `img` element with a valid `src` attribute.
		if (!Zepto(obj).is('img')) {
      return false;
		}
		if (Zepto(obj).attr('src') != "") {
	    return false;
		}
		
		// Firefox's `complete` property will always be `true` even if the image has not been downloaded. Doing it this way works in Firefox.
		var img = new Image();
		img.src = obj.src;
		return !img.complete;
  };


  Zepto(obj).each(function () {
		// Build a list of all imgs, dependent on what images will be considered.
		var obj = Zepto(this);
		var allImgs = [];

		// CSS properties which may contain an image.
		var hasImgProperties = hasImageProperties || [];

		// To match `url()` references.
		// Spec: http://www.w3.org/TR/CSS2/syndata.html#value-def-uri
		var matchUrl = /url\(\s*(['"]?)(.*?)\1\s*\)/g;

		if (img_only) {
      // For images only, the task is simpler.
      obj.find('img')
				.each(function () {
					if (uncached(this)) {
						allImgs.push({
							src: this.src,
							element: this
						});
					}
				});
		} else {
      // Get all elements, as any one of them could have a background image.
      obj.find('*').each(function () {
				var element = Zepto(this);

				// If an `img` element, add it. But keep iterating in case it has a background image too.
				if (element.is('img')) {
					if (uncached(this)) {
						allImgs.push({
							src: element.src,
							element: element[0]
						});
					}
				}

				Zepto.each(hasImgProperties, function (i, property) {
          var propertyValue = element.css(property);
          var match;

          // If it doesn't contain this property, skip.
          if (!propertyValue) {
						return true;
          }

          // Get all url() of this element.
          while (match = matchUrl.exec(propertyValue)) {
						allImgs.push({
              src: match[2],
              element: element[0]
						});
          }
				});
      });
		}

		allImgsLength = allImgs.length;
		allImgsLoaded = 0;

		// If no images found, don't bother.
		if (allImgsLength === 0) {
      finishedCallback.call(obj[0]);
		}

		Zepto.each(allImgs, function (i, img) {

      var image = new Image();

      // Handle the image loading and error with the same callback.
      Zepto(image).bind('load.' + eventNamespace + ' error.' + eventNamespace, function (event) {
				allImgsLoaded++;

				// If an error occurred with loading the image, set the third argument accordingly.

				if (allImgsLoaded == allImgsLength) {
          finishedCallback.call(obj[0]);
          return false;
				}

      });

      image.src = img.src;
		});
  });
}
