function Bars(id, x, y, width, height, up, rounds) {
	Interactive.call(this, id);
	this.x = x;
	this.y = y;
	this.position = new Vector(x, y);
	this.width = width;
	this.height = height;
  this.def = {};
  this.def.up = up;
	this.rounds = [];
	var i;
	//Mojo.Log.error("creating bars....");
	//Mojo.Log.error("rounds length is: " + rounds.length);
	for (i = 0; i < rounds.length; i++) {
		//Mojo.Log.error("creating round, x: " + rounds[i][0] + " y: " + rounds[i][1] + " r: " + rounds[i][2]);
		this.rounds.push(new Round("id", rounds[i][0], rounds[i][1], 7.5, "small"));
	}
  this.setToDefault();
}

Bars.prototype = new Interactive();
Bars.prototype.constructor = Bars;

Bars.prototype.setToDefault = function() {
  this.condCount = 0;
  this.up = this.def.up;
  this.redraw = true;
  this.condExec = false;
	return;
}

Bars.prototype.scBall = function(ball, extraForce, gameConcept, counter) {
	if (!this.checkCounter(counter)) {
		return;
	}
	if (!this.up) {
		return;
	}
	var i;
	for (i = 0; i < this.rounds.length; i++) {
		this.rounds[i].scBall(ball);
	}
}

Bars.prototype.toggle = function() {
	this.up = !this.up;
	this.redraw = true;
}

Bars.prototype.open = function() {
	if (!this.up) {
		return;
	}
	this.up = false;
	this.redraw = true;
}

Bars.prototype.close = function() {
	if (this.up) {
		return;
	}
	this.up = true;
	this.redraw = true;
}

Bars.prototype.draw = function() {
	this.redraw = false;

	if (typeof(this.imageBottomUp) == 'undefined' || this.imageBottomUp == null) {
//		Mojo.Log.error("bars: bottomUp " + this.id + " redraw");
		this.imageBottomUp = document.getElementById(this.id + "_bottom_up");
	}
	if (typeof(this.imageBottomDown) == 'undefined' || this.imageBottomDown == null) {
//		Mojo.Log.error("bars: bottomDown " + this.id + " redraw");
		this.imageBottomDown = document.getElementById(this.id + "_bottom_down");
	}
	if (typeof(this.imageTopUp) == 'undefined' || this.imageTopUp == null) {
//		Mojo.Log.error("bars: topUp " + this.id + " redraw");
		this.imageTopUp = document.getElementById(this.id + "_top_up");
	}

	if (this.up) {
		this.imageBottomDown.style.visibility = "hidden";
		this.imageBottomUp.style.visibility = "visible";
		this.imageTopUp.style.visibility = "visible";
	} else {
		this.imageTopUp.style.visibility = "hidden";
		this.imageBottomUp.style.visibility = "hidden";
		this.imageBottomDown.style.visibility = "visible";
	}

	return true;
}

Bars.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV) {
	var aabb = new Aabb(this.x - 10, this.y - 10, this.width + 20, this.height + 20);
	return getAabbSectors(aabb, numberHSectors, numberVSectors, widthOH, heightOV);
}

