function circleCircle( cA, rA, cB, rB ) {
    result = {}
    result['collide'] = false;
    result['sVector'] = null;
    result['edge'] = null;
    result['dist'] = null;
    cAPos = cA.getPosition();
    cBPos = cB.getPosition();
    minR = rA+rB;
    if( Math.abs(cAPos.x-cBPos.x) > minR ||
        Math.abs(cAPos.y-cBPos.y) > minR ) {
      return result;
    }

    axis = new Vector( cBPos.x, cBPos.y );
    axis.sub( cAPos );
    length = axis.length();

    if( length < minR ) {
      axis.normalize();
      result['sVector'] = new Vector( axis.x, axis.y );
      result['sVector'].scale( minR-length );
      result['edge'] = new Vector( axis.x, axis.y );
      result['edge'].normal();
      result['collide'] = true;
      result['dist'] = length;
      return result;
    }
    return result;
}

function pointCircleQuick( p, c, r ) {
  if( Math.abs(p.x-c.x) > r ||
      Math.abs(p.y-c.y) > r ) {
    return false;
  }
  axis = new Vector( c.x, c.y );
  axis.sub( p );
  length = axis.length();
  if( length < r ) {
    return true;
  }
  return false;
}

function circleInCircle( c, r, cIn, rIn ) {
    var result = {};
    result['collide'] = false;
    result['sVector'] = null;
    result['edge'] = null;
    result['dist'] = null;
    maxR = rIn-r;
		//alert( "maxR: "+maxR );
    /*if( Math.abs(c.x-cIn.x) < maxR &&
        Math.abs(c.y-cIn.y) < maxR ) {
      return result;
    }*/
    axis = new Vector( c.x, c.y );
    axis.sub( cIn );
    length = axis.length();
		//alert("length: "+length);
    if( length > maxR ) {
      axis.normalize();
      result['sVector'] = new Vector( axis.x, axis.y );
      result['sVector'].scale( maxR-length );
      result['edge'] = new Vector( axis.x, axis.y );
      result['edge'].normal();
      result['collide'] = true;
      result['dist'] = length;
			//alert( "sVector: "+result['sVector'].x+" : "+result['sVector'].y+" edge: "+result['edge'].x+" : "+result['edge'].y+" dist: "+result['dist'] );
      return result;
    }
		//alert("test");
    return result;
}
