function Corner( id, x, y, r, type ) {
	Interactive.call(this, id);
	this.x = x;
	this.y = y;
	this.r = r;
	this.type = type;
	switch( this.type ) {
		case 0:
			this.cx = this.x-this.r;
			this.cy = this.y-this.r;
			break;
		case 1:
			this.cx = this.x+this.r;
			this.cy = this.y-this.r;
			break;
		case 2:
			this.cx = this.x-this.r;
			this.cy = this.y+this.r;
			break;
		case 3:	
			this.cx = this.x+this.r;
			this.cy = this.y+this.r;
			break;
		default:
			this.cx = this.x-this.r;
			this.cy = this.y-this.r;
			break;
	}
	this.centerPosition = new Vector( this.cx, this.cy );
	this.position = new Vector( x, y );
	this.redraw = false;
}

Corner.prototype = new Interactive();
Corner.prototype.constructor = Corner;

Corner.prototype.setToDefault = function() {
  return;
}

Corner.prototype.getPosition = function() {
  return this.position;
}

Corner.prototype.getCenterPosition = function() {
	return this.centerPosition;
}

Corner.prototype.scBall = function(ball) {
  //Test for collision
	var b = ball.center.getPosition();
	switch( this.type ) {
		case 0:
			if( !((b.x > this.cx && b.y > this.cy ) && (b.x < this.x && b.y < this.y)) ) {
				return;
			}
			break;
		case 1:
			if( !((b.x < this.cx && b.y > this.cy ) && (b.x > this.x && b.y < this.y)) ) {
				return;
			}
			break;
		case 2:
			if( !((b.x > this.cx && b.y < this.cy ) && (b.x < this.x && b.y > this.y)) ) {
				return;
			}
			break;
		case 3:
			if( !((b.x < this.cx && b.y < this.cy) && (b.x > this.x && b.y > this.y)) ) {
				return;
			}
		  break;
    default:
      return;
	}
  
	var result = circleInCircle( b, ball.r, this.centerPosition, this.r );

  if(result['collide']) {
    sVector = result['sVector'];
    mirrorAxis = result['edge'];
		var ballcenter = ball.center;
    ballcenter.getPreviousPosition().mirror( mirrorAxis, b );
    ballcenter.addPosition( sVector );
    ballcenter.getPreviousPosition().add( sVector );
  }
}

Corner.prototype.draw = function() {
  return;
}

Corner.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV)  {
	var x = Math.min(this.x, this.cx);
	var y = Math.min(this.y, this.cy);
	var width = Math.abs(this.x-this.cx);
	var height = Math.abs(this.y-this.cy);
  var aabb = new Aabb(x, y, width, height);
  return getAabbSectors(aabb, numberHSectors, numberVSectors, widthOH, heightOV);
  //return getCircleSectors(this.position, this.r, numberHSectors, numberVSectors, widthOH, heightOV);
}
