function OrbLandDb() {
	//this.db = openDatabase("orbland");
	
	window.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
	var request = window.indexedDB.open("orbland");
	request.onerror = function(event) {
		console.log("ERROR: opening DB failed");
	};
	request.onsuccess = Zepto.proxy(function(event) {
		this.db = request.result;
		this.init();
	}, this);

	/*if (!this.db) {
		//Mojo.Log.error("ERROR: opening DB failed");
		return;
	}

	this.createTablesIfNeeded();*/
}

OrbLandDb.prototype.init = function() {
	if (!this.db) {
		console.error("ERROR: opening DB failed");
		return;
	}

	this.createTablesIfNeeded();
}

OrbLandDb.prototype.createTablesIfNeeded = function() {
	var tables = {
		highscores: {
			chapter: "VARCHAR(16)",
			level: "INTEGER NOT NULL DEFAULT 0",
			difficulty: "INTEGER NOT NULL DEFAULT 0",
			time: "INTEGER NOT NULL DEFAULT 0",
			tries: "SMALLINT NOT NULL DEFAULT 0",
			primary_key: "chapter, level, difficulty"
		}
	};
	for (var table in tables) {
		var columnsSql = [];
		for (var column in tables[table]) {
			if (column == "primary_key") {
				columnsSql.push("Primary key (" + tables[table][column] + ")");
			} else {
				columnsSql.push("`" + column + "` " + tables[table][column]);
			}
		}
		//this.query("DROP TABLE IF EXISTS `" + table + "`"); // dbg
		this.query("CREATE TABLE IF NOT EXISTS `" + table + "` (" + columnsSql.join(", ") + ")");
	}
}

OrbLandDb.prototype.errorHandler = function(error) {
	//Mojo.Log.error("SQL ERROR: " + error.message + " (" + error.code + ")");
}

OrbLandDb.prototype.query = function(sql, values, callback) {
	//Mojo.Log.error(sql);

	if (typeof values != "object" && typeof values != "array") {
		values = [];
	}

	if (typeof callback != "function") {
		callback = function(transaction) {};
	}

	this.db.transaction(
		function(tr) {
			tr.executeSql(
				sql,
				values,
				function(todoWhatIsThis, andWhatIsThis) {
					callback(andWhatIsThis);
				}
			)
		},
		this.errorHandler
	);
}

OrbLandDb.prototype.addHighscore = function(chapter, level, physics, time, tries) {
	var difficulty;
	switch (physics) {
		case "easy":
			difficulty = 1;
			break;
		case "medium":
			difficulty = 2;
			break;
		case "realistic":
			difficulty = 3;
			break;
	}
	this.query("REPLACE INTO `highscores` (chapter, level, difficulty, time, tries) VALUES (?, ?, ?, ?, ?)",
			[(chapter), parseInt(level), parseInt(difficulty), parseInt(100*time), parseInt(tries)]);
}

OrbLandDb.prototype.getHighscore = function(chapter, level, callback) {
	this.query("SELECT difficulty, time, tries, chapter, level FROM highscores WHERE chapter = ? AND level = ? ORDER BY time ASC, difficulty DESC LIMIT 1",
		[(chapter), parseInt(level)],
		(function(result) {
		 	if (result.rows.length == 1) {
				var row = [];
			 	row["time"] = result.rows.item(0)["time"] / 100;
				row["level"] = level;
				row["chapter"] = chapter;
				switch (result.rows.item(0)["difficulty"]) {
					case 1:
						row["difficulty"] = $L("easy");
						break;
					case 2:
						row["difficulty"] = $L("medium");
						break;
					case 3:
						row["difficulty"] = $L("realistic");
						break;
				}
			} else {
				var row = [];
				row["time"] = false;
				row["level"] = level;
				row["chapter"] = chapter;
			}
			callback(row);
		}).bind(this)
	);
}

OrbLandDb.prototype.getHighscores = function(chapter, level, callback) {
	this.query("SELECT difficulty, time, tries FROM highscores WHERE chapter = ? AND level = ? ORDER BY time ASC, difficulty ASC",
		[(chapter), parseInt(level)],
		(function(result) {
		 	if (result.rows.length != 0) {
				var ret = [];
				var row;

				for (var i=0; i<result.rows.length; ++i) {
					row = [];
				 	row["time"] = result.rows.item(i)["time"] / 100;
					switch (result.rows.item(i)["difficulty"]) {
						case 1:
							row["difficulty"] = $L("easy");
							break;
						case 2:
							row["difficulty"] = $L("medium");
							break;
						case 3:
							row["difficulty"] = $L("realistic");
							break;
					}
					ret[ret.length] = row;
				}
			} else {
				var ret = false;
			}
			callback(ret);
		}).bind(this)
	);
}

OrbDb = new OrbLandDb();

/*
highscoreReceived = function(highscore) {
	//Mojo.Log.error("The highscore is "+highscore["time"]+ " ("+highscore["difficulty"]+")");
}

OrbDb.addHighscore(1, 1, "easy", 55.26, 2);
OrbDb.addHighscore(1, 1, "realistic", 55.26, 2);
OrbDb.addHighscore(1, 1, "medium", 55.26, 2);
OrbDb.getHighscore(1, 1, highscoreReceived.bind(this));
*/

