function GameConcept( concept, args ) {
  this.concept = concept;
  this.numberGoals = 1;
  this.numberFallen = 1;
  this.createArguments(args);
  this.fallen = 0;
  this.goals = 0;
}

GameConcept.prototype.createArguments = function(args) {
  switch( this.concept ) {
    case "standard":
      this.numberGoals = args[0];
      this.numberFallen = args[1];
      break;
  }
}

GameConcept.prototype.reset = function() {
  this.fallen = 0;
  this.goals = 0;
}

GameConcept.prototype.addFallen = function() {
  this.fallen++;
}

GameConcept.prototype.addGoal = function() {
  this.goals++;
}

GameConcept.prototype.checkSuccess = function() {
  if( this.goals >= this.numberGoals ) {
    return true;
  }
  return false;
}

GameConcept.prototype.checkGameOver = function() {
  if( this.fallen >= this.numberFallen ) {
    return true;
  }
  return false;
}
