function GateHole( id, x, y, r, opened ) {
  Interactive.call(this, id);
  this.x = x;
  this.y = y;
  this.r = r;
  this.position = new Vector( x, y );
  this.opened = opened;
  this.def = {};
  this.def.opened = opened;
  this.redraw = true;
}

GateHole.prototype = new Interactive();
GateHole.prototype.constructor = GateHole;

GateHole.prototype.setToDefault = function() {
  this.opened = this.def.opened;
  this.redraw = true;
}

GateHole.prototype.getPosition = function() {
  return this.position;
}

GateHole.prototype.toggle = function() {
  this.opened = !this.opened;
  this.redraw = true;
}

GateHole.prototype.close = function() {
  this.opened = false;
  this.redraw = true;
}

GateHole.prototype.open = function() {
  this.opened = true;
  this.redraw = true;
}

GateHole.prototype.scBall = function( ball, extraForce, gameConcept, counter ) {
  if( !this.checkCounter(counter) ) {
    return;
  }
  if( !this.opened ) {
    return;
  }
  //Test for collision
  var result = pointCircleQuick( ball.getPosition(), this.position, this.r+1 );
  if(result) {
    gameConcept.addFallen();
    ball.setFallenDown(this.x, this.y);
  }
}

GateHole.prototype.draw = function() {
	// TODO: document.getElement nur EINMAL machen
	// TODO: statt 2 IMGs nur 1 nehmen, und dann .src ändern anstatt .visibility
  this.redraw = false;
  if( typeof(this.imageOpen) === 'undefined' || this.imageOpen == null ) {
    this.imageOpen = document.getElementById(this.id+"_opened");
	//Mojo.Log.error("------------------------------------------------------");
  }
  if( typeof(this.imageClosed) === 'undefined' || this.imageClosed == null ) {
    this.imageClosed = document.getElementById(this.id+"_closed");
  }
  if( this.opened ) {
    this.imageOpen.style.visibility = "visible";
    this.imageClosed.style.visibility = "hidden";
  } else {
    this.imageOpen.style.visibility = "hidden";
    this.imageClosed.style.visibility = "visible";
  }

  return true;
}

GateHole.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV)  {
  return getCircleSectors(this.position, this.r, numberHSectors, numberVSectors, widthOH, heightOV);
}
