function Interactive(id) {
	if (typeof(id) == "undefined") {
		id = "";
	}
	this.id = id;
	this.counter = 0;
	this.regSignals = {};
	this.conditions = {};
}

Interactive.prototype.checkCounter = function(counter) {
	if (this.counter < counter) {
		this.counter = counter;
		return true;
	}
	return false;
}

Interactive.prototype.move = function() {
	return;
}

Interactive.prototype.registerSignal = function(signal, func, params) {
//	Mojo.Log.error("registerSignal" + signal);
//	Mojo.Log.error("for id: " + this.id);
	if (typeof(this.regSignals[signal]) == 'undefined') {
		this.regSignals[signal] = [];
//		Mojo.Log.error("signal: " + typeof(this.regSignals[signal]));
	}
	this.regSignals[signal].push([func, params]);
	//Mojo.Log.error( "signal registered: "+this.regSignals[signal][this.regSignals[signal].length][0] );
}

Interactive.prototype.callSignal = function(signal) {
	if (typeof(this.regSignals[signal]) !== 'undefined') {
		var m = this.regSignals[signal].length;
		for (var i = 0; i < m; i++) {
			// Mojo.Log.error( "callSignal: "+signal );
			this.regSignals[signal][i][0](this.regSignals[signal][i][1]);
		}
	}
}

Interactive.prototype.sendSignal = function(signal) {
	this.callSignal(signal);
	//For global treatment of signals    
	//if signal in this.regSignals:
	//  globals.signals.append( (this, signal) )
}

Interactive.prototype.checkQuickCondition = function() {
  //alert("condMin:"+this.condMin+" condCount: "+this.condCount);
  if( !this.condExec && this.condCount >= this.condMin ) {
    
    this.quickCondition();
    this.condExec = true;
  }
}

Interactive.prototype.addCondCount = function() {
  this.condCount++;
  if( !this.condExec && this.condCount >= this.condMin ) {
    
    this.quickCondition();
    this.condExec = true;
  }
}

Interactive.prototype.subCondCount = function() {
  this.condCount--;
}

Interactive.prototype.registerQuickCondition = function(condMin, func) {
  this.condMin = condMin;
  this.condCount = 0;
  this.condExec = false;
  this.quickCondition = func;
}
  
Interactive.prototype.checkCondition = function(condition) {
	if (typeof(this.conditions[condition]) == 'undefined') {
		return;
	}
	var res = false;
	for (k = 0; k < this.conditions[condition][1].length; k++) {
		res = this.conditions[condition][1][k]();
		if (!res) {
			break;
		}
	}
	if (!res) {
		return;
	} else {
		this.conditions[condition][0]();
	}
}

Interactive.prototype.registerCondition = function(condition, func, conditions) {
	//Mojo.Log.error("registering condition: " + condition);
	this.conditions[condition] = [func, conditions];
}

//FIXME: as soon as timers are implemented.
/*def setTimer( this, time, function ):
    globals.timers.append( Timer( time, function ) )*/

