function LaserGen(id, x, y, width, height, on, rounds) {
	Interactive.call(this, id);
	this.x = x;
	this.y = y;
	this.position = new Vector(x, y);
	this.width = width;
	this.height = height;
  this.def = {};
  this.def.on = on;
	this.rounds = new Round("id", rounds[2], rounds[3], 7.5, "small");
  this.setToDefault();
}

LaserGen.prototype = new Interactive();
LaserGen.prototype.constructor = LaserGen;

LaserGen.prototype.setToDefault = function() {
  this.condCount = 0;
  this.redraw = true;
  this.condExec = false;
  this.on = this.def.on;
	return;
}

LaserGen.prototype.scBall = function(ball, extraForce, gameConcept, counter) {
	if (!this.checkCounter(counter)) {
		return;
	}
  this.rounds.scBall(ball);
}

LaserGen.prototype.toggle = function() {
	this.on = !this.on;
	this.redraw = true;
}

LaserGen.prototype.switchOn = function() {
	if (!this.on) {
		return;
	}
	this.on = false;
	this.redraw = true;
}

LaserGen.prototype.switchOff = function() {
	if (this.on) {
		return;
	}
	this.on = true;
	this.redraw = true;
}

LaserGen.prototype.draw = function() {
	this.redraw = false;
	if (typeof(this.imageGlow) === 'undefined' || this.imageGlow == null) {
		this.imageGlow = document.getElementById(this.id + "_glow");
	}

	if (this.on) {
		this.imageGlow.style.visibility = "visible";
	} else {
		this.imageGlow.style.visibility = "hidden";
	}
	return true;
}

LaserGen.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV) {
  var aabb = new Aabb(this.rounds.x-this.rounds.r, this.y-this.rounds.r, this.rounds.r*2, this.rounds.r*2);
  return getAabbSectors(aabb, numberHSectors, numberVSectors, widthOH, heightOV);
}

