function MovingHole( id, x, y, r, xEnd, yEnd, velocity, moving ) {
  Interactive.call(this, id);
  this.position = new Vector(x, y);
  this.r = 13;
  this.goal = false;
  this.color = '#000000';
  //this.image = document.getElementById(this.id);
  this.redraw = false;
  if( typeof(moving) === 'undefined' ) {
    this.moving = true;
  } else {
    this.moving = moving;
  }
  this.start = new Vector(x, y);
  this.end = new Vector(xEnd, yEnd);
  this.rounded = new Vector(Math.round(x), Math.round(y));
  this.xDist = Math.abs(this.end.x-this.start.x);
  this.yDist = Math.abs(this.end.y-this.start.y);
  this.velocity = velocity;
  this.velocityVector = new Vector( (this.end.x-this.start.x)/this.velocity,
                                    (this.end.y-this.start.y)/this.velocity );
  this.forward = true;
}

MovingHole.prototype = new Interactive();
MovingHole.prototype.constructor = MovingHole;

MovingHole.prototype.setToDefault = function() {
  this.position.set(this.start);
  this.moving = true;
  this.forward = true;
  this.redraw = true;
}

MovingHole.prototype.getPosition = function() {
  return this.position;
}

MovingHole.prototype.setMove = function() {
  this.moving = true;
}

MovingHole.prototype.setStop = function() {
  this.moving = false;
}

MovingHole.prototype.scBall = function( ball, extraForce, gameConcept, counter ) {
  if( !this.checkCounter(counter) ) {
    return;
  }
  var result = circleCircle( ball, ball.r, this, this.r );
  if( result['collide'] ) {
    this.moving = false;
    gameConcept.addFallen();
    ball.setExploded();
  }
}

MovingHole.prototype.move = function() {
  if( !this.moving ) {
    return;
  }
  if( this.forward ) {
    this.position.add(this.velocityVector);
    if( (this.xDist != 0.0 && Math.abs(this.position.x-this.start.x) > this.xDist) ||
        (this.yDist != 0.0 && Math.abs(this.position.y-this.start.y) > this.yDist) ) {
      this.forward = false;
    }
  } else {
    this.position.sub(this.velocityVector);
    if( (this.xDist != 0.0 && Math.abs(this.position.x-this.end.x) > this.xDist) ||
        (this.yDist != 0.0 && Math.abs(this.position.y-this.end.y) > this.yDist) ) {
      this.forward = true;
    }
  }
  var roundedX = Math.round(this.position.x);
  var roundedY = Math.round(this.position.y);
  if( roundedX != this.rounded.x ||
      roundedY != this.rounded.y) {
    this.rounded.x = roundedX;
    this.rounded.y = roundedY;
    this.redraw = true;
  }
}

MovingHole.prototype.setGoal = function(goal) {
  this.goal = goal;
}

MovingHole.prototype.draw = function() {
  this.redraw = false;
  if( typeof(this.image) === 'undefined' || this.image == null ) {
    console.debug("teST");
    this.image = document.getElementById(this.id);
  }
  this.image.style.left = (this.rounded.x-22).toString()+'px';
  this.image.style.top = (this.rounded.y-20).toString()+'px';
}

MovingHole.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV)  {
  var i, vMin, vMax, hMin, hMax;
  var vStart = getCircleSectors(this.start, this.r, numberHSectors, numberVSectors, widthOH, heightOV);
  var vEnd = getCircleSectors(this.end, this.r, numberHSectors, numberVSectors, widthOH, heightOV);
  hMin = vStart['hSectors'][0];
  hMax = vStart['hSectors'][0];
  for( i in vStart['hSectors'] ) {
    if( vStart['hSectors'][i] < hMin ) {
      hMin = vStart['hSectors'][i];
    }
    if( vStart['hSectors'][i] > hMax ) {
      hMax = vStart['hSectors'][i];
    }
  }
  for( i in vEnd['hSectors'] ) {
    if( vEnd['hSectors'][i] < hMin ) {
      hMin = vEnd['hSectors'][i];
    }
    if( vEnd['hSectors'][i] > hMax ) {
      hMax = vEnd['hSectors'][i];
    }
  }
  vMin = vStart['vSectors'][0];
  vMax = vStart['vSectors'][0];
  for( i in vStart['vSectors'] ) {
    if( vStart['vSectors'][i] < vMin ) {
      vMin = vStart['vSectors'][i];
    }
    if( vStart['vSectors'][i] > vMax ) {
      vMax = vStart['vSectors'][i];
    }
  }
  for( i in vEnd['vSectors'] ) {
    if( vEnd['vSectors'][i] < vMin ) {
      vMin = vEnd['vSectors'][i];
    }
    if( vEnd['vSectors'][i] > vMax ) {
      vMax = vEnd['vSectors'][i];
    }
  }
  vStart['hSectors'].length = 0;
	vStart['vSectors'].length = 0;
  for( i=hMin; i<=hMax; i++ ) {
    vStart['hSectors'].push(i);
  }
  for( i=vMin; i<=vMax; i++ ) {
    vStart['vSectors'].push(i);
  }
  return vStart;
}
