function Switch(id, x, y, r, color, on, type, ballCount) {
	Interactive.call(this, id);
	this.position = new Vector(x, y);
	this.def = {};
	this.def.x = x - 1;
	this.def.y = y - 1;
	if (r == 1) {
		this.def.r = 14;
	} else {
		this.def.r = 16;
	}
	this.def.color = color;
	this.def.on = on;
	this.def.type = type;
	this.inside = []
	for (var i = 0; i < ballCount; ++i) {
		this.inside.push(false);
	}
	this.setToDefault();
}

Switch.prototype = new Interactive();
Switch.prototype.constructor = Switch;

Switch.prototype.getPosition = function() {
	return this.position;
}

Switch.prototype.setToDefault = function() {
	this.x = this.def.x;
	this.y = this.def.y;
	this.r = this.def.r;
	this.color = this.def.color;
	this.position.x = this.def.x;
	this.position.y = this.def.y;
	this.on = this.def.on;
	this.inside = [];
	for (var i = 0; i < this.inside.length; ++i) {
		this.inside.push(false);
	}
	this.type = this.def.type;
	this.redraw = true;
	this.condCount = 0;
}

Switch.prototype.scBall = function(ball, extraForce, gameConcept, counter, itBall) {
	if (!this.checkCounter(counter)) {
		return;
	}
	if ((this.type == 'light' && this.on) || this.type == 'fix') {
		return;
	}
	if (pointCircleQuick(this.position, ball.center.getPosition(), this.r)) {
		if (!this.inside[itBall]) {
			this.inside[itBall] = true;
			if (this.type == 'Switch') {
				this.toggle();
			} else if (this.type == 'light') {
				if (!this.on) {
					this.switchOn();
				}
			}
		}
	} else {
		this.inside[itBall] = false;
	}
}

Switch.prototype.toggle = function() {
	this.on = ! this.on;
	if (this.on) {
		this.callSignal("switched_on");

		//FIXME: What is really needed here?
		//if this.type == "Flash":
		//this.setTimer( 400, this.switchOff )
	} else {
		this.callSignal("switched_off");
	}
	this.callSignal("status_changed");
	this.redraw = true;
}

Switch.prototype.switchOn = function(notSendSignals) {
	if (this.on) {
		return;
	}

	this.on = true;
	if (notSendSignals == null) {
		this.sendSignal("switched_on");
		this.sendSignal("status_changed");
	}
	//  this.sendSignal( "status_changed" ); // not used
	this.redraw = true;
}

Switch.prototype.switchOff = function(notSendSignals) {
	if (!this.on) {
		return;
	}

	this.on = false;
	if (notSendSignals == null) {
		this.sendSignal("switched_off");
		this.sendSignal("status_changed");
	}
	//  this.sendSignal( "status_changed" ); // not used
	this.redraw = true;
}

Switch.prototype.isOn = function() {
	return this.on;
}

Switch.prototype.draw = function() {
	this.redraw = false;
	if (typeof(this.imageOn) === 'undefined' || this.imageOn == null) {
		this.imageOn = document.getElementById(this.id + "_on");
	}
	if (typeof(this.imageOff) === 'undefined' || this.imageOff == null) {
		this.imageOff = document.getElementById(this.id + "_off");
	}
	if (this.on) {
		this.imageOn.style.visibility = 'visible';
		this.imageOff.style.visibility = 'hidden';
	} else {
		this.imageOn.style.visibility = 'hidden';
		this.imageOff.style.visibility = 'visible';
	}

	return true;
}

Switch.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV) {
	return getCircleSectors(this.position, this.r, numberHSectors, numberVSectors, widthOH, heightOV);
}

