function Vector( x, y ) {
  this.x = x;
  this.y = y;
}

Vector.prototype.equal = function(v) {
  return this.x == v.x && this.y == v.y;
}

Vector.prototype.set = function(v) {
  this.x = v.x;
  this.y = v.y;
}

Vector.prototype.add = function(v) {
  this.x += v.x;
  this.y += v.y;
}

Vector.prototype.sub = function(v) {
  this.x -= v.x;
  this.y -= v.y;
}

Vector.prototype.dotProduct = function(v) {
  return this.x * v.x + this.y * v.y;
}

Vector.prototype.length = function() {
  return Math.sqrt( this.x * this.x + this.y * this.y );
}

Vector.prototype.scale = function(scaleFactor) {
  this.x *= scaleFactor;
  this.y *= scaleFactor;
}

Vector.prototype.toString = function() {
  return " X: " + this.x + " Y: " + this.y;
}

Vector.prototype.normal = function() {
  var oldX = this.x;
  this.x = -this.y;
  this.y = oldX;
}

Vector.prototype.normalize = function() {
  length = this.length();
  if( length == 0.0 ) {
    return;
  }
  this.x /= length;
  this.y /= length;
}

Vector.prototype.draw = function(ctx, scaleFactor, color) {
  ctx.lineWidth = 3;
  ctx.fillStyle = color; //'#000000'; 
  ctx.strokeStyle = color; //'#0000FF'; 
  ctx.beginPath();
  ctx.moveTo(1.5 * scaleFactor, 
             1.0 * scaleFactor);
  //document.getElementById('debug').innerHTML = "X: "+this.x * scaleFactor+" Y: "+this.y*scaleFactor;
  ctx.lineTo(this.x * scaleFactor, 
             this.y * scaleFactor); 
  ctx.stroke();
}

//Mirrors the vector on a given line, the edge vector has to be normalized
Vector.prototype.mirror = function(edge, ePoint) {
	//this.sub( ePoint );
	this.x -= ePoint.x;
	this.y -= ePoint.y;

	//var dp = this.dotProduct(edge);
	var dp = this.x*edge.x + this.y*edge.y;

	//edge.scale( dp );
	//edge.sub(this);
	//edge.scale(1.5);
	edge.x = (edge.x * dp - this.x) * 1.5;
	edge.y = (edge.y * dp - this.y) * 1.5;
    
    //this.add( edge );
	//this.add( ePoint );
	this.x += edge.x + ePoint.x;
	this.y += edge.y + ePoint.y;
}

// Calculates the intersection of two lines.
intersection = function(lineAStart, lineAEnd, lineBStart, lineBEnd) {
  var x1, y1, x2, y2, xD1, yD1, xD2, yD2, a, mX, mY;
  var yD2xD2, x1subx2, divisor;
  var result = new Vector(0.0, 0.0);
  x1 = lineAStart.x;
  y1 = lineAStart.y;
  x2 = lineBStart.x;
  y2 = lineBStart.y;

  xD1 = lineAEnd.x - lineAStart.x;
  yD1 = lineAEnd.y - lineAStart.y;

  xD2 = lineBEnd.x - lineBStart.x;
  yD2 = lineBEnd.y - lineBStart.y;
  
  if( xD2 == 0 ) {
    xD2 = 0.001;
  }    
  yD2xD2 = yD2/xD2;
  x1subx2 = x1-x2;
  //alert( "yD2xD2: "+yD2xD2+" x1subx2: "+x1subx2+" yD1: "+yD1 );
  divisor = yD1-(xD1*yD2xD2);
  if( divisor == 0 ) {
    divisor = 0.000001;
  }
  a = ((x1subx2)*(yD2xD2)+y2-y1)/divisor; 
  mX = x1+a*xD1;
  mY = y1+a*yD1;
  result.x = mX;
  result.y = mY;
  return result;  
}

