//
//	game_service.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function GameService(controller) {
  this.controller = controller;
  this.init();
}


GameService.prototype.init = function() {
  this.then = 0;

  this.intervalId = null;
  this.disableAccelForEmu = false;

  this.calibPitch = settings.get("calibPitch");
  this.calibRoll = settings.get("calibRoll");
  
	this.gravXFilter = [0, 0, 0, 0];
	this.gravYFilter = [0, 0, 0, 0];

  // audio
  this.sounds = {};

  this.initSound("fail", appPath+"/resources/sounds/fallen_down.wav");
  
  this.initSound("success", appPath+"/resources/sounds/reached_goal.wav");
  
  // Load the MediaExtension library
  //this.libs = MojoLoader.require({ name: "mediaextension", version: "1.0"});

  //event handlers
  this._accel = this.handleAcceleration.bind(this);
  this._eh_levelLoaded = this.eh_levelLoaded.bind(this);
  this._eh_levelRestarted = this.eh_levelRestarted.bind(this);
  this._onTap = this.onTap.bind(this);
  this._pause = this.pause.bind(this);
  this._unpause = this.unpause.bind(this);
  this._onStageDeactivate = this.onStageDeactivate.bind(this);
  this._onKeyDown = this.onKeyDown.bind(this); //dbg
  this._processHighscores = this.processHighscores.bind(this);
  this._retryLevel = this.retryLevel.bind(this);
  this._nextLevel = this.nextLevel.bind(this);
  this._quit = this.quit.bind(this);
}


GameService.prototype.start = function() {
  this.engine = new Engine(this);
	var chapter = parseInt(data.getCurrentChapter())
	var level = parseInt(data.getCurrentLevel());
	// NOTE: This is needed in case the data storage messes up
	if (chapter > 13 || chapter < 0 ) {
		chapter = 0;
	}
	if (level > data.lvlCount[chapter] || level < 0) {
		level = 0;
	}

  switch (chapter) {
  case 6:
  case 9:
  case 10:
  case 12:
		this.engine.imgFolder = "images_stone";
		break;
  default:
		this.engine.imgFolder = "images";
		break;
  }
	
  this.engine.loadLevel(chapter, level);
  this.timeout = this.engine.timeout.bind(this.engine);

  var highscore = level_service.getHighscores(data.getCurrentChapter(), data.getCurrentLevel(), this._processHighscores);
  this._processHighscores(highscore);

  //this.controller.startListening("#screen", "click", this._onTap);
  
}


GameService.prototype.stop = function() {
  this._fallenDown = false;
  this._reachedGoal = false;
  clearInterval(this.intervalId);
  delete(this.engine);
}

// **************************************************

GameService.prototype.onStageDeactivate = function(event) {
  if (this._reachedGoal) {
		this.reachedGoal();
		return;
  }

  if (this._fallenDown) {
		this.fallenDown();
		return;
  }

  this.pause();
}


GameService.prototype.sendEvent = function(element, event_type) {
  //console.debug("game-service.js: entering -> sendEvent("+element+event_type+")");
  Zepto(element).trigger(event_type);
}

// **************************************************

GameService.prototype.update = function() {
  this.realOldTime = (this.realTime || new Date().getTime());
  this.realTime = new Date().getTime();
  var dt = this.realTime - this.realOldTime;
  
  this.timeout(20);

  /*if (!this.intervalId){
    return;
    }*/
  //this.intervalId = window.setTimeout( requestAnimationFrame(this.update.bind(this)), 20);
  //this.intervalId = window.setTimeout( this.update.bind(this), 20);
  
} 


GameService.prototype.updateStart = function() {
  if (this.intervalId) {
		console.log("WARNING: updateStart, but not needed!");
		return;
  }

  //this.controller.startListening(window, "deviceorientation", this._accel);
	console.log("accel activate");
  window.addEventListener("deviceorientation", this._accel, true);
  
  /*Mojo.Controller.stageController.setWindowProperties({
    fastAccelerometer: true,
    blockScreenTimeout: true,
    setSubtleLightbar: false
    });*/

  this.intervalId = setInterval( this.update.bind(this) , 20);
  
  /*//this.realTime = 0;
    this.intervalId = 1;
    this.update();*/
}


GameService.prototype.updateStop = function() {
  if (!this.intervalId) {
		console.debug("WARN: updateStop, but not needed!");
		return;
  }

  //this.controller.stopListening(window, "deviceorientation", this._accel);
  console.log("accel deactivate");
	window.removeEventListener("deviceorientation", this._accel, true);
  
  /*Mojo.Controller.stageController.setWindowProperties({
    fastAccelerometer: false,
    blockScreenTimeout: false,
    setSubtleLightbar: true
    });*/
  window.clearInterval(this.intervalId);
  this.intervalId = false;
}

// ************* user interface event handling ******************

GameService.prototype.pause = function() {
  if (this._reachedGoal) {
		return;
  }

  if (this.intervalId) {
		this.updateStop();
		
		document.getElementById("msg").style.position = "absolute";
		document.getElementById("msg").style.width = "270px";
		document.getElementById("msg").style.height = "auto";
		document.getElementById("msg").style.top = Math.round((480-133)/2)+"px";
		document.getElementById("msg").style.left = Math.round((320-270-2*2-2*6)/2)+"px";
		document.getElementById("msg").style.background = "rgba(255, 255, 255, 0.7)";
		document.getElementById("msg").style.border = "2px solid darkgray";
		document.getElementById("msg").style.padding = "6px";

		message_compiled_template = Handlebars.compile(this.controller.templates
																									 .msg_pause);
		message_context = { title: $L("Pause"),
												text: $L("Do you need a break?"),
												quit_button_width: "width:120px",//$L("width:84px"),
												quit_button_text: new Handlebars.SafeString($L('Give<br />Up')),
												retry_button_width: "width:120px",//$L("width:84px"),
												retry_button_text: new Handlebars.SafeString($L('Retry<br />Level')),
												continue_button_width: "width:120px",//$L("width:84px"),
												continue_button_text: new Handlebars.SafeString($L("Continue<br />Playing")) };
		
		Zepto("#msg").html(message_compiled_template(message_context));

		this.controller.startListening("#btnQuit", base.event.tap, this._quit);			
		this.controller.startListening("#btnRetry", base.event.tap, this._retryLevel);
		//this.controller.startListening("#btnContinue", base.event.tap, );

		this.controller.showPauseScreen();

		var d = new Date();
		this.pauseTime = d.getTime();	
  }
}

GameService.prototype.unpause = function() {
  if (this._reachedGoal) {
		return;
  }

  if (!this.intervalId) {
		var d = new Date();
		this.timeOnPause += d.getTime() - this.pauseTime;
		this.pauseTime = 0;

		this.controller.stopListening("#btnQuit", base.event.tap, this._quit);			
		this.controller.stopListening("#btnRetry", base.event.tap, this._retryLevel);
		//this.controller.stopListening("#btnContinue", base.event.tap);
		
		this.controller.hidePauseScreen();
		this.updateStart();
  }
}

// ************* game event handling ******************

GameService.prototype.eh_levelLoaded = function(event) {
  //console.debug("game-service.js: entering -> eh_levelLoaded()");
  this.gravX = 0;
  this.gravY = 0.2;
  this._reachedGoal = false;
  this._fallenDown = false;
  this.tries = 1;

  // start time counter
  var d = new Date();
  this.startTime = d.getTime();
  this.pauseTime = 0;
  this.timeOnPause = 0;

  // adjust background
	if (this.engine.imgFolder != "images") {
		document.getElementById("levelBackground").src = this.engine.imgFolder+"/background.jpg";
		//document.getElementById("screen").style.background = "";
	}
	
  this.controller.hidePauseScreen();
  this.controller.startListening("#screen", "click", this._onTap);
  console.log("*** level loaded, ontap activate");

	// show (game controller->show gets called once after setup)
	Zepto(document).trigger("event_setupComplete");
  
	this.updateStart();
}


GameService.prototype.eh_levelRestarted = function(event) {
  //console.debug("game-service.js: entering -> eh_levelRestarted()");
  this.gravX = 0;
  this.gravY = 0;
  this._reachedGoal = false;
  this._fallenDown = false;
  this.tries++;

  // start time counter
  var d = new Date();
  this.startTime = d.getTime();
  this.pauseTime = 0;
  this.timeOnPause = 0;

  this.controller.hidePauseScreen();
  this.controller.startListening("#screen", "click", this._onTap);
  console.log("*** level restarted!, ontap activate");

  this.updateStart();
}


GameService.prototype.reachedGoal = function() {
  //console.debug("game-service.js: entering -> reachedGoal()");
  var d = new Date();
  var timeNeeded = Math.round((d.getTime() - this.startTime - this.timeOnPause) / 10) / 100;


  if (!this.intervalId || ! this.engine) {
		// this function should only be called once per game
		return;
  }
  this.updateStop();

  if (settings && settings.get("vibrate") == true && this._reachedGoal == false) {
		this.vibrate();
  }
  this._reachedGoal = true; // used to only vibrate once

  // Highscores
  if (this.highscores && this.highscores[settings.get("physics")]) {
		if (timeNeeded < this.highscores[settings.get("physics")]) {
	    // faster than before in this difficulty (just put in DB, put don't handle in UI yet)
	    level_service.addHighscore(data.getCurrentChapter(), data.getCurrentLevel(), settings.get("physics"), timeNeeded, this.tries);
		}
  } else {
		//Mojo.Log.error("---- ERROR: this.highscores["+settings.get("physics")+"] does not exist! -----");
  }

  // Message
  if (this.calibRoll < -5) {
		document.getElementById("msg").style.webkitTransform = "rotate(90deg)";
  } else if (this.calibRoll > +5) {
		document.getElementById("msg").style.webkitTransform = "rotate(270deg)";
  } else if (this.calibPitch < -5) {
		document.getElementById("msg").style.webkitTransform = "rotate(0deg)";
  } else if (this.calibPitch > +5) {
		document.getElementById("msg").style.webkitTransform = "rotate(180deg)";
  }

  document.getElementById("msg").style.position = "absolute";
  document.getElementById("msg").style.width = "270px";
  document.getElementById("msg").style.height = "auto";
  document.getElementById("msg").style.top = Math.round((480-195)/2)+"px";
  document.getElementById("msg").style.left = Math.round((320-270-2*2-2*6)/2)+"px";
  document.getElementById("msg").style.background = "rgba(255, 255, 255, 0.7)";
  document.getElementById("msg").style.border = "2px solid darkgray";
  document.getElementById("msg").style.padding = "6px";
  

  if (data.getCurrentLevel() == data.lvlCount[data.getCurrentChapter()]) {
		// *** chapter completed ***
		
		this.chapterJustCompleted = true;

		// chapter done
		data.setChapterDone(data.getCurrentChapter(), true);

		// easy geschafft -> show message for paid version
		if (data.getChapterDone(1) && data.getChapterDone(2) && data.getChapterDone(3) ) { //&& data.getChapterDone(15)
			var message_title = $L("You completed OrbLand Free!");
	    var message_text = $L("If you liked it, <a target='_blank' href='https://marketplace.firefox.com/app/orbland'>try the full version</a> of OrbLand with more levels, more obstacles and even more fun!");
		
/*
			data.setChapterAvailable(4, true);
			data.setChapterAvailable(5, true);
			data.setChapterAvailable(6, true);
			data.setChapterAvailable(7, true);
			data.setChapterAvailable(8, true);
			//data.setChapterAvailable(14, true);
		}


		// medium geschafft
		if (data.getChapterDone(4) && data.getChapterDone(5) && data.getChapterDone(6) &&
				data.getChapterDone(7) && data.getChapterDone(8) ) { //&& data.getChapterDone(14)
	    data.setChapterAvailable(9, true);
	    data.setChapterAvailable(10, true);
	    data.setChapterAvailable(11, true);
	    data.setChapterAvailable(12, true);
		}

		// hard geschafft
		if (data.getChapterDone(9) && data.getChapterDone(10) && data.getChapterDone(11) &&
				data.getChapterDone(12)) {
	    data.setChapterAvailable(13, true);
		}

		if (data.getCurrentChapter() == 13) {
	    var message_title = $L("You completed OrbLand!");
	    var message_text = $L("Now try to beat your records! More levels with new obstacles are coming soon, stay tuned!");
*/
		} else {
	    var message_title = $L("You completed this Chapter");
	    var message_text = $L("Continue and guide The Orb through the next chapter or try to beat your records!");
		}
		
		var time = sprintf($L('Time needed: %s'), niceTime(timeNeeded));

		if (timeNeeded < this.highscore) {
	    var record_color = "darkgreen";
	    var record_text = $L('This is a new record!');
		} else {
	    var record_color = "black";
	    var record_text = sprintf($L('Record: %s'), niceTime(this.highscore));
		}

		message_compiled_template = Handlebars.compile(this.controller.templates.msg_complete);
		message_context = { title: message_title,
												text: new Handlebars.SafeString(message_text),
												time: time,
												record_color: record_color,
												record_text: new Handlebars.SafeString(record_text),
												quit_button_width: "width:120px",//$L("width:100px"), 
												quit_button_image: "images/smilie.png",
												quit_button_color: "#f6e163", //yellow
												quit_button_text: new Handlebars.SafeString($L('Chapter<br />Finished')),
												retry_button_width: "width:120px",//$L("width:100px"), 
												retry_button_text: new Handlebars.SafeString($L('Play<br />Again')) };
		
		Zepto("#msg").html(message_compiled_template(message_context));

		this.controller.startListening("#btnRetry", base.event.tap, this._retryLevel);
		this.controller.startListening("#btnQuit", base.event.tap, this._quit);

  } else {
		// *** Level completed, Continue ***

		this.chapterJustCompleted = false;
		var message_title = $L("You saved The Orb");
		var message_text = $L("Continue and guide The Orb through the next level or try to beat your record!");

		if (timeNeeded < this.highscore) {
	    var record_color = "darkgreen";
	    var record_text = $L('This is a new record!');
		} else {
	    var record_color = "black";
	    var record_text = sprintf($L('Record: %s'), niceTime(this.highscore));
		}

		var time = sprintf($L('Time needed: %s'), niceTime(timeNeeded));
		
		message_compiled_template = Handlebars.compile(this.controller.templates.msg_complete);
		message_context = { title: message_title,
												text: message_text,
												time: time,
												record_color: record_color,
												record_text: new Handlebars.SafeString(record_text),
												quit_button_width: "width:120px",//$L("width:84px"), 
												quit_button_image: "images/icon_quit.png",
												quit_button_text: new Handlebars.SafeString($L('Quit')),
												retry_button_width: "width:120px",//$L("width:84px"), 
												quit_button_color: "#fe1b1b", //red
												retry_button_text: new Handlebars.SafeString($L('Play<br />Again')),
												continue_button_width: "width:120px",//$L("width:84px"),
												continue_button_text: new Handlebars.SafeString($L('Next<br />Level')) };
		
		Zepto("#msg").html(message_compiled_template(message_context));
		
		this.controller.startListening("#btnQuit", base.event.tap, this._quit);
		this.controller.startListening("#btnRetry", base.event.tap, this._retryLevel);
		this.controller.startListening("#btnContinue", base.event.tap, this._nextLevel);
  }

  this.controller.stopListening("#screen", "click", this._onTap);
  console.log("*** reached goal!, ontap deactivate");
  this.controller.showPauseScreen();

}


GameService.prototype.fallenDown = function(obstacle) {
  //console.debug("game-service.js: entering -> fallenDown()");
  if (!this.intervalId || ! this.engine) {
		// this function should only be called once per game
		return;
  }
  this.updateStop();

  if (settings && settings.get("vibrate") == true && this._fallenDown == false) {
		this.vibrate();
  }
  this._fallenDown = true;

  // Message
  var message_title;
  switch (obstacle) {
  case "hole":
		message_title = $L("The Orb fell into a hole");
		break;
  case "mine":
		message_title = $L("The Orb hit a mine");
		break;
  default:
		message_title = $L("The Orb didn't make it");
		break;
  }

  if (this.calibRoll < -5) {
		document.getElementById("msg").style.webkitTransform = "rotate(90deg)";
  } else if (this.calibRoll > +5) {
		document.getElementById("msg").style.webkitTransform = "rotate(270deg)";
  } else if (this.calibPitch < -5) {
		document.getElementById("msg").style.webkitTransform = "rotate(0deg)";
  } else if (this.calibPitch > +5) {
		document.getElementById("msg").style.webkitTransform = "rotate(180deg)";
  }
  
  document.getElementById("msg").style.position = "absolute";
  document.getElementById("msg").style.width = "270px";
  document.getElementById("msg").style.height = "auto";
  document.getElementById("msg").style.top = Math.round((480-133)/2)+"px";
  document.getElementById("msg").style.left = Math.round((320-270-2*2-2*6)/2)+"px";
  document.getElementById("msg").style.background = "rgba(255, 255, 255, 0.7)";
  document.getElementById("msg").style.border = "2px solid darkgray";
  document.getElementById("msg").style.padding = "6px";
  
  message_compiled_template = Handlebars.compile(this.controller.templates.msg_retry);
  message_context = { title: message_title,
											text: $L('Poor little Orb. Try harder to help him reach the goal!'),
											quit_button_width: "width:120px",//$L("width:84px"),
											quit_button_text: new Handlebars.SafeString($L('Give<br />Up')),
											retry_button_width: "width:120px",//$L("width:84px"),
											retry_button_text: new Handlebars.SafeString($L('Retry<br />Level')) };
  
  Zepto("#msg").html(message_compiled_template(message_context));


  this.controller.startListening("#btnQuit", base.event.tap, this._quit);			
  this.controller.startListening("#btnRetry", base.event.tap, this._retryLevel);

  this.controller.stopListening("#screen", "click", this._onTap);
  console.log("*** fallendown, ontap deactivate");
  this.controller.showPauseScreen();
}


GameService.prototype.nextLevel = function() {
  //console.debug("game-service.js: entering -> nextLevel()");
  this.controller.stopListening("#btnRetry", base.event.tap, this._retryLevel);
  this.controller.stopListening("#btnNext", base.event.tap, this._nextLevel);
  
  data.setCurrentLevel(data.getCurrentLevel() + 1);
  this._reachedGoal = false;

  this.engine.loadLevel(data.getCurrentChapter(), data.getCurrentLevel());
  var highscore = level_service.getHighscores(data.getCurrentChapter(), data.getCurrentLevel());
  this._processHighscores(highscore);
}


GameService.prototype.retryLevel = function(event) {
  //console.debug("game-service.js: entering -> retryLevel()");
  event.stopPropagation();
  try {
		this.controller.stopListening("#btnQuit", base.event.tap, this._quit);
  } catch (err) {}
  this.controller.stopListening("#btnRetry", base.event.tap, this._retryLevel);
  try {
		this.controller.stopListening("#btnNext", base.event.tap, this._nextLevel);
  } catch (err) {}
  this.controller.stopListening("#screen", "click", this._onTap);
  console.log('*** retry, ontap deactivate');

  this._reachedGoal = false;
  //this.engine.loadLevel(data.getCurrentChapter(), data.getCurrentLevel());
  this.engine.restartLevel();

  var highscore = level_service.getHighscores(data.getCurrentChapter(), data.getCurrentLevel());
  this._processHighscores(highscore);
}	


GameService.prototype.quit = function() {
  //console.debug("game-service.js: entering -> quit()");
  this.controller.stopListening("#btnQuit", base.event.tap, this._quit);
  this.controller.stopListening("#btnRetry", base.event.tap, this._retryLevel);
  this.controller.hidePauseScreen();
  
  this._fallenDown = false;
  if (this.chapterJustCompleted) {
		// last level of chapter has been completed, show CHAPTER chooser
		this.controller.base.showView(1);
  } else {
		// some level has been completed, show LEVEL chooser
		this.controller.base.showView(2);
  }
}	


GameService.prototype.processHighscores = function(highscores) {
  this.highscore = 99999;
  this.highscores = [];
  this.highscores["easy"] = 99999;
  this.highscores["medium"] = 99999;
  this.highscores["realistic"] = 99999;

  for (var i = 0; i < highscores.length; ++i) {
		if (highscores[i]["time"] < this.highscore) {
	    this.highscore = highscores[i]["time"];
		}
		this.highscores[highscores[i]["difficulty"]] = highscores[i]["time"];
  }
}


//*********** user input event handling ************** 

GameService.prototype.handleAcceleration = function(orientData) {
  if (this.intervalId && ! this.disableAccelForEmu) {
		/*	
	  		var gravX = event.roll - this.calibRoll;
				var gravY = event.pitch - this.calibPitch;
				
				if (gravX > - 1 && gravX < 1) {
				gravX = 0;
				}
				if (gravY > - 1 && gravY < 1) {
				gravY = 0;
				}
	  		//Mojo.Log.error("x,y="+gravX+","+gravY);
   			this.engine.gravity.x = + 0.03 * gravX;
				this.engine.gravity.y = - 0.03 * gravY;
		*/

		var absolute = orientData.absolute;
		var alpha = orientData.alpha;
		var beta = orientData.beta;
		var gamma = orientData.gamma;

		var gravX = -0.016 * Math.pow(Math.abs(gamma),1.5) * sign(gamma);//-0.04 * gamma;

		var gravY = -0.016 * Math.pow(Math.abs(beta),1.5) * sign(beta);//-0.05 * beta;

		/*
		// lowpass filter
		this.gravXFilter.shift();
		this.gravXFilter.push(cur_gravX);
		var gravX = 0;
		for (var i in this.gravXFilter) {
		gravX += this.gravXFilter[i] * 0.25;
		}

		this.gravYFilter.shift();
		this.gravYFilter.push(cur_gravY);
		var gravY = 0;
		for (var i in this.gravYFilter) {
		gravY += this.gravYFilter[i] * 0.25;
		}
		*/
		

		//zero thresholding
		/*if (gravX > - 0.08 && gravX < 0.08) {
			gravX = 0;
			}
			if (gravY > - 0.08 && gravY < 0.08) {
			gravY = 0;
			}*/

		this.engine.gravity.x = gravX;
		this.engine.gravity.y = gravY;

		//screenDebug("x: "+this.engine.gravity.x+ "<br/>y: "+this.engine.gravity.y+ "<br/>beta: "+beta +"<br/>gamma: "+gamma);
  }

}

sign = function(x) {
	if (x >= 0) {
		return 1;
	}
	return -1;
}

GameService.prototype.onTap = function(event) {
  //console.debug("game-service.js: entering -> onTap()");
  event.stopPropagation();

  if (this.intervalId) {
		this.pause();
  } else {
		this.unpause();
  }
}

//debug
GameService.prototype.onKeyDown = function(event) {               
  this.disableAccelForEmu = true;                                 
  var delta = 0.2;                                              
  switch (event.keyCode) {                                      
  case 87: //s                                                 
		this.engine.gravity.y -= delta;                             
		break;                                                      
  case 65: //a                                                     
		this.engine.gravity.x -= delta;                             
		break;                                                      
  case 83: //d                                                     
		this.engine.gravity.y += delta;                             
		break;                                                      
  case 68: //w                                                     
		this.engine.gravity.x += delta;                             
		break;                                                      
  case 80: //p
		this.reachedGoal();
		break;
  }
}     

//*********************************************

GameService.prototype.initSound = function(sound_name, source) {
  cur_audio = new Audio();
  cur_audio.autoplay = false;
  cur_audio.src = source;
  cur_audio.load(); //TODO: wait on ready
  this.sounds[sound_name] = cur_audio;
}

GameService.prototype.playSound = function(sound_name) {
  if (sound_name in this.sounds) {
		this.sounds[sound_name].play();
  } else {
		console.error("game-service.js: error -> sound "+sound_name+" not found");
  }
}

GameService.prototype.vibrate = function() {
  if('vibrate' in navigator) {
		// vibrate for a (half)second
		navigator.vibrate(500);
  } 
  else {
		console.warn("game-service.js: warning -> vibrate-api not found")
  }
}

//*********************************************