//
//	game_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function GameController(base) {
  this.name = "game";
  this.base = base;
}


GameController.prototype.init = function() {
  this.templates = [];
  this.base.loadTemplate(this, "main");
  this.base.loadTemplate(this, "msg_pause");
  this.base.loadTemplate(this, "msg_retry");
  this.base.loadTemplate(this, "msg_complete");

  this.game_service = new GameService(this);
}


GameController.prototype.setup = function() {
  //console.debug("game-controller.js: entering -> setup()");
  Zepto(document).on("event_levelLoaded",  this.game_service._eh_levelLoaded);
  Zepto(document).on("event_levelRestarted", this.game_service._eh_levelRestarted);
  
  this.game_service.start();
  return false;
}


GameController.prototype.activate = function() {
  //console.debug("game-controller.js: entering -> activate()");
	//debug
	if (global_debug) {
		window.addEventListener("keydown", this.game_service._onKeyDown, true);
		screenDebug("<a id='dbgBtnReachedGoal'>next</a>")
		this.startListening("#dbgBtnReachedGoal", base.event.tap, Zepto.proxy(function() {this.game_service.reachedGoal()}, this));
	}

}


GameController.prototype.show = function() {
  //console.debug("game-controller.js: entering -> show()");
  
	//is done in eh_levelLoaded (also on level change within game view)
  //this.game_service.updateStart();
}


GameController.prototype.deactivate = function() {
  //console.debug("game-controller.js: entering -> deactivate()");
  //this.controller.listen(document, Mojo.Event.stageDeactivate, this._onStageDeactivate);

  this.game_service.updateStop();
  
  Zepto(document).off("event_levelLoaded", this.game_service._eh_levelLoaded);
  Zepto(document).off("event_levelRestarted", this.game_service._eh_levelRestarted);
  Zepto("#screen").off("click", this.game_service._onTap);
  console.log('*** deactivate, ontap off');

  //Mojo.Event.stopListening(document, Mojo.Event.stageDeactivate, this._onStageDeactivate);

	if (global_debug) {
		window.removeEventListener("keydown", this.game_service._onKeyDown, true); //dbg
	}

  this.game_service.stop();

  //Zepto('#content').css('display', 'none');
}


GameController.prototype.on_unload = function() {
  //this.game_service.onStageDeactivate();
}


GameController.prototype.handleClickEvent = function() {

}

//*********************************************

GameController.prototype.startListening = function(element, event_type, handler) {
  Zepto(element).on(event_type, handler);
}

GameController.prototype.stopListening = function(element, event_type, handler) {
  Zepto(element).off(event_type, handler);
}


//*********************************************

GameController.prototype.showPauseScreen = function(messageId) {
  Zepto("#pauseOverlay").css('visibility', 'visible');
}

GameController.prototype.hidePauseScreen = function(messageId) {
  Zepto("#pauseOverlay").css('visibility', 'hidden');
}
