function Bumper( id, x, y, r, color ) {
  Interactive.call(this, id);
  this.x = x;
  this.y = y;
  this.r = r;
  this.position = new Vector( x, y );
  this.color = color;
  this.redraw = 2;
  this.dist = 2.5/(this.r+10);
}

Bumper.prototype = new Interactive();
Bumper.prototype.constructor = Bumper;

Bumper.prototype.setToDefault = function() {
  return;
}

Bumper.prototype.getPosition = function() {
  return this.position;
}

Bumper.prototype.scBall = function(ball) {
  //Test for collision
  
  
  result = circleCircle( this, this.r, ball, ball.r );

  if(result['collide']) {
    sVector = result['sVector'];
    mirrorAxis = result['edge'];
	  var ballcenter = ball.center;
    ballcenter.getPreviousPosition().mirror( mirrorAxis, ballcenter.getPosition() );
    ballcenter.addPosition( sVector );
    mirrorAxis.normal();
    mirrorAxis.scale(3.0);
    var x = ballcenter.cur.x; 
    var y = ballcenter.cur.y;
    x -= this.x;
    y -= this.y;
    x = x*this.dist;
    y = y*this.dist;
    ballcenter.prev.set( ballcenter.getPosition() );
    ballcenter.prev.x -= x;
    ballcenter.prev.y -= y;
    this.redraw = 1;
  }
}

Bumper.prototype.draw = function() {
  if( typeof(this.imageSmall) === 'undefined' || this.imageSmall == null ) {
    this.imageSmall = document.getElementById(this.id+"_small");
  }
  if( typeof(this.imageBig) === 'undefined' || this.imageBig == null ) {
    this.imageBig = document.getElementById(this.id+"_big");
  }
  if( this.redraw == 1 ) {
    this.imageBig.style.visibility = 'visible';
  } else {
    this.imageBig.style.visibility = 'hidden';
  }
  if( this.redraw == 1 ) {
    this.redraw = 2;
  } else {
    this.redraw = 0;
  }
}

Bumper.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV)  {
  var aabb = new Aabb(this.x-this.r, this.y-this.r, this.r*2, this.r*2);
  return getAabbSectors(aabb, numberHSectors, numberVSectors, widthOH, heightOV);
  //return getCircleSectors(this.position, this.r, numberHSectors, numberVSectors, widthOH, heightOV);
}
