function Circle( x, y, r, mass, imageId ) {
  this.center = new PointMass( x, y, mass );
  this.r = r;
  this.visible = true;
  this.color = '#000000';
  this.imageId = imageId;
  this.image = false;
  this.passive = false;
  this.opacity = 0;
  this._fallenDown = false;
  this._reachedGoal = false;
  this._exploded = false;
  this._fallenDownX = 0;
  this._fallenDownY = 0;
  this.finished = true;
  this._pipePassive = false;
}

Circle.prototype.setPassive = function() {
  this.passive = true;
}

Circle.prototype.reset = function() {
  this.passive = false;
  this.opacity = 0;
  this._fallenDown = false;
  this._reachedGoal = false;
  this._fallenDownX = 0;
  this._fallenDownY = 0;
  this._pipePassive = false;
}

Circle.prototype.setActive = function() {
  this.passive = false;
}

Circle.prototype.setOpacity = function(opacity) {
  this.opacity = opacity;
}

Circle.prototype.setFallenDown = function(x, y) {
  //Mojo.Log.error("fallen down");
  this.finished = false;
  this._fallenDown = true;
  this.setPassive();
  this._fallenDownX = x;
  this._fallenDownY = y;
}

Circle.prototype.setReachedGoal = function(x, y) {
  this.setPassive();
  this.finished = false;
  this._reachedGoal = true;
  this._fallenDownX = x;
  this._fallenDownY = y;
}

Circle.prototype.setExploded = function() {
  this.setPassive();
  this.finished = false;
  this._exploded = true;
  this.opacity = 1;
}

Circle.prototype.fallenAnimation = function() {
  if( this.finished ) {
    return;
  }
  if (this._fallenDown || this._reachedGoal) {
	  var diffX = Math.round(this._fallenDownX - this.center.getXPosition());
	  var diffY = Math.round(this._fallenDownY - this.center.getYPosition());

	  if (diffX != 0) {
		  // FIXME: +1, -1 abhängig von gravitiy bzw. speed machen
		  this.center.setXPosition(this.center.getXPosition() + (diffX > 0 ? 0.3 : -0.3));
	  }
	  if (diffY != 0) {
		  this.center.setYPosition(this.center.getYPosition() + (diffY > 0 ? 0.3 : -0.3));
	  }

	  if (diffX != 0 || diffY != 0) {
		  this.opacity = 1;
      //this.finished = true;
		  return;
	  }
  }

	if (this._fallenDown) {
		if (this.opacity > 0) {
			this.opacity -= 0.016;
			this.image.style.opacity = this.opacity;
			// FIXME: opa nachher auf 1 setzen wieder
	
			return;
		}
    this.finished = true;

		// finished, now continue with rest of function

	} else if (this._reachedGoal) {
		if (this.opacity > 0) {
			this.opacity -= 0.016;
			this.image.style.opacity = this.opacity;
			// FIXME: wie oben!
      return;
	  }
    this.finished = true;
		// finished, now continue with rest of function
	}

  if( this._exploded ) {
    //Mojo.Log.error( "_logged" );
    if( this.opacity > 0 ) {
      this.opacity -= 0.016;
      this.image.style.opacity = this.opacity;
      return;
    }
    this.finished = true;
  }
}

Circle.prototype.isFinished = function() {
  return this.finished;
}

Circle.prototype.isPassive = function() {
  return this.passive;
}

Circle.prototype.isActive = function() {
  return !this.passive;
}

Circle.prototype.isPipeActive = function() {
  return !this._pipePassive;
}

Circle.prototype.isPipePassive = function() {
  return this._pipePassive;
}

Circle.prototype.setPipePassive = function() {
  this._pipePassive = true;
}

Circle.prototype.setPipeActive = function() {
  this._pipePassive = false;
}

Circle.prototype.move = function(dt) {
  this.center.move(dt);
}

Circle.prototype.passiveAnimation = function() {
  if( this._fallenDown || this._reachedGoal || this._exploded ) {
    this.fallenAnimation();
    return;
  }
}

Circle.prototype.setForce = function(force) {
    this.center.setForce(force);
}

Circle.prototype.addForce = function(force) {
    this.center.addForce(force);
}

Circle.prototype.getPosition = function() {
  return this.center.getPosition();
}

Circle.prototype.scBall = function(ball) {
  if( this.isPassive() || ball.isPassive() ) {
    return;
  }
  //Test for real collision
  var damping = 0.9;
  var result = circleCircle( this, this.r, ball, ball.r );
  if( result['collide'] ) {
    cVector = result['sVector'];
    mirrorAxis = result['edge'];
    //stop balls from penetrating each other
    cVector.scale(0.5);
    ball.center.addPosition( cVector );
    ball.center.getPreviousPosition().add( cVector );
    cVector.scale(-1.0);

    //calculate new velocity vectors
    this.center.addPosition( cVector );
    this.center.getPreviousPosition().add( cVector );

    //Keep tangential component of ball
    velocityBall = ball.center.getVelocityVector();
    tangBall = new Vector( mirrorAxis.x, mirrorAxis.y );
    tangBall.scale(velocityBall.dotProduct(mirrorAxis)*damping);
    tangBall.add(ball.getPosition());

    //Keep tangential component of self
    velocitySelf = this.center.getVelocityVector();
    tangSelf = new Vector( mirrorAxis.x, mirrorAxis.y );
    tangSelf.scale(velocitySelf.dotProduct(mirrorAxis)*damping);
    tangSelf.add(this.getPosition());

    //switch normal components
    mirrorAxis.normal();
    normSelf = new Vector( mirrorAxis.x, mirrorAxis.y );
    normBall = new Vector( mirrorAxis.x, mirrorAxis.y );
    normBall.scale(velocityBall.dotProduct(mirrorAxis)*damping);
    normSelf.scale(velocitySelf.dotProduct(mirrorAxis)*damping);
    tangBall.add(normSelf);
    tangSelf.add(normBall);

    this.center.setPreviousPosition(tangSelf);
    ball.center.setPreviousPosition(tangBall);
  }
}

Circle.prototype.scHole = function(hole) {
  var cPos = this.center.getPosition();
  var minR = hole.r+1;
  if( Math.abs(cPos.x-hole.x) > minR ||
      Math.abs(cPos.y-hole.y) > minR ) {
    return false;
  }

  var dist = new Vector( hole.x, hole.y );
  dist.sub( cPos );
  if( dist.length() < minR ) {
    return true;
  }
  return false;
}

Circle.prototype.scEnv = function(env) {
  var collided = false;
  var helpVector = null;
  var sVector = null;
  var mirrorPoint = null;
  var mirrorAxis = null;
  var position = new Vector( 0.0, 0.0 );
  var result;

  //Top
  position.x = this.center.getPosition().x;
  position.y = this.center.getPosition().y + this.r;
  result = env.testCollision( position );
  if(result['collide']) {
    sVector = result['sVector'];
    mirrorPoint = result['ePoint'];
    mirrorAxis = result['edge'];
    this.center.getPreviousPosition().mirror( mirrorAxis, this.center.getPosition() );
    this.center.addPosition( sVector );
    this.center.getPreviousPosition().add( sVector );
  }
  //Right
  position.x = this.center.getPosition().x + this.r ;
  position.y = this.center.getPosition().y;
  result = env.testCollision( position );
  if(result['collide']) {
    sVector = result['sVector'];
    mirrorPoint = result['ePoint'];
    mirrorAxis = result['edge'];
    this.center.getPreviousPosition().mirror( mirrorAxis, this.center.getPosition() );
    this.center.addPosition( sVector );
    this.center.getPreviousPosition().add( sVector );
  }
  //Bottom
  position.x = this.center.getPosition().x;
  position.y = this.center.getPosition().y - this.r;
  result = env.testCollision( position );
  if(result['collide']) {
    sVector = result['sVector'];
    mirrorPoint = result['ePoint'];
    mirrorAxis = result['edge'];
    this.center.getPreviousPosition().mirror( mirrorAxis, this.center.getPosition() );
    this.center.addPosition( sVector );
    this.center.getPreviousPosition().add( sVector );
  }
  //Left
  position.x = this.center.getPosition().x - this.r;
  position.y = this.center.getPosition().y;
  result = env.testCollision( position );
  if(result['collide']) {
    sVector = result['sVector'];
    mirrorPoint = result['ePoint'];
    mirrorAxis = result['edge'];
    this.center.getPreviousPosition().mirror( mirrorAxis, this.center.getPosition() );
    this.center.addPosition( sVector );
    this.center.getPreviousPosition().add( sVector );
  }
}

Circle.prototype.scAabb = function( aabb, counter ) {
  if( !aabb.checkCounter(counter) ) {
    return;
  }
  var result = circleAabb( this, aabb );
  if(result['collide']) {
    this.center.getPreviousPosition().mirror( result['edge'], this.center.getPosition() );
    this.center.addPosition( result['cVector'] );
    this.center.getPreviousPosition().add( result['cVector'] );
  }
}

Circle.prototype.draw = function() {
  this.image.style.left = (Math.round(this.center.cur.x-this.r))+'px';
  this.image.style.top = (Math.round(this.center.cur.y-this.r))+'px';
}
