function circleAabb( circle, aabb ) {
  var cPos = circle.center.cur;
  var result = {};
  result['collide'] = false;
  var region = 0;
  var xDist;
  if( cPos.x < aabb.x ) {
    xDist = cPos.x - aabb.x;
  } else {
    if( cPos.x < aabb.x2 ) {
      region = 1;
      //xDist = Math.min( cPos.x - aabb.x, cPos.x - aabb.x2 ); 
    } else {
      region = 2;
      xDist = cPos.x - aabb.x2;
    }
  }
  if( region != 1 ) {
    if( Math.abs(xDist) >= circle.r ) {
      return result;
    }
  }
  var yDist;
  if( cPos.y < aabb.y ) {
    yDist = cPos.y - aabb.y;
  } else {
    if( cPos.y < aabb.y2 ) {
      region += 4;
      //yDist = Math.min( cPos.y - aabb.y, cPos.y - aabb.y2 );
    } else {
      region += 8;
      yDist = cPos.y - aabb.y2;
    }
  }
  if( !( region & 4 ) ) {
  //if( region == 0 || region == 1 || region == 2 || region == 8 || region == 9 || region == 10 ) {
    if( Math.abs( yDist ) >= circle.r ) {
      return result;
    }
  }
  // Round Corners calculations:
  if( aabb.rounds != 0 ) {
    // Topleft round
    if( aabb.rounds & 1 ) {
      if( cPos.x < aabb.x+20 && cPos.y < aabb.y+20 ) {
        return cornerCollision( new Vector( aabb.x+20.0, aabb.y+20.0 ), 20.0, circle.getPosition(), circle.r );
      }
    }
    if( aabb.rounds & 2 ) {
      if( cPos.x > aabb.x2-20 && cPos.y < aabb.y+20 ) {
        return cornerCollision( new Vector( aabb.x2-20.0, aabb.y+20.0 ), 20.0, circle.getPosition(), circle.r );
      }
    }
    if( aabb.rounds & 4 ) {
      if( cPos.x < aabb.x+20 && cPos.y > aabb.y2-20 ) {
        return cornerCollision( new Vector( aabb.x+20.0, aabb.y2-20.0 ), 20.0, circle.getPosition(), circle.r );
      }
    }
    if( aabb.rounds & 8 ) {
      if( cPos.x > aabb.x2-20 && cPos.y > aabb.y2-20 ) {
        return cornerCollision( new Vector( aabb.x2-20.0, aabb.y2-20.0 ), 20.0, circle.getPosition(), circle.r );
      }
    }
  }
  //Mojo.Log.error( "region: "+region );
  if( region == 4 ) {
    // we are either x left of x right
    result['collide'] = true;
    //Mojo.Log.error( "xDist: "+xDist );
    result['cVector'] = new Vector( -(xDist+circle.r), 0.0 );  
    //Mojo.Log.error( "cDist: "+(xDist+circle.r) );
    result['edge'] = new Vector( 0.0, 1.0 );
    return result;
  }
  if ( region == 6 ) {
    // we are either x left of x right
    result['collide'] = true;
    result['cVector'] = new Vector( circle.r-xDist, 0.0 );
    //Mojo.Log.error( "xDist: "+(xDist-circle.r) );
    result['edge'] = new Vector( 0.0, 1.0 );
    return result;
  }
  if( region == 1 ) {
    result['collide'] = true;
    var cDist = -(yDist+circle.r);
    result['cVector'] = new Vector( 0.0, cDist );
    //Mojo.Log.error( "cDist: "+cDist );
    result['edge'] = new Vector( 1.0, 0.0 );
    return result;
  }
  if( region == 9 ) {
    result['collide'] = true;
    var cDist = circle.r-yDist;
    //Mojo.Log.error( "yDist: "+yDist );
    result['cVector'] = new Vector( 0.0, cDist );
    //Mojo.Log.error( "cDist: "+cDist );
    result['edge'] = new Vector( 1.0, 0.0 );
    return result;
  }
  if( region == 0 ) {
    if( aabb.noCollide & 1 ) {
      //alert("no Collide 0");
      return result;
    }
    result['cVector'] = new Vector( cPos.x, cPos.y );
    result['cVector'].x -= aabb.x;
    result['cVector'].y -= aabb.y;
    var axDist = result['cVector'].length();
    if( circle.r < axDist ) {
      return result;
    }
    //result['cVector'].scale(1/axDist);
    result['cVector'].normalize();
    result['edge'] = new Vector( -result['cVector'].y, result['cVector'].x );
    //alert( "edge.lengt: "+result['edge'].length() );
    result['cVector'].scale(circle.r-axDist);
    //alert( "axDist: "+axDist+" cVector.x: "+result['cVector'].x+" cVector.y: "+result['cVector'].y);
    result['collide'] = true;
    return result;
  }
  //alert( "noCollide: "+aabb.noCollide );
  if( region == 2 ) {
    
    if( aabb.noCollide & 2 ) {
      //alert("no Collide 2");
      return result;
    }
    result['cVector'] = new Vector( cPos.x, cPos.y );
    result['cVector'].x -= aabb.x2;
    result['cVector'].y -= aabb.y;
    var axDist = result['cVector'].length();
    if( circle.r < axDist ) {
      return result;
    }
    result['cVector'].normalize();
    result['edge'] = new Vector( -result['cVector'].y, result['cVector'].x );
    result['cVector'].scale(circle.r-axDist);
    result['collide'] = true;
    return result;
  }
  if( region == 8 ) {
    if( aabb.noCollide & 8 ) {
      //alert("no Collide 8");
      return result;
    }
    result['cVector'] = new Vector( cPos.x, cPos.y );
    result['cVector'].x -= aabb.x;
    result['cVector'].y -= aabb.y2;
    var axDist = result['cVector'].length();
    if( circle.r < axDist ) {
      return result;
    }
    result['cVector'].normalize();
    result['edge'] = new Vector( -result['cVector'].y, result['cVector'].x );
    result['cVector'].scale(circle.r-axDist);
    result['collide'] = true;
    return result;
  }
  if( region == 10 ) {
    if( aabb.noCollide & 4 ) {
      //alert("no Collide 10");
      return result;
    }
    result['cVector'] = new Vector( cPos.x, cPos.y );
    result['cVector'].x -= aabb.x2;
    result['cVector'].y -= aabb.y2;
    var axDist = result['cVector'].length();
    if( circle.r < axDist ) {
      return result;
    }
    result['cVector'].normalize();
    result['edge'] = new Vector( -result['cVector'].y, result['cVector'].x );
    result['cVector'].scale(circle.r-axDist);
    result['collide'] = true;
    return result;
  }
  if( region == 5 ) {
    xDist = Math.min( cPos.x - aabb.x, cPos.x - aabb.x2 );
    yDist = Math.min( cPos.y - aabb.y, cPos.y - aabb.y2 );
    result['collide'] = true;
    if( xDist < yDist ) {
      result['edge'] = new Vector( 0.0, 1.0 );
      if( cPos.x < aabb.x+aabb.width/2 ) {
        result['cVector'] = new Vector( -xDist, 0.0 );
      } else {
        result['cVector'] = new Vector( xDist, 0.0 );
      }
    } else {
      result['edge'] = new Vector( 1.0, 0.0 );
      if( cPos.y < aabb.y+aabb.height/2 ) {
        result['cVector'] = new Vector( 0.0, -yDist );
      } else {
        result['cVector'] = new Vector( 0.0, yDist );
      }
    }
    return result;
  }
  return result;
}

function cornerCollision( cAPos, rA, cBPos, rB ) {
  result = {}
  result['collide'] = false;
  result['sVector'] = null;
  result['edge'] = null;
  result['dist'] = null;
  minR = rA+rB;
  if( Math.abs(cAPos.x-cBPos.x) > minR ||
      Math.abs(cAPos.y-cBPos.y) > minR ) {
    return result;
  }

  axis = new Vector( cBPos.x, cBPos.y );
  axis.sub( cAPos );
  length = axis.length();

  if( length < minR ) {
    axis.normalize();
    result['cVector'] = new Vector( axis.x, axis.y );
    result['cVector'].scale( minR-length );
    result['edge'] = new Vector( axis.x, axis.y );
    result['edge'].normal();
    result['collide'] = true;
    result['dist'] = length;
    return result;
  }
  return result;
}
