function Data() {
	this.storage_id = "level_progress";
	this.storage = new Storage(this.storage_id);

  /////////////
  // leveldata
  /////////////
  this.lvlCount = [];

  // training
  this.lvlCount[0] = 7;

  // kapitel 1 (easy)
  this.lvlCount[1] = 9;
  this.lvlCount[2] = 12;
  this.lvlCount[3] = 10;
  //this.lvlCount[15] = 11; // Round

  // kapitel 2 (medium)
  this.lvlCount[4] = 9;
  this.lvlCount[5] = 8;
  //this.lvlCount[14] = 11; // Bumper	
  this.lvlCount[6] = 7;
  this.lvlCount[7] = 8;
  this.lvlCount[8] = 9;

  // kapitel 3 (hard)
  this.lvlCount[9] = 4;
  this.lvlCount[10] = 9;
  this.lvlCount[11] = 10;
  this.lvlCount[12] = 6;

  // impossible
  this.lvlCount[13] = 3;

  this.init();
}

Data.prototype.init = function() {
	//read in all the data
  //this.maxLevel = new Mojo.Model.Cookie("MAX_LEVEL");
  //this.currentLevel = new Mojo.Model.Cookie("CURRENT_LEVEL");
  //this.currentChapter = new Mojo.Model.Cookie("CURRENT_CHAPTER");
	if (this.getCurrentLevel() == null) {
	  this.setCurrentLevel(1);
  }
  if (this.getCurrentChapter() == null) {
		this.setCurrentChapter(0);
  }
  if (this.getMaxLevel() == null) {
		this.setMaxLevel(1);
  }

  // training
  this.setChapterAvailable(0, true);

  // easy
  this.setChapterAvailable(1, true);
  this.setChapterAvailable(2, true);
  this.setChapterAvailable(3, true);
  //this.setChapterAvailable(15, true);

  // medium after upate
  /*if (this.getChapterAvailable(4)) {
		this.setChapterAvailable(14, true);
    }*/
  /*	
			for (var i=0; i<=13; ++i) {
			this.setChapterAvailable(i, true);
			}
  */
}

Data.prototype.getChapterAvailable = function(Chapter) {
  /*if (Chapter == 14) {
		Chapter = "bumper";
    }
    if (Chapter == 15) {
		Chapter = "round";
    }*/
  /*var cookie = new Mojo.Model.Cookie("Chapter_AVAILABLE_"+Chapter);
    Mojo.Log.error("getChapterAvailable("+Chapter+")="+cookie.get());		
    if (cookie.get() == null) {
		return false;
    }
    return cookie.get();*/
  if (this.getData("Chapter_AVAILABLE_"+Chapter) == null) {
		return false;
  }
  return this.getData("Chapter_AVAILABLE_"+Chapter);
}

Data.prototype.setChapterAvailable = function(Chapter, value) {
  /*if (Chapter == 14) {
		Chapter = "bumper";
    }
    if (Chapter == 15) {
		Chapter = "round";
    }*/
  /*Mojo.Log.error("setChapterAvailable("+Chapter+", "+value+")");
    var cookie = new Mojo.Model.Cookie("Chapter_AVAILABLE_"+Chapter);
    cookie.put(value);*/
  this.setData("Chapter_AVAILABLE_"+Chapter, value);
}

Data.prototype.getChapterDone = function(Chapter) {
  /*if (Chapter == 14) {
		Chapter = "bumper";
    }
    if (Chapter == 15) {
		Chapter = "round";
    }*/
  /*var cookie = new Mojo.Model.Cookie("Chapter_DONE_"+Chapter);
  // Mojo.Log.error("getChapterDone("+Chapter+")="+cookie.get());	
  if (cookie.get() == null) {
	return false;
  }
  return cookie.get();*/
  if (this.getData("Chapter_DONE_"+Chapter) == null) {
		return false;
  }
  return this.getData("Chapter_DONE_"+Chapter);
}

Data.prototype.setChapterDone = function(Chapter, value) {
  /*if (Chapter == 14) {
		Chapter = "bumper";
    }*/
  /*Mojo.Log.error("setChapterDone("+Chapter+", "+value+")");
    var cookie = new Mojo.Model.Cookie("Chapter_DONE_"+Chapter);
    cookie.put(value);*/
  this.setData("Chapter_DONE_"+Chapter, value);
}

Data.prototype.getCurrentLevel = function() {
	var ret = this.getData("currentLevel");
	if (ret != null) {
		return parseInt(ret);
	}
}

Data.prototype.setCurrentLevel = function(level) {
  this.setData("currentLevel", level);
}

Data.prototype.getCurrentChapter = function() {
	return this.getData("currentChapter");
}

Data.prototype.setCurrentChapter = function(chapter) {
  //Mojo.Log.error("setCurrentChapter("+chapter+")");
  this.setData("currentChapter", chapter);
}

Data.prototype.getMaxLevel = function() {
	var ret = this.getData("maxLevel");	
	if (ret != null) {
		return parseInt(ret);
	}
}

Data.prototype.setMaxLevel = function(level) {
  this.setData("maxLevel", level);
}

//***************************************

Data.prototype.getData = function(key) {
  return this.storage.get(key);
}

Data.prototype.setData = function(key, data) {
  this.storage.set(key,data);
}
