function Engine(gameService) {
  //Mojo.Log.error("--- new engine object created ---");

  this._oldTime = 0;
  this._newTime = 0;

  this.gravity = new Vector(0.0, 0.0);
  this.gameService = gameService;

  this.WIDTH = 320.0;
  this.HEIGHT = 480.0;
  this.numberVSectors = 10;
  this.numberHSectors = 12;
  this.widthOH = this.WIDTH / this.numberHSectors;
  this.heightOV = this.HEIGHT / this.numberVSectors;
  this.env = new Environment(0.0, 0.0, this.WIDTH, this.HEIGHT);
  this.soundSuccess = false;
  this.soundGameOver = false;
  this.hSectors = [1, 1];
  this.vSectors = [1, 1];
  this.counter = 0;
  this.imgFolder = "images";
}

Engine.prototype.initLevel = function() {
  //dbg.enter("engine.initLevel");

  var i, j, k;

  this.time = 0;
  this.oldTime = 0;

  this.sectors = [];

  // Create the fields sectors.
  var sWidth = this.WIDTH / this.numberHSectors;
  var sHeight = this.HEIGHT / this.numberVSectors;
  for (i = 0; i < this.numberHSectors; i++) {
		this.sectors.push([]);
		for (j = 0; j < this.numberVSectors; j++) {
	    this.sectors[i].push(new Sector(i * sWidth, j * sHeight, sWidth, sHeight));
		}
  }
  var cSectors;
  // Add the objects to their sectors.
  for (i = 0; i < this.aabbs.length; i++) {
		cSectors = this.getSectorsAabb(this.aabbs[i]);
		for (j = 0; j < cSectors['hSectors'].length; j++) {
	    for (k = 0; k < cSectors['vSectors'].length; k++) {
				this.sectors[cSectors['hSectors'][j]][cSectors['vSectors'][k]].aabbs.push(this.aabbs[i]);
	    }
		}
  }
  for (i = 0; i < this.holes.length; i++) {
		this.getSectorsCircle(new Vector(this.holes[i].x, this.holes[i].y), this.holes[i].r);
		for (j = 0; j < this.hSectors.length; j++) {
	    if (this.hSectors[j] == - 1) {
				continue;
	    }
	    for (k = 0; k < this.vSectors.length; k++) {
				if (this.vSectors[k] == - 1) {
					continue;
				}
				this.sectors[this.hSectors[j]][this.vSectors[k]].holes.push(this.holes[i]);
	    }
		}
  }

  
  for (i in this.interactives) {
		cSectors = this.interactives[i].getSectors(this.numberHSectors, this.numberVSectors, this.widthOH, this.heightOV);
		for (j = 0; j < cSectors['hSectors'].length; j++) {
	    for (k = 0; k < cSectors['vSectors'].length; k++) {
				this.sectors[cSectors['hSectors'][j]][cSectors['vSectors'][k]].interactives.push(this.interactives[i]);
	    }
		}
  }


  this.extraForce = [];
  for( var ba=0; ba<this.startPositions.length; ++ba ) {
		this.extraForce.push( new Vector(0.0, 0.0) );
  }
  //dbg.leave("engine.initLevel");
}

Engine.prototype.resetLevel = function() {
  //dbg.enter("engine.resetLevel");

  //this.dt = 0.05 / 3;
  switch (settings.get("physics")) {
  case "easy":
		this.dt = 0.05 / 3;
		break;
  case "medium":
		this.dt = 0.08 / 3;
		break;
  case "realistic":
		this.dt = 0.1 / 3;
		break;
  default:
		//Mojo.Log.error("--ERROR-- dt not set");
  }
  this.aabbs = [];
  this.holes = [];
  this.interactives = {};
  this.balls = [];
  this.startPositions = [];
  this.hSectors = [1, 1];
  this.vSectors = [1, 1];
  this.time = 0;
  this.oldTime = 0;
  this.soundSuccess = false;
  this.soundGameOver = false;
  this.counter = 0;

  //dbg.leave("engine.resetLevel");
}

Engine.prototype.restartLevel = function() {
  //dbg.enter("engine.restartLevel");
  var i;
  this.gravity.x = 0;
  this.gravity.y = 0;
  this.gameConcept.reset();

  for (i = 0; i < this.balls.length; i++) {
		document.getElementById("ball" + i).left = this.startPositions[i].x;
		document.getElementById("ball" + i).top = this.startPositions[i].y;
		this.balls[i].reset();

		this.balls[i].center.setXPosition(this.startPositions[i].x);
		this.balls[i].center.setYPosition(this.startPositions[i].y);
		this.balls[i].center.setXPrevious(this.startPositions[i].x);
		this.balls[i].center.setYPrevious(this.startPositions[i].y);
		document.getElementById("ball" + i).style.opacity = 1;
  }

  for (i in this.interactives) {
		this.interactives[i].setToDefault();
  }

  this.time = 0;
  this.oldTime = 0;
  this.gameService.sendEvent(document, "event_levelRestarted", this);

  //dbg.leave("engine.restartLevel");
}

Engine.prototype.update = function() {
  //dbg.enter("engine.update");

  var n = 3;
  var i, j, k, rep, ba;
  var a, al;
  var ball;

  //move all interactives:
  for (i in this.interactives) {
		this.interactives[i].move();
  }

  var ballsLength = this.balls.length;
  var hSectorsLength = this.hSectors.length;
  var vSectorsLength = this.vSectors.length;
  for (ba = 0; ba < ballsLength; ++ba) {
		ball = this.balls[ba];

		for (rep = 0; rep < n; ++rep) {
	    this.counter++;
	    if (ball.passive) {
				ball.passiveAnimation();
				continue;
	    }
	    ball.setForce(this.gravity);
	    ball.addForce(this.extraForce[ba]);
	    this.extraForce[ba].x = 0.0;
	    this.extraForce[ba].y = 0.0;
	    ball.move(this.dt);

	    // Ziel
	    if (ball.scHole(this.goal)) {
				this.ball = ball;
				this.gameConcept.addGoal();
				ball.setReachedGoal(this.goalPosition.x, this.goalPosition.y);
				//dbg.leave("engine.update");
				continue;
	    }
	    // Collide with other balls.
	    for (j = ba + 1; j < ballsLength; ++j) {
				ball.scBall(this.balls[j]);
	    }

	    // Spielfeld
	    ball.scEnv(this.env);

	    // Interactives
	    this.getSectorsCircle(ball.center.getPosition(), ball.r);
	    for (i = 0; i < hSectorsLength; ++i) {
				var hSectorI = this.hSectors[i];
				if (hSectorI < 0) {
					continue;
				}
				for (j = 0; j < vSectorsLength; ++j) {
					var vSectorJ = this.vSectors[j];
					if (vSectorJ < 0) {
						continue;
					}

					var sectorIJ = this.sectors[hSectorI][vSectorJ];
					
					// Wände
					a = sectorIJ.aabbs.length;
					for (k = 0; k < a; k++) {
						ball.scAabb(sectorIJ.aabbs[k], this.counter);
					}

					// Interactives
					a = sectorIJ.interactives;
					al = a.length;
					for (k = 0; k < al; k++) {
						a[k].scBall(ball, this.extraForce[ba], this.gameConcept, this.counter, ba);
					}

					// Löcher
					a = sectorIJ.holes;
					al = a.length;
					for (k = 0; k < al; k++) {
						if (ball.scHole(a[k])) {
							this.gameConcept.addFallen();
							ball.setFallenDown(
								a[k].x,
								a[k].y
							);
							//dbg.leave("engine.update");
							return;
						}
					}
				}
	    }
		}
  }

  //dbg.leave("engine.update");
}

Engine.prototype.draw = function() {
  //dbg.enter("engine.draw");
  var i;
  var ballsLength = this.balls.length;
  for (i = 0; i < ballsLength; i++) {
		this.balls[i].draw();
  }
  
  for (i in this.interactives) {
		//Mojo.Log.error(typeof(interactive));
		if (this.interactives[i].redraw) {
	    this.interactives[i].draw();
		}
  }
  
  //dbg.leave("engine.draw");
}

Engine.prototype.timeout = function(dt) {
  //dbg.enter("engine.timeout");
  var i;
  //if (this.oldTime == this.time && this.time > 0) {
  if (dt == 0 && this.time > 0) {
		//dbg.leave("engine.timeout");
		return;
  }

  if (this.gameConcept.checkGameOver()) {
		var finish = true;
		if (settings && settings.get("sound") == true && !this.soundGameOver) {
	    //this.soundGameOver = true;
	    //Mojo.Log.error("playing sound 'fail'");
	    this.gameService.playSound('fail');
		}
		for (i = 0; i < this.balls.length; i++) {
	    if (!this.balls[i].isFinished()) {
				finish = false;
	    }
		}
		if (finish) {
	    this.gameService.fallenDown();
	    //dbg.leave("engine.timeout");
	    return;
		}
  }
  if (this.gameConcept.checkSuccess()) {
		var finish = true;
		if (settings && settings.get("sound") == true && !this.soundSuccess) {
	    //this.soundSuccess = true;
	    //Mojo.Log.error("playing sound 'success'");
	    this.gameService.playSound('success');
		}
		for (i = 0; i < this.balls.length; i++) {
	    if (!this.balls[i].isFinished()) {
				finish = false;
	    }
		}
		if (finish) {
	    this.gameService.reachedGoal();
	    //dbg.leave("engine.timeout");
	    return;
		}
  }

  // *use real dt-timing for requestAnimationFrame*
  ///*
  this.oldTime = this.time;
  this.time += dt; //+= 20;
  this.dt = dt/1000; // new
  //*/
  /* or:
     this.oldTime = this.time;
     this.time += 20;
  */

  this.update();
  this.draw();

  //dbg.leave("engine.timeout");

}

Engine.prototype.getSectorsCircle = function(cPos, radius) {
  //dbg.enter("engine.getSectorsCircle");

  var i = Math.floor(cPos.x / this.widthOH);
  var j = Math.floor(cPos.y / this.heightOV);
  this.hSectors[0] = i;
  this.hSectors[1] = - 1;
  this.vSectors[0] = j;
  this.vSectors[1] = - 1;
  xMod = cPos.x % (this.widthOH);
  if (xMod < radius) {
		if (i - 1 >= 0) {
	    this.hSectors[1] = i - 1;
		}
  } else if (xMod > (this.widthOH - radius)) {
		if (i + 1 < this.numberHSectors) {
	    this.hSectors[1] = i + 1;
		}
  }
  yMod = cPos.y % this.heightOV;
  if (yMod < radius) {
		if (j - 1 >= 0) {
	    this.vSectors[1] = j - 1;
		}
  } else if (yMod > (this.heightOV - radius)) {
		if (j + 1 < this.numberVSectors) {
	    this.vSectors[1] = j + 1;
		}
  }
  //dbg.leave("engine.getSectorsCircle");
}

Engine.prototype.getSectorsAabb = function(aabb) {
  //dbg.enter("engine.getSectorsAabb");

  var it;
  var result = {};
  result['hSectors'] = [];
  result['vSectors'] = [];

  var i = Math.floor(aabb.x * this.numberHSectors / this.WIDTH);
  result['hSectors'].push(i);
  var cmp = this.WIDTH / this.numberHSectors;
  for (it = i + 1; it < this.numberHSectors; it++) {
		if ((aabb.x + aabb.width) > it*cmp) {
 	    result['hSectors'].push(it);
 		} else {
 	    break;
 		}
  }
  
  var j = Math.floor(aabb.y * this.numberVSectors / this.HEIGHT);
  result['vSectors'].push(j);
  cmp =  this.HEIGHT / this.numberVSectors;
  for (it = j + 1; it < this.numberVSectors; it++) {
		if ((aabb.y + aabb.height) > it*cmp) {
 	    result['vSectors'].push(it);
 		} else {	
	    break;
		}
  }

  //dbg.leave("engine.getSectorsAabb");
  return result;
}

Engine.prototype.loadLevel = function(chapter, level, ignoreLevels) {
  //console.debug("engine.js: enter -> loadLevel()");

  var file = appPath + "resources/levels/" + chapter + "/" + level + ".json";
  //Mojo.Log.error("loading level: "+file);
  Zepto.ajax({
		type: 'get',
		dataType: 'json',
		url: file,
		success: function(resp) {		    
	    this.resetLevel();
	    this.parseLevel(resp);
	    this.initLevel();
	    this.drawLevel();
	    this.draw(); // needed so gateholes etc. are in right state and dont "blink"
	    this.gameService.sendEvent(document, "event_levelLoaded", this);
		}.bind(this),
		error: function(resp) {
	    console.error("engine.js: error -> loadLevel() -> json not loaded");
	    //Mojo.Log.error("not found: " + file);
	    //Mojo.Log.error(transport.responseText);
		}
  });

  //dbg.leave("engine.loadLevel");
}

Engine.prototype.parseLevel = function(resp) {
  //console.debug("engine.js: enter -> parseLevel()");

  // load level data
  var i;
  if (typeof(resp.game_concept) !== 'undefined') {
		this.gameConcept = new GameConcept(resp.game_concept[0], resp.game_concept[1]);
  } else {
		this.gameConcept = new GameConcept("standard", new Array(1, 1));
  }
  for (i = 0; i < resp.aabbs.length; i++) {
		this.aabbs.push(new Aabb(resp.aabbs[i][0], resp.aabbs[i][1], resp.aabbs[i][2], resp.aabbs[i][3], resp.aabbs[i][4], resp.aabbs[i][5]));
  }
  for (i = 0; i < resp.holes.length; ++i) {
		this.holes.push(new Hole(i, resp.holes[i][0], resp.holes[i][1], resp.holes[i][2]));
  }
  if (typeof(resp.interactives) !== 'undefined') {
		for (i in resp.interactives) {
	    this.interactives[resp.interactives[i][1]] = createInteractive(resp.interactives[i], resp.start.length);
		}
  }
  // Register Signals.
  if (typeof(resp.signalBindings) !== 'undefined') {
		for (i = 0; i < resp.signalBindings.length; i++) {
	    var binding = resp.signalBindings[i];
	    //Mojo.Log.error( "bindings: "+binding[0]+" : "+binding[1]+" : "+binding[2]+" : "+binding[3] );
	    this.interactives[binding[0]].registerSignal(binding[1], this.interactives[binding[2]][binding[3]].bind(this.interactives[binding[2]]), binding[4]);
		}
  }
  // Register Conditions.
  if (typeof(resp.conditions) !== 'undefined') {
		for (i = 0; i < resp.conditions.length; i++) {
	    var condition = resp.conditions[i];
	    var conditionFuncs = [];
	    for (j = 0; j < condition[3].length; j++) {
				conditionFuncs.push(this.interactives[condition[3][j][0]][condition[3][j][1]].bind(this.interactives[condition[3][j][0]]));
	    }
	    this.interactives[condition[0]].registerCondition(condition[1], this.interactives[condition[0]][condition[2]].bind(this.interactives[condition[0]]), conditionFuncs);
		}
  }

  // Register Quick Conditions.
  if (typeof(resp.quickConditions) !== 'undefined') {
		for( i = 0; i < resp.quickConditions.length; i++) {
	    var condition = resp.quickConditions[i];
	    this.interactives[condition[0]].registerQuickCondition(condition[1], this.interactives[condition[0]][condition[2]].bind(this.interactives[condition[0]]));
		}
  } 

  this.goalPosition = new Vector(resp.goal[0], resp.goal[1]);
  for (i = 0; i < resp.start.length; i++) {
		this.startPositions.push(new Vector(resp.start[i][0], resp.start[i][1]));
  }

  for (i = 0; i < this.startPositions.length; i++) {
		this.balls.push(new Circle(this.startPositions[i].x, this.startPositions[i].y, 10.0, 0.01, "ball" + i));
  }

  this.goal = new Hole("goal", this.goalPosition.x, this.goalPosition.y, 10);
  this.goal.setGoal(true);

  this.imgs = resp.imgs;

  //dbg.leave("engine.parseLevel");
}

Engine.prototype.drawLevel = function() {
  //console.debug("engine.js: enter -> drawLevel()");

  var i, m, tmp;
  //Mojo.Log.error($("content").childNodes.length);
  // clear old level
  if (!this.zeroChildren) {
		this.zeroChildren = document.getElementById("content").childNodes.length;
		//Mojo.Log.error("zeroChildren set to " + this.zeroChildren);
  }

  // used for the preview function in level selector
  if (this.zeroChildren > 10) {
		return;
  }

  tmp = document.getElementById("content");
  while (tmp.childNodes.length > this.zeroChildren) {
		tmp.removeChild(tmp.lastChild);
  }

  for (i = 0; i < this.balls.length; i++) {
		tmp = document.createElement("img");
		tmp.src = this.imgFolder+"/kugel.png";
		tmp.id = "ball" + i;
		tmp.style.position = "absolute";
		tmp.style.top = (this.startPositions[i].y-this.balls[i].r) + "px";
		tmp.style.left = (this.startPositions[i].x-this.balls[i].r) + "px";
		tmp.style.width = "24px";
		tmp.style.height = "24px";
		tmp.style.zIndex = 3;
		document.getElementById("content").appendChild(tmp);
		this.balls[i].image = document.getElementById("ball"+i);
  }

  for (i = 0; i < this.holes.length; i++) {
		tmp = document.createElement("img");
		tmp.src = this.imgFolder+"/hole.png";
		tmp.id = "ho_" + i;
		tmp.style.position = "absolute";
		tmp.style.top = (this.holes[i].y - this.holes[i].r - 2) + "px";
		tmp.style.left = (this.holes[i].x - this.holes[i].r - 2) + "px";
		tmp.style.width = (2 * this.holes[i].r + 3) + "px";
		tmp.style.height = (2 * this.holes[i].r + 3) + "px";
		tmp.style.zIndex = 1;
		id = document.createAttribute("id");
		id.nodeValue = "ho_" + i;
		tmp.setAttributeNode(id);
		document.getElementById("content").appendChild(tmp);
  }

  // draw all images
  for (var img in this.imgs) {
		var imgData = this.imgs[img];
		for (i = 0; i < imgData.length; i++) {
	    tmp = document.createElement("div");
	    tmp.style.position = "absolute";
	    if( img == "d" ) {
				tmp.style.backgroundImage = "url('"+this.imgFolder+"/" + img + ".jpg')";
				var string = (-imgData[i][0]-10)+'px '+(-imgData[i][1])+'px';
				tmp.style.backgroundPosition = string;
	    } else {
				tmp.style.backgroundImage = "url('"+this.imgFolder+"/" + img + ".png')";
			}
	    tmp.style.left = imgData[i][0] + "px";
	    tmp.style.top = imgData[i][1] + "px";
	    tmp.style.width = imgData[i][2] + "px";
	    tmp.style.height = imgData[i][3] + "px";
	    tmp.style.zIndex = imgData[i][4];
	    //FIXME: not needed later, as soon as all levels have been reread by LD
	    if (typeof(imgData[i][5]) !== 'undefined' && imgData[i][5] != "none") {
				id = document.createAttribute("id");
				id.nodeValue = imgData[i][5];
				tmp.setAttributeNode(id);
	    }
	    /*
 	      if( typeof(imgData[i][6]) !== 'u
	      ndefined' ) {
	      tmp.style.visibility = imgData[i][6];
	      }
	    */
	    document.getElementById("content").appendChild(tmp);
		}
  }

  // goal		
  tmp = document.createElement("img");
  tmp.src = this.imgFolder+"/goal.png";
  tmp.style.position = "absolute";
  tmp.style.top = (this.goalPosition.y - 12) + "px";
  tmp.style.left = (this.goalPosition.x - 12) + "px";
  tmp.style.width = "23px";
  tmp.style.height = "23px";
  tmp.style.zIndex = "1";
  document.getElementById("content").appendChild(tmp);

  //dbg.leave("engine.drawLevel");
}

function createInteractive(interactive, ballCount) {
  var object = null;
  //  Mojo.Log.error("creating interactive "+interactive[0]);
  switch (interactive[0]) {
  case "magnet":
		object = new Magnet(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5], interactive[6], interactive[7]);
		break;
  case "switch":
		object = new Switch(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5], interactive[6], interactive[7], ballCount);
		break;
  case "round":
		object = new Round(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5]);
		break;
  case "bars":
		object = new Bars(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5], interactive[6], interactive[7]);
		break;
  case "moving_hole":
		object = new MovingHole(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5], interactive[6], interactive[7], interactive[8]);
		break;
  case "gate_hole":
		object = new GateHole(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5]);
		break;
  case "pipe":
		object = new Pipe(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5], interactive[6], interactive[7], interactive[8]);
		break;
  case "laser":
		object = new Laser(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5], interactive[6]);
		break;
  case "laser_gen":
		object = new LaserGen(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5], interactive[6], interactive[7]);
		break;
  case "bumper":
		object = new Bumper(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5]);
		break;
  case "corner":
		object = new Corner(interactive[1], interactive[2], interactive[3], interactive[4], interactive[5]);
		break;
  }
  return object;
}

