function Environment( x, y, width, height ) {
  this.left = x;
  this.right = x + width;
  this.top = y;
  this.bottom = y + height;
  this.width = width;
  this.height = height;
  this.r = new Vector(0.0, 0.0);
}

Environment.prototype.collision = function(currentPosition) {
  var collide = false;
  var i;

  if(currentPosition.x < this.left) {
    currentPosition.x = this.left;
    collide = true;
  } else if( currentPosition.x > this.right) {
    currentPosition.x = this.right;
    collide = true;
  }
  if( currentPosition.y < this.top ) {
    currentPosition.y = this.top;
    collide = true;
  } else if( curPos.y > this.bottom ) {
    currentPosition.y = this.bottom;
    collide = true;
  }
  return collide;
}

Environment.prototype.testCollision = function(position) {
  var collide = false;
  var edge = null;
  var ePoint = null;
  var sVector = new Vector(0.0, 0.0);
  if( position.x < this.left ) {
    sVector.x = this.left - position.x;
    collide = true;
    ePoint = new Vector( this.left, 0.0 );
    edge = new Vector( 0.0, 1.0 );
  } else if( position.x > this.right ) {
    sVector.x = this.right - position.x;
    collide = true;
    ePoint = new Vector( this.right, 0.0 );
    edge = new Vector( 0.0, 1.0 );
  }
  if( position.y < this.top ) {
    sVector.y = this.top - position.y;
    collide = true;
    ePoint = new Vector( 0.0, this.top );
    edge = new Vector( 1.0, 0.0 );
  } else if( position.y > this.bottom ) {
    sVector.y = this.bottom - position.y;
    collide = true;
    ePoint = new Vector( 0.0, this.bottom );
    edge = new Vector( 1.0, 0.0 );
  }
  var result = {};
  result['collide'] = collide;
  result['sVector'] = sVector;
  result['edge'] = edge;
  result['ePoint'] = ePoint;
  return result;
}
