function getCircleSectors(cPos, radius, numberHSectors, numberVSectors, widthOH, heightOV) {
	result = {};
  result.hSectors = [];
  result.vSectors = [];

	var i = Math.floor(cPos.x/widthOH);
	var j = Math.floor(cPos.y/heightOV);
	result.hSectors.push(i);
	result.vSectors.push(j);
	xMod = cPos.x%(widthOH);
	if( xMod < radius ) {
		if( i-1 >= 0 ) {
			result.hSectors.push( i-1 );
		}
	} else if( xMod > (widthOH-radius)) {
		if( i+1 < numberHSectors ) {
			result.hSectors.push(i+1);
		}
	}
	yMod = cPos.y%heightOV;
	if( yMod < radius ) {
		if( j-1 >= 0 ) {
			result.vSectors.push( j-1 );
		}
	} else if( yMod > (heightOV-radius)) {
		if( j+1 < numberVSectors ) {
			result.vSectors.push(j+1);
		}
	}
  return result;
}

function getAabbSectors(aabb, numberHSectors, numberVSectors, widthOH, heightOV) {
	var it;
	var result = {};
	result['hSectors'] = [];
	result['vSectors'] = [];
  
	var i = Math.floor(aabb.x/widthOH);
  if( i >= 0 ) {
	  result['hSectors'].push(i);
  }
	for( it = i+1; it < numberHSectors; it++ ) {
		if( (aabb.x+aabb.width) > (it*widthOH)) {
      if( it < 0 || it >= numberHSectors ) {
        continue;
      }
			result['hSectors'].push(it);
		} else {
			break;
		}
	}

	var j = Math.floor(aabb.y/heightOV);
  if( j >= 0 ) {
	  result['vSectors'].push(j);
  }
	for( it = j+1; it < numberVSectors; it++ ) {
		if( (aabb.y+aabb.height) > (it*heightOV)) {
      if( it < 0 || it >= numberVSectors ) {
        continue;
      }
			result['vSectors'].push(it);
		} else {
			break;
		}
	} 
  
	return result;
}
