function Laser( id, x, y, direction, l, on ) {
  Interactive.call(this, id);
  this.position = new Vector(x, y);
  this.def = {};
  this.x = x;
  this.y = y;
  this.direction = direction;
  this.l = l;
  this.def.on = on;
  this.setToDefault();
}

Laser.prototype = new Interactive();
Laser.prototype.constructor = Laser;

Laser.prototype.setToDefault = function() {
  this.on = this.def.on;
  this.redraw = true;
}

Laser.prototype.getPosition = function() {
  return this.position;
}

Laser.prototype.switchOff = function() {
  if( !this.on ) {
    return;
  }
  this.on = false;
  this.redraw = true;
  //this.sendSignal( "switched_off" );
}

Laser.prototype.switchOn = function() {
  if( this.on ) {
    return;
  }
  this.on = true;
  this.redraw = true;
}

Laser.prototype.toggle = function() {
  this.on = !this.on;
  //Mojo.Log.error( "toggled Laser "+this.id+" to:"+this.on);
  this.redraw = true;
}

Laser.prototype.scBall = function( ball, extraForce, gameConcept, counter ) {
  if( !this.checkCounter(counter) ) {
    return;
  }
  if( !this.on ) {
    return;
  }
  // Horizontal laser
  var bPos = ball.getPosition();
  var ball_r = ball.r - 2;

	if( this.direction == 0 ) {
    if( bPos.x < this.x || bPos.x > this.x+this.l ) {
      return;
    }
    
    if( bPos.y-ball_r <= this.y+6 && bPos.y+ball_r >= this.y ) {
      this.sendSignal( "switched_off" );
      this.switchOff();
    }
  } else if( this.direction == 1 ) {
    if( bPos.y < this.y || bPos.y > this.y+this.l ) {
      return;
    }
    
    if( bPos.x-ball_r <= this.x && bPos.x+ball_r >= this.x-4 ) {
      this.sendSignal( "switched_off" );
      this.switchOff();
    }
  }
  // so that it doesnt spin endlessly when ball is "on" bar
  // NEEDS FIX B: do this!!!
  //if( ( not collide or this.strength > 0 ) and this.on and force != None ):
  //  extraForce.add( force )
}

Laser.prototype.draw = function() {
  if( !this.redraw ) {
    return;
  }
  this.redraw = false;
  if( typeof(this.image) === 'undefined' || this.image == null ) {
    this.image = document.getElementById(this.id+"_on");
  }
  //Mojo.Log.error( "Laser: "+this.id+" redraw" );
  //alert("redraw");
  if( this.on ) {
    this.image.style.visibility = 'visible';
  } else {
    this.image.style.visibility = 'hidden';
  }
}

Laser.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV)  {
  if( this.direction == 0 ) {
    var aabb = new Aabb( this.x, this.y-3, this.l, 6 );
  } else if( this.direction == 1 ) {
    var aabb = new Aabb( this.x-3, this.y, 6, this.l );
  }
  return getAabbSectors(aabb, numberHSectors, numberVSectors, widthOH, heightOV);
}
