function Magnet( id, x, y, r, outerR, strength, on ) {
  Interactive.call(this, id);
  this.round = new Round( "id", x, y, r );
  this.position = new Vector(x, y);
  this.def = {};
  this.def.x = x;
  this.def.y = y;
  this.def.r = r;
  this.def.oR = outerR;
  this.def.strength = strength;
  this.def.on = on;
  this.setToDefault();
}

Magnet.prototype = new Interactive();
Magnet.prototype.constructor = Magnet;

Magnet.prototype.setToDefault = function() {
  this.round.x = this.def.x;
  this.round.y = this.def.y;
  this.round.r = this.def.r;
  this.position.x = this.def.x;
  this.position.y = this.def.y;
  this.x = this.def.x;
  this.y = this.def.y;
  this.r = this.def.r;
  this.oR = this.def.oR;
  this.strength = this.def.strength;
  this.on = this.def.on;
  this.redraw = true;
}

Magnet.prototype.getPosition = function() {
  return this.position;
}

Magnet.prototype.switchOff = function() {
  this.on = false;
  this.redraw = true;
  //this.sendSignal( "switched_off" );
}

Magnet.prototype.switchOn = function() {
  this.on = true;
  this.redraw = true;
}

Magnet.prototype.toggle = function() {
  this.on = !this.on;
  //Mojo.Log.error( "toggled magnet "+this.id+" to:"+this.on);
  this.redraw = true;
}

Magnet.prototype.scBall = function( ball, extraForce, gameConcept, counter ) {
  if( !this.checkCounter(counter) ) {
    return;
  }
  force = null;
  if( this.on ) {
    //Test if in repel region
    result = circleCircle( this, this.oR, ball, ball.r );
    //If in circle then repell.
    if( result['collide'] ) {
      mirrorAxis = result['edge'];
      mirrorAxis.normal();
      mirrorAxis.scale( -1/result['dist']*this.strength );
      force = mirrorAxis;
    }
  }

  // Test for actual collision with bar.
  this.round.scBall(ball);

  if( force != null ) {
    extraForce.add(force);
  }
  
  // so that it doesnt spin endlessly when ball is "on" bar
  // NEEDS FIX B: do this!!!
  //if( ( not collide or this.strength > 0 ) and this.on and force != None ):
  //  extraForce.add( force )
}

Magnet.prototype.draw = function() {
  this.redraw = false;
  if( typeof(this.imageBottom) === 'undefined' || this.imageBottom == null ) {
    this.imageBottom = document.getElementById(this.id+"_bottom");
  }
  if( typeof(this.imageTopOff) === 'undefined' || this.imageTopOff == null ) {
    this.imageTopOff = document.getElementById(this.id+"_top_off");
  }
  if( typeof(this.imageTopOn) === 'undefined' || this.imageTopOn == null ) {
    this.imageTopOn = document.getElementById(this.id+"_top_on");
  }
  //Mojo.Log.error( "magnet: "+this.id+" redraw" );
  if( this.on ) {
    this.imageTopOn.style.visibility = 'visible';
    this.imageTopOff.style.visibility = 'hidden';
  } else {
    this.imageTopOn.style.visibility = 'hidden';
    this.imageTopOff.style.visibility = 'visible';
  }
}

Magnet.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV)  {
  var aabb = new Aabb( this.x-this.oR, this.y-this.oR, this.oR*2, this.oR*2 );
  return getAabbSectors(aabb, numberHSectors, numberVSectors, widthOH, heightOV);
}
