function Pipe( id, x, y, xTarget, yTarget, xTargetPrev, yTargetPrev, direction ) {
  this.id = id;
  this.x = x;
  this.y = y;
  this.direction = direction;
  this.width = 25;
  this.height = 23;
  
  this.position = new Vector( x, y );
  
  this.outerAabbs = [];
  switch( this.direction ) {
    case 'down':
      this.height = 23;
      this.innerAabb = new Aabb(this.x, this.y, this.width, this.height);
      this.outerAabbs.push( new Aabb(this.x-20, this.y, 21, this.height));
      this.outerAabbs.push( new Aabb(this.x+this.width-2, this.y, 20, this.height));
      break;
    case 'up':
      this.height = 23;
      this.innerAabb = new Aabb(this.x, this.y+2, this.width, this.height-2);
      this.outerAabbs.push( new Aabb(this.x-20, this.y+2, 21, this.height-2));
      this.outerAabbs.push( new Aabb(this.x+this.width-2, this.y+2, 20, this.height-2));
      break;
    case 'right':
      this.height = 25;
      this.width = 23;
      this.innerAabb = new Aabb(this.x, this.y, this.width, this.height);
      this.outerAabbs.push( new Aabb(this.x, this.y-20, this.width, 21));
      this.outerAabbs.push( new Aabb(this.x, this.y+this.height-2, this.width, 20));
      break;
    case 'left':
      this.height = 25;
      this.width = 23;
      this.innerAabb = new Aabb(this.x+2, this.y, this.width-2, this.height);
      this.outerAabbs.push( new Aabb(this.x+2, this.y-20, this.width-2, 21));
      this.outerAabbs.push( new Aabb(this.x+2, this.y+this.height-2, this.width-2, 20));
      break;
  }
  
  this.target = new Vector( xTarget, yTarget );
  this.targetPrev = new Vector( xTargetPrev, yTargetPrev );
  this.redraw = false;
}

Pipe.prototype = new Interactive();
Pipe.prototype.constructor = Pipe;

Pipe.prototype.setToDefault = function() {
  return;
}

Pipe.prototype.getPosition = function() {
  return this.position;
}

Pipe.prototype.centered = function(bC) {
  switch( this.direction ) {
    case 'up':
    case 'down':
      return bC.x >= this.x && bC.x <= this.x+this.width;
      break;
    case 'left':
    case 'right':
      return bC.y >= this.y && bC.y <= this.y+this.height;
      break;
  }
}

Pipe.prototype.scBall = function(ball, extraForce, gameConcept, counter) {
  if( !this.checkCounter(counter) ) {
    return;
  }
  //Test for collision
  var bC = ball.center.getPosition();
  if( this.centered(bC) ) {
    //Mojo.Log.error( "ball centered by: "+this.id);
    // Check wether ball needs to be beamed.
    if( (this.direction == 'down' && Math.abs(bC.y - this.y ) < 14) ||
        (this.direction == 'up' && Math.abs(bC.y - this.y - this.height) < 14) ||
        (this.direction == 'left' && Math.abs(bC.x - this.x - this.width) < 14) ||
        (this.direction == 'right' && Math.abs(bC.x - this.x) < 13 ) ) {
      if( ball.isPipeActive() ) {
        var yDist = Math.abs(ball.center.getPosition().y-ball.center.getPreviousPosition().y);
        //Mojo.Log.error( "setBall to: "+this.target.x+" : "+this.target.y);
        ball.center.setPosition( this.target );
        ball.center.setPreviousPosition( this.targetPrev );
        ball.setPipePassive();
        return;
      }
    } else if( ball.isPipePassive() ) {
      switch( this.direction ) {
        case 'up':
          if( bC.y <= this.y ) {
            ball.setPipeActive();
          }
          break;
        case 'down':
          if( bC.y >= this.y+this.height ) {
            ball.setPipeActive();
          }
          break;
        case 'left':
          if( bC.x <= this.x ) {
            ball.setPipeActive();
          }
          break;
        case 'right':
          if( bC.x >= this.x+this.width ) {
            ball.setPipeActive();
          }
          break;
      }
    }
    var i;
    for( i=0; i<this.outerAabbs.length; i++ ) {
      ball.scAabb(this.outerAabbs[i], counter);
    }
  } else {
    ball.scAabb(this.innerAabb, counter);
  }
}

Pipe.prototype.draw = function() {
  return
}

Pipe.prototype.getSectors = function(numberHSectors, numberVSectors, widthOH, heightOV)  {
  return getAabbSectors(this.innerAabb, numberHSectors, numberVSectors, widthOH, heightOV);
}
