function PointMass(cx, cy, mass) {
  this.cur = new Vector(cx, cy);
  this.prev = new Vector(cx, cy);
  this.mass = mass;
  this.force = new Vector(0.0, 0.0);
  this.result = new Vector(0.0, 0.0);
  this.friction = 0.01;
}

PointMass.prototype.getXPosition = function() {
  return this.cur.x;
}

PointMass.prototype.getYPosition = function() {
  return this.cur.y;
}

PointMass.prototype.setXPosition = function(x) {
  this.cur.x = x;
}

PointMass.prototype.setYPosition = function(y) {
  this.cur.y = y;
}

PointMass.prototype.getPosition = function() {
  return this.cur;
}

PointMass.prototype.setPosition = function(vector) {
  this.cur.x = vector.x;
  this.cur.y = vector.y;
}

PointMass.prototype.setPreviousPosition = function(vector) {
  this.prev.x = vector.x;
  this.prev.y = vector.y;
}

PointMass.prototype.getXPrevious = function() {
  return this.prev.x;
}

PointMass.prototype.getYPrevious = function() {
  return this.prev.y;
}

PointMass.prototype.setXPrevious = function(x) {
  this.prev.x = x;
}

PointMass.prototype.setYPrevious = function(y) {
  this.prev.y = y;
}

PointMass.prototype.setPrevious = function(vector) {
  this.prev.x = vector.x;
  this.prev.y = vector.y;
}

PointMass.prototype.getPreviousPosition = function() {
  return this.prev;
}

PointMass.prototype.addXPosition = function(dx) {
  this.cur.addX(dx);
}

PointMass.prototype.addYPosition = function(dy) {
  this.cur.addY(dy);
}

PointMass.prototype.addPosition = function(vector) {
  this.cur.add(vector);
}

PointMass.prototype.setForce = function(force) {
  this.force.set(force);
}

PointMass.prototype.addForce = function(force) {
  this.force.add(force);
}

PointMass.prototype.getMass = function() {
  return this.mass;
}

PointMass.prototype.setMass = function(mass) {
  this.mass = mass;
}

PointMass.prototype.move = function(deltaTime) {
  var deltaTimeSquared = deltaTime*deltaTime;

  var acceleration = this.force.x / this.mass;
  var currentCoordinate = this.cur.x;
  var newCoordinate = (2.0-this.friction)*currentCoordinate
                  -(1.0-this.friction)*this.prev.x
                  +acceleration*deltaTimeSquared;
  this.prev.x = currentCoordinate;
  this.cur.x = newCoordinate;

  acceleration = this.force.y / this.mass;
  currentCoordinate = this.cur.y;
  newCoordinate = (2.0-this.friction)*currentCoordinate
                  -(1.0-this.friction)*this.prev.y
                  +acceleration*deltaTimeSquared;
  this.prev.y = currentCoordinate;
  this.cur.y = newCoordinate;
}

PointMass.prototype.setFriction = function(friction) {
  this.friction = friction;
}

PointMass.prototype.getVelocity = function() {
  var xDist = this.cur.x - this.prev.x;
  var yDist = this.cur.y - this.prev.y;
  return xDist*xDist + yDist*yDist;
}

PointMass.prototype.getVelocityVector = function() {
  return new Vector(this.prev.x-this.cur.x, this.prev.y-this.cur.y);
}
