//
//	level_service.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function LevelService() {
	this.storage_id = "level_scores";
	this.storage = new Storage(this.storage_id);

	this.init();
}


LevelService.prototype.init = function() {
	this.highscores = this.getStorage("highscores");

	if (this.highscores == null) {
		this.highscores = {};
		this.setStorage("highscores", this.highscores);
	}
}

LevelService.prototype.reset = function() {
	this.highscores = {};
	this.setStorage("highscores", this.highscores);
}

LevelService.prototype.getHighscore = function(chapter, level, difficulty_str, callback) {
	this.highscores = this.getStorage("highscores");
	var level = level.toString();

	var data = this.highscores[chapter+"_"+level];

	var difficulty = "medium";
	switch (difficulty_str) {
	case "easy":
		difficulty = 1; //$L("easy");
		break;
	case "medium":
		difficulty = 2; //$L("medium");
		break;
	case "realistic":
		difficulty = 3; //$L("realistic");
		break;
	}

	var result = [];
	if (typeof data != 'undefined') {
		//get highscore at current difficulty level
		if (typeof data[difficulty] != 'undefined' && data[difficulty] != null) {
			result["time"] = data[difficulty]["time"] / 100;	
		}
	}

	//synchronous
	return result;
}


LevelService.prototype.getHighscores = function(chapter, level, callback) {
	this.highscores = this.getStorage("highscores");
	var level = level.toString();

	var data = this.highscores[chapter+"_"+level];
	
	var result = false;
	if (typeof data != 'undefined') {
		result = [];
		var row = [];

		// get all difficulty level highscores
		for (var difficulty=0; difficulty<data.length; ++difficulty) {
			if (typeof data[difficulty] == "undefined" || data[difficulty] == null) {
				continue;
			}
			row = [];
			row["time"] = data[difficulty]["time"] / 100;
			switch (difficulty) {
			case 1:
				row["difficulty"] = "easy"; //$L("easy");
				break;
			case 2:
				row["difficulty"] = "medium"; //$L("medium");
				break;
			case 3:
				row["difficulty"] = "realistic"; //$L("realistic");
				break;
			}
			result[result.length] = row;
		}
	}

	//synchronous
	return result;
}


LevelService.prototype.addHighscore = function(chapter, level, physics, time, tries) {
	var level = level.toString();

	var difficulty;
	switch (physics) {
	case "easy":
		difficulty = 1;
		break;
	case "medium":
		difficulty = 2;
		break;
	case "realistic":
		difficulty = 3;
		break;
	}
	/*this.query("REPLACE INTO `highscores` (chapter, level, difficulty, time, tries) VALUES (?, ?, ?, ?, ?)",
		[(chapter), parseInt(level), parseInt(difficulty), parseInt(100*time), parseInt(tries)]);*/
	
	if (typeof this.highscores[chapter+"_"+level] == 'undefined') {
		this.highscores[chapter+"_"+level] = [] ;
		this.highscores[chapter+"_"+level][difficulty] = {};
	}

	this.highscores[chapter+"_"+level][difficulty]["time"] = parseInt(100*time);
	this.highscores[chapter+"_"+level][difficulty]["tries"] = parseInt(tries);
	
	this.highscores = this.setStorage("highscores", this.highscores);	
}

//*******************************

LevelService.prototype.getStorage = function(key) {
	return this.storage.get(key);
}

LevelService.prototype.setStorage = function(key, data) {
	this.storage.set(key, data);
}
