
//local DOM storage (see: https://developer.mozilla.org/en-US/docs/DOM/Storage)

function Storage(storage_id) {
	/*try {
    'localStorage' in window && window['localStorage'] !== null;
  } catch (e) {
    return false;
  }*/

	var storage_list_item = localStorage.getItem("storage_list");
	if (storage_list_item != null && storage_list_item != typeof(undefined)) { 
		this.storage_list = JSON.parse(storage_list_item);
		//look for storage id in storage list, init storage if neccessary
		if (this.storage_list.indexOf(storage_id) == -1) {
			this.init(storage_id);
		}
	} else {
		//init storage list if non-existent
		this.storage_list = new Array();
		this.init(storage_id);
	}
	localStorage.setItem("storage_list", JSON.stringify(this.storage_list));
	
	this.separator = '#';
	this.storage_id = storage_id;

	/*
	if (this.get(storage_id) == null) {
		this.init(storage_id);
	}
	*/
	
}

Storage.prototype.init = function(storage_id) {
	//create placeholder object in localStorage
	//localStorage.setItem(storage_id, this.separator);
	this.storage_list.push(storage_id);
}


Storage.prototype.set = function(key, data) {
	localStorage.setItem(this.storage_id+this.separator+key,  JSON.stringify(data));
}

Storage.prototype.get = function(key) {
	item = localStorage.getItem(this.storage_id+this.separator+key);
	if (item == null || item == typeof(undefined)) { 
		return null;
	}
	return JSON.parse(item);
}

Storage.prototype.remove = function(key) {
	localStorage.removeItem(this.storage_id+this.separator+key);
}

Storage.prototype.print = function() {
	for(var i in localStorage) {
		Zepto('#debug').append(""+i +": "+ localStorage[i]+"<br/>");
	}
}

Storage.prototype.clear = function() {
	for (var key in localStorage) {
		if (key.indexOf(this.storage_id+this.separator) > -1) {
			localStorage.removeItem(key);
		}
	}
}

Storage.prototype.clearAll = function() {
	localStorage.clear();
}

