var BatterySvg = (function(){
   /*Objeto Raphael que contiene el grafico de la bateria*/
    var _raphaelBattery = {},
    _marksRatio = 120,
    _param = {stroke: "#fff", "stroke-width": 30},
    _hash = document.location.hash,
    _marksAttr = {fill: _hash || "#444", stroke: "none"},
    _colorStatus = {good: "#bbf263", less: "#f4f263", bad: "#ee655f"},
    _batteryShape = {},
    _chargingShape = {},
    _middleShape,
    _texto = null,
    _init = true;
    /**
      Actualiza el valor de la bateria
    */
    function updateVal(value, total, R, hand, id) {
        if (_init) {
          hand.animate({arc: [value, total, R]}, 450, ">");
        } else {
            if (!value || value == total) {
              value = total;
              hand.animate({arc: [value, total, R]}, 375, "bounce", function () {
                if (id != 2) {
                  hand.attr({arc: [0, total, R]});
                }
              });
            } else {
                hand.animate({arc: [value, total, R]}, 375, "elastic");
              }
          }
    }
    /**
      Construye las marcas sobre las que
      se pinta el estado de la bateria
    */

    function drawMarks(R, total) {
        var color = "hsb(".concat(Math.round(R) / 75, ", 1, .75)"),
            out = _raphaelBattery.set();
              
        for (var value = 0; value < total; value++) {
          var alpha = 360 / total * value,
          a = (90 - alpha) * Math.PI / 180,
          x = 150 + R * Math.cos(a),
          y = 150 - R * Math.sin(a);
          out.push(_raphaelBattery.circle(x, y, 2).attr(_marksAttr));
        }
        return out;
    }

    function initShapes(){
      //Inicializando las marcas 
      drawMarks(_marksRatio, 30);
      //Inicializando la forma de la bateria
      _batteryShape = _raphaelBattery.path().attr(_param).attr({arc: [0, 30, _marksRatio]});
      _batteryShape.id = 2;
      //          
      _marksRatio -= 20;
      

      _chargingShape = _raphaelBattery.path().attr(_param).attr({arc: [0, 6, _marksRatio]});
      _chargingShape.id = 4;
    }

    return { 
        init: function(raphael){
                _raphaelBattery = raphael;

                _raphaelBattery.customAttributes.arc = function (value, total, R) {
                    var alpha = 360 / total * value,
                    a = (90 - alpha) * Math.PI / 180,
                    x = 150 + R * Math.cos(a),
                    y = 150 - R * Math.sin(a),
                    color = _colorStatus.good,
                    path;
                    if (total == value) {
                      path = [["M", 150, 150 - R], ["A", R, R, 0, 1, 1, 149.99, 150 - R]];
                    } else {
                        path = [["M", 150, 150 - R], ["A", R, R, 0, +(alpha > 180), 1, x, y]];
                      }
                    //este metodo se llama siempre y puedo jugar con el objeto  
                    if(this.id == 4)
                      color = "#bbf263";
                    else if (this.id == 2) {
                      if(value < 10)
                        color = _colorStatus.bad;
                      else if(value < 40)
                        color = _colorStatus.less;
                    }
                    return {path: path, stroke: color};
                }

                initShapes();
      },

      setBatteryShape: function(value){
        updateVal(value, 100, 125, _batteryShape, 2); 
      },

      startCharging: function(){
        if(!_middleShape){
          _middleShape = _raphaelBattery.circle(150, 150, 16).attr({stroke: "none", fill: "#4a535b"});
          _middleShape.id = 3;
        }

        if(_texto)_texto.remove();

        updateVal(12, 12, 20, _chargingShape, 4);
        _init = false;
      },

      hideChargingShape: function(){
        _middleShape.hide();
        _chargingShape.hide();
      },

      putText: function(value){
        if(_texto)
          _texto.remove();
        _texto = _raphaelBattery.text(150, 150, value);
        _texto.attr({"font-size": "60px", "font-weight": "10", fill: "#f4f4f4", "stroke-width": "60"});
      }

    }

})(this);


var BatteryRecharge = (function(){
   /*Objeto Raphael que contiene el grafico de la bateria*/
    var _raphaelRecharge = {},
    _marksRatio = 0,
    _param = {stroke: "#fff", "stroke-width": 5},
    _hash = document.location.hash,
    _marksAttr = {fill: _hash || "#444", stroke: "none"},
    _colorStatus = {good: "#bbf263", less: "#f4f263", bad: "#ee655f"},
    _recharge1 = {},
    _recharge2 = {},
    _recharge3 = {},
    _texto = null,
    _set1 = false,
    _set3 = false,
    _set2 = false;
    
    /**
      Actualiza el valor de la bateria
    */
    function updateVal(value, total, R, hand, id) {
        if (value == total) {
              value = total;
              hand.animate({arc: [value, total, R]}, 375, "bounce", function () {
              });
        } else {
                hand.animate({arc: [value, total, R]}, 375, "elastic");
          }
    }
    /**
      Construye las marcas sobre las que
      se pinta el estado de la bateria
    */

    function drawMarks(R, total, center) {
        var color = "hsb(".concat(Math.round(R) / 75, ", 1, .75)"),
            out = _raphaelRecharge.set();
              
        for (var value = 0; value < total; value++) {
          var alpha = 360 / total * value,
          a = (90 - alpha) * Math.PI / 180,
          x = center + R * Math.cos(a),
          y = 50 - R * Math.sin(a);
          out.push(_raphaelRecharge.circle(x, y, 2).attr(_marksAttr));
        }
        return out;
    }

    function initShapes(){
      //Inicializando las marcas 
      drawMarks(_marksRatio, 20, 42);
      _recharge1 = _raphaelRecharge.path().attr(_param).attr({arc: [0, 30, _marksRatio]});
      _recharge1.id = 1;

      drawMarks(_marksRatio, 20, 135);
      _recharge2 = _raphaelRecharge.path().attr(_param).attr({arc: [0, 30, _marksRatio]});
      _recharge2.id = 2;

      drawMarks(_marksRatio, 20, 230);
      _recharge3 = _raphaelRecharge.path().attr(_param).attr({arc: [0, 30, _marksRatio]});
      _recharge3.id = 3;
      
    }

    return { 
        init: function(raphael){
                _raphaelRecharge = raphael;

                if(screen.width <= 320){
                  _marksRatio = 40;
                } 
                else if(screen.width >= 360){
                   _marksRatio = 50;
                }

                _raphaelRecharge.customAttributes.arc = function (value, total, R) {
                    var alpha = 360 / total * value,
                    a = (90 - alpha) * Math.PI / 180,
                    x = 0,  
                    y = 50 - R * Math.sin(a),
                    color = _colorStatus.good,
                    aux = 0,
                    path;
                    if(this.id == 1){
                      x = 40 + R * Math.cos(a);
                      aux = 42;
                    }else if(this.id == 2){
                      x = 135 + R * Math.cos(a);  
                      aux = 135;
                    }else if(this.id == 3){
                      x = 230 + R * Math.cos(a);
                      aux = 230;
                    }

                    if (total == value) {
                      path = [["M", aux, 50 - R], ["A", R, R, 0, 1, 1, aux - 0.01, 50 - R]];
                    } else {
                        path = [["M", aux, 50 - R], ["A", R, R, 0, +(alpha > 180), 1, x, y]];
                      }
                    //este metodo se llama siempre y puedo jugar con el objeto  
                    /*if(this.id == 4)
                      color = "#bbf263";
                    else if (this.id == 2) {
                      if(value < 10)
                        color = _colorStatus.bad;
                      else if(value < 40)
                        color = _colorStatus.less;
                    }*/
                    return {path: path, stroke: color};
                }

                initShapes();
                
                //
                BatteryRecharge.putText(42, 150, "1 Fast charging", 24);
                $(_texto.node).attr("data-l10n-id", "text24");
                BatteryRecharge.putText(135, 150, "2 Continuation", 0);
                $(_texto.node).attr("data-l10n-id", "text25");
                BatteryRecharge.putText(230, 150, "3 Trickle charging", 0);
                $(_texto.node).attr("data-l10n-id", "text26");
      },

      setRechargeShape: function(value, id){
        if(id == 1){
          if(!_set1){
            BatteryRecharge.reset();
            _set1 = true;
          }
          updateVal(value, 80, _marksRatio, _recharge1, id); 
        }else if(id == 2){
          if (!_set3) {
            updateVal(80, 80, _marksRatio, _recharge1, 1);
            updateVal(0, 5, _marksRatio, _recharge3, 3);
            _set3 = true;
          }
          updateVal(value, 15, _marksRatio, _recharge2, id);
        }else if(id == 3){
          if(!_set2){
            updateVal(15, 15, _marksRatio, _recharge2, 2);
            updateVal(80, 80, _marksRatio, _recharge1, 1);
            _set2 = true;
          }
          updateVal(value, 5, _marksRatio, _recharge3, id);
        }
      },

      reset: function(){
        updateVal(0, 80, _marksRatio, _recharge1, 1); 
        updateVal(0, 15, _marksRatio, _recharge2, 2);
        updateVal(0, 5, _marksRatio, _recharge3, 3);
      },

      putText: function(x, y, value, translate){
        _texto = _raphaelRecharge.text(x, y, "");
        _texto.attr({"font-size": 11, fill: "#959DA6"});
      }

    }

})(this);

