var battery = navigator.battery || navigator.mozBattery
          || navigator.webkitBattery,

BatteryApp = (function(){
 /*Attributes*/
  var _settings = {
    dischargingTimeStart : '',
    dischargingTimeEnd : '',
    dischargingTimeInterval : 352.5265
  };


 /*Private functions*/
  function createCalendar(){
    
    var monthNames = new Array("January", "February", "March", "April",
          "May", "June", "July", "August", "September", "October",
          "November", "December"),
    monthdays = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31),
    today = new Date(),
    month = today.getMonth(),
    day = today.getDay(),
    dayN = today.getDate(),
    days = monthdays[month];

    $('#calendarMonth').attr("data-l10n-id", monthNames[month]);
    $('#calendarMonth').text(monthNames[month]);
    $('#calendarBody').html("");
    $('#rechargeMonth').attr("data-l10n-id", monthNames[month]);
    $('#rechargeMonth').text(monthNames[month]);
    $('#rechargeCalendar').text(dayN);
    $('#rechargeMonth1').attr("data-l10n-id", monthNames[month]);
    $('#rechargeMonth1').text(monthNames[month]);
    $('#rechargeCalendar1').text(dayN);

    if(!BatteryApp.defaultConfiguration.currentMonth){
      BatteryApp.defaultConfiguration.currentMonth = monthNames[month];
      //deleteAllOsBatteryChargeRecord();
      BatteryApp.saveConfiguration();
    }else if (BatteryApp.defaultConfiguration.currentMonth != monthNames[month]) {
      //erase all data
      deleteAllOsBatteryChargeRecord();
      BatteryApp.defaultConfiguration.currentMonth = monthNames[month];
      BatteryApp.saveConfiguration();
    }

    if (month > 0) {
        var year = today.getYear();
        $('#calendarYear').text(today.getFullYear());
        
        if (year % 4 == 0)
          days = 29;
    }

    var jumped = 0,
    inserted = 1,
    start = day - dayN % 7 + 1;
    if (start < 0)
      start += 7;
    var weeks = parseInt((start + days) / 7);

    if ((start + days) % 7 != 0)
      weeks++;

    for ( var i = weeks; i > 0; i--) {
      var tr = document.createElement("tr");
      for ( var j = 7; j > 0; j--) {
        var td = document.createElement("td");
        if (jumped < start || inserted > days) {
          td.className = "ui-datepicker-other-month ui-datepicker-unselectable ui-state-disabled";
          span = document.createElement("span");
          span.className = "ui-state-default";
          span.appendChild(document.createTextNode("--"));
          td.appendChild(span);
          jumped++;
        } else {
            link = document.createElement("a");
            link.setAttribute("href", "#");
            link.id = "day" + inserted;
            link.appendChild(document.createTextNode(inserted));
            if (inserted == dayN) {
              link.className = "ui-state-default ui-state-highlight ui-state-active";
              td.id = "td" + inserted;
              if (j == 1 || j == 7) {
                td.className = "ui-datepicker-days-cell-over  ui-datepicker-current-day ui-datepicker-today ui-datepicker-week-end";
              } else {
                td.className = "ui-datepicker-days-cell-over  ui-datepicker-current-day ui-datepicker-today";
              }
            } else {
                link.className = "ui-state-default";
                if (j == 1 || j == 7) {
                  td.className = "ui-datepicker-other-month ui-datepicker-week-end";
                }
              }
            // Update calendar

            td.appendChild(link);
            inserted++;
          }
          tr.appendChild(td);
        }
        $('#calendarBody').append(tr);
      }

      listAllOsBatteryChargeRecord(function(err, value) {
        if (value) {
          //console.log("entro al calendario");
          //console.log(value);
          BatteryApp.chargeStatics.totalFullCharge += (value.cantFullCharge > 0) ? value.cantFullCharge : 0;
          BatteryApp.chargeStatics.totalNormalCharge += (value.cantNormalCharge > 0) ? value.cantNormalCharge : 0;
          BatteryApp.chargeStatics.totalOverCharge += (value.cantOverCharge > 0) ? value.cantOverCharge : 0;
          var element = null;
          if(value.day == dayN){
            element =  $('#td' + value.day);
            $('#rechargeFull').text(value.cantFullCharge);
            $('#rechargeGood').text(value.cantNormalCharge);
            $('#rechargeBad').text(value.cantOverCharge);
            $('#rechargeFull1').text(value.cantFullCharge);
            $('#rechargeGood1').text(value.cantNormalCharge);
            $('#rechargeBad1').text(value.cantOverCharge);
          }else{
            element = $('#' + 'day' + value.day);
          }

          element.attr('cantFullCharge', value.cantFullCharge);
          element.attr('cantNormalCharge', value.cantNormalCharge);
          element.attr('cantOverCharge', value.cantOverCharge);
          element.attr('day', value.day);

          element.on('click', function(e){
            var el = e.target; 
            $('#rechargeFull').text(el.getAttribute('cantFullCharge'));
            $('#rechargeGood').text(el.getAttribute('cantNormalCharge'));
            $('#rechargeBad').text(el.getAttribute('cantOverCharge'));
            $('#rechargeCalendar').text(el.getAttribute('day'));
            $('#rechargeFull1').text(el.getAttribute('cantFullCharge'));
            $('#rechargeGood1').text(el.getAttribute('cantNormalCharge'));
            $('#rechargeBad1').text(el.getAttribute('cantOverCharge'));
            $('#rechargeCalendar1').text(el.getAttribute('day'));
          });

          if (value.cantFullCharge > 0) {
            element.addClass("fullCharge");
          } else if (value.cantNormalCharge > 0
              && value.cantOverCharge <= 0) {
            element.addClass("normalCharge");
          } else if (value.cantOverCharge > 0) {
            element.addClass("overCharge");
          }
          updateCalendarStatics();
        }
      });
      //updateCalendarStatics();
      navigator.mozL10n.translate();
  }


  function updateCalendarStatics(){
    //console.log("entro para actualizar");
    $("#full-info").text(BatteryApp.chargeStatics.totalFullCharge);
    $("#normal-info").text(BatteryApp.chargeStatics.totalNormalCharge);  
    $("#over-info").text(BatteryApp.chargeStatics.totalOverCharge);
  }

  /**
   *
   */
   function updateCurrentDateStaticsCharge(){
     var today = new Date(),
     dayN = today.getDate(),
     element = $('#td' + dayN);
     getOsBatteryChargeRecord(dayN, function(err, value) {
        if (value) {
          if (value.cantFullCharge > 0) {
            element.addClass('fullCharge');
          } else if (value.cantNormalCharge > 0 && value.cantOverCharge <= 0) {
            element.addClass('normalCharge');
          } else if (value.cantOverCharge > 0) {
            element.addClass('overCharge');
          }

          $('#rechargeFull').text(value.cantFullCharge);
          $('#rechargeGood').text(value.cantNormalCharge);
          $('#rechargeBad').text(value.cantOverCharge);
          $('#rechargeCalendar').text(dayN);
          $('#rechargeFull1').text(value.cantFullCharge);
          $('#rechargeGood1').text(value.cantNormalCharge);
          $('#rechargeBad1').text(value.cantOverCharge);
          $('#rechargeCalendar1').text(dayN);
        }
      });
   }

  /*Updates the status of the battery each time it changes*/
  function updateBatteryStatus(){
      /* Gets the battery charge level */
      var level = Math.floor(battery.level * 100);
      BatterySvg.setBatteryShape(level);
      BatterySvg.putText(level + '%');

      if(battery.charging){
        //rest time
        $('#col-recherge').removeClass('hidden');
        $('#rowUse').removeClass('hidden');

        remainingLevel = 100 - level;
        fastCharging = 0;
        continuationCharging = 0;
        trickleCharging = 0;
        time = 0;
        if(level <= 80){
          remainingLevel = 80 - level;
          BatteryRecharge.setRechargeShape(level, 1);
          time = (remainingLevel * 90.138) + (15 * 80.279) + (5 * 524.818);
          timeUse = (remainingLevel * 122.719) + (15 * 83.243) + (5 * 1662.957); 
        }else if (level > 80 && level <= 95) {
          remainingLevel = 95 - level;
          BatteryRecharge.setRechargeShape(15 - remainingLevel, 2);
          time = (remainingLevel * 80.279) + (5 * 524.818);
          timeUse = (remainingLevel * 83.243) + (5 * 1662.957);
        }else if (level >= 96 && level <= 100) {
          remainingLevel = 100 - level;
          BatteryRecharge.setRechargeShape(5 - remainingLevel, 3);
          time = remainingLevel * 524.818;
          timeUse = remainingLevel * 1662.957;
        }

        remainingTime = convertToTimeObject(time);
        remainingTimeUse = convertToTimeObject(timeUse);

        if(level == 100){
          $("#batteryStatus").attr("data-l10n-id", "text3");
          $("#batteryStatus").text("Charged...");
          $('#col-recherge').addClass('hidden');
          $('#rowUse').addClass('hidden');
        }  
        else{
         $("#batteryStatus").attr("data-l10n-id", "text4"); 
         $("#batteryStatus").text("Charging..."); 
        }
        $("#timeLeft").text(remainingTime.h + "h " + remainingTime.m + "m");
        $("#timeLeftUse").text(remainingTimeUse.h + "h " + remainingTimeUse.m + "m");
      }else{
        $('#col-recherge').addClass('hidden');
        $('#rowUse').addClass('hidden');
        $("#batteryStatus").attr("data-l10n-id", "text5");
        $("#batteryStatus").text("Discharging..."); 
        remainingTime = (_settings.dischargingTimeInterval * level);
        remainingTime = convertToTimeObject(remainingTime);
        $("#timeLeft").text(remainingTime.h + "h " + remainingTime.m + "m");
      }

      //Forzar traduccion
      navigator.mozL10n.translate();

      //standby
      consumption = consumptionByType(1, level);
      time = convertToTimeObject(consumption);
      $("#standByTime").text(time.h + "h " + time.m + "m");
      //talkTime
      consumption = consumptionByType(2, level);
      time = convertToTimeObject(consumption);
      $("#talkTime").text(time.h + "h " + time.m + "m"); 
      //audioTime
      consumption = consumptionByType(3, level);
      time = convertToTimeObject(consumption);
      $("#audioTime").text(time.h + "h " + time.m + "m"); 
      //videoTime
      consumption = consumptionByType(4, level);
      time = convertToTimeObject(consumption);
      $("#videoTime").text(time.h + "h " + time.m + "m"); 
      //webTime
      consumption = consumptionByType(5, level);
      time = convertToTimeObject(consumption);
      $("#webTime").text(time.h + "h " + time.m + "m");
      //gameTime
      consumption = consumptionByType(6, level);
      time = convertToTimeObject(consumption);
      $("#gameTime").text(time.h + "h " + time.m + "m"); 
      //GPSTime
      consumption = consumptionByType(7, level);
      time = convertToTimeObject(consumption);
      $("#GPSTime").text(time.h + "h " + time.m + "m"); 

      time = Infinity;
      if (battery.chargingTime !== Infinity) time = battery.chargingTime;
      if (battery.dischargingTime !== Infinity) time = battery.dischargingTime;

      if (time !== Infinity && time != 0) {
        timeF = convertToTimeObject(time);
        $('#timeLeft').text(timeF.h + "h " + timeF.m + "m");
      }
  }

  /**
   *Convert seconds to time object
   *@param seconds 
   *           Seconds that will be converted to a date object
   * 
   *
   */

  function convertToTimeObject(seconds){
      var objTime = {
        "h" : '',
        "m" : '',
        "s" : ''
      };
      //hours
      objTime.h = Math.floor(seconds / 3600);
      //minutes
      restForMinutes = seconds % 3600;
      objTime.m = Math.floor(restForMinutes / 60);
      //seconds
      restForSeconds = restForMinutes % 60;
      objTime.s = Math.ceil(restForSeconds);
      return objTime;
  }

  /**
   + 1 ---- standby
   * 2 ---- talktime
   + 3 ---- audioplayback
   + 4 ---- videoplayback 
   + 5 ---- websurfing
   * 6 ---- games
   * 7 ---- navigationgps
   */
   function consumptionByType(type, level){
      switch(type){
        case 1:
          return (Math.floor((level * 10) / 0.09)) * 60;
        case 2:
          return (Math.floor((level * 10) / 2.90)) * 60;
        case 3:
          return (Math.floor((level * 10) / 2)) * 60;
        case 4:
          return (Math.floor((level * 10) / 3)) * 60;
        case 5:
          return (Math.floor((level * 10) / 2.2)) * 60;
        case 6:
          return (Math.floor((level * 10) / 4)) * 60;
        case 7:
          return (Math.floor((level * 10) / 3.2)) * 60;           
      }
   }

  /**
   * Calculate the interval time
   */

   function levelChange(){
      _settings.dischargingTimeEnd = (new Date()).getTime();
      _settings.dischargingTimeInterval = (_settings.dischargingTimeEnd - _settings.dischargingTimeStart) / 1000;
      _settings.dischargingTimeStart = (new Date()).getTime();

      updateBatteryStatus();


      if(BatteryApp.currentChargeRecord.day != (new Date()).getDate()){
        BatteryApp.resetStatics();
        createCalendar();
      }
   }

   /**
    *
    * Initializes the application loading configuration
    * and updating the status of the battery
    *
    */ 
   function run(){
      updateBatteryStatus();
      initDefaultConfiguration();
   }

   /**
    *
    *
    */
    function initViewComponents(){
        
        select = $('#selectBatteryLevel'),
        select1 = $('#selectBatteryCharge');

        select.val(BatteryApp.defaultConfiguration.dataBatteryLevelChange);
        select1.val(BatteryApp.defaultConfiguration.dataBatteryChargingChange);

        if(BatteryApp.defaultConfiguration.alarmBatteryLevelChange){
          var label = $('label[for=batteryLevel]');
          label.addClass('checked');
          select.removeClass('hidden');
        }
        if (BatteryApp.defaultConfiguration.alarmBatteryChargingChange) {
          var label = $('label[for=batteryCharge]');
          label.addClass('checked');
          select1.removeClass('hidden');
        }
    }

   /**
    *Load the application configuration
    */

   function initDefaultConfiguration(){
     if (!db) {
        // HACK:
        // this condition may happen upon first time use when the
        // indexDB storage is under creation and refreshMemoList()
        // is called. Simply waiting for a bit longer before trying
        // again
        // will make it work., ,,,,,,,,,
        setTimeout(initDefaultConfiguration, 1000);
        return;
      }


      getConfiguration("System", function(err, value) {
        if (value) {
          BatteryApp.defaultConfiguration = value;
          BatteryApp.defaultConfiguration.loaded = true;
          initViewComponents();
        }
      });

      var today = new Date();
      getOsBatteryChargeRecord(today.getDate(), function(err, value) {
        if (value) {
          BatteryApp.currentChargeRecord = value;
        } else {
          BatteryApp.currentChargeRecord = new osBatteryChargeRecord();
          BatteryApp.currentChargeRecord.day = today.getDate();
        }
        BatteryApp.resetStatics();
        createCalendar();
      });
   }

   
   /**
    *
    */
   function putAlarm(alarm){
      
      if (alarm.batteryLevel) {
        if (!BatteryApp.defaultConfiguration.alarmBatteryLevelChange) {

          BatteryApp.defaultConfiguration.dataBatteryLevelChange = alarm.batteryLevel;
          BatteryApp.defaultConfiguration.alarmBatteryLevelChange = true;
          BatteryApp.defaultConfiguration.alarmBatteryLevelFired = false;
        } else {
          if (alarm.batteryLevel != BatteryApp.defaultConfiguration.dataBatteryLevelChange) {
            BatteryApp.defaultConfiguration.dataBatteryLevelChange = alarm.batteryLevel;
            BatteryApp.defaultConfiguration.alarmBatteryLevelFired = false;
          }
        }
      }
      /**/
      if (alarm.batteryCharge) {
        if (!BatteryApp.defaultConfiguration.alarmBatteryChargingChange) {
          BatteryApp.defaultConfiguration.dataBatteryChargingChange = alarm.batteryCharge;
          if (BatteryApp.defaultConfiguration.dataBatteryChargingChange > 0) {
            BatteryApp.defaultConfiguration.alarmBatteryChargingChange = true;
            BatteryApp.defaultConfiguration.alarmBatteryChargingFired = false;
          }
        } else {
          if (alarm.batteryCharge != BatteryApp.defaultConfiguration.dataBatteryChargingChange) {
            BatteryApp.defaultConfiguration.dataBatteryChargingChange = alarm.batteryCharge;
            BatteryApp.defaultConfiguration.alarmBatteryChargingFired = false;
          }
        }
      }

      saveOsBatteryConfiguration(BatteryApp.defaultConfiguration, function(
          error, data) {

      });
   } 

   /**
    *
    *  
    */
   function notify(subject, text, pic, callback){
      lastNot = navigator.mozNotification.createNotification(subject,
          text, pic);
      lastNot.onclick = function() {
        callback();
      };
      lastNot.show();
   }

   /**
    *
    *
    */
   function alarmSet(data, interval){
      if (navigator.mozAlarms) {
        var req = navigator.mozAlarms.add(new Date(Date.now()
            + interval), 'ignoreTimezone', data);
        req.onsuccess = function() {
        }
        req.onerror = function() {
        }
      } else {
      }
   }

   /**
    *
    *
    */

    function compareBatteryStatus(value){
      charge = Math.floor(battery.level * 100);
      if (value == charge)
        return 0;
      else if (value > charge)
        return 1;
      else
        return -1;
    }

    /**
     *
     *
     */
     function fireAlarm(){
       if (BatteryApp.defaultConfiguration.alarmBatteryLevelChange) {
        var compare = compareBatteryStatus(BatteryApp.defaultConfiguration.dataBatteryLevelChange);
        var actualLevel = Math.floor(battery.level * 100);
        var diference = (BatteryApp.defaultConfiguration.dataBatteryLevelChange > actualLevel) ? BatteryApp.defaultConfiguration.dataBatteryLevelChange
            - actualLevel : 3;
        if (!BatteryApp.defaultConfiguration.alarmBatteryLevelFired
            && (compare == 0 || diference <= 2)) {
              notify(_('msg5'), _('msg6') + actualLevel + "%", null,
                function() {

              });
          BatteryApp.defaultConfiguration.alarmBatteryLevelFired = true;
        } else {
          if (BatteryApp.defaultConfiguration.alarmBatteryLevelFired
              && diference == 3) {
            BatteryApp.defaultConfiguration.alarmBatteryLevelFired = false;
          }
        }
      }

      if (battery.charging && BatteryApp.defaultConfiguration.alarmBatteryChargingChange) {
        var actualLevel = Math.floor(battery.level * 100);
        compare = compareBatteryStatus(BatteryApp.defaultConfiguration.dataBatteryChargingChange);
        var diference = (BatteryApp.defaultConfiguration.dataBatteryChargingChange < actualLevel) ? actualLevel
            - BatteryApp.defaultConfiguration.dataBatteryChargingChange
            : 3;
        if ((compare == 0 || diference <= 2) && !BatteryApp.defaultConfiguration.alarmBatteryChargingFired) {
              notify(_('msg5'), _('msg7') + actualLevel + "%", null,
                function() {

              });
          BatteryApp.defaultConfiguration.alarmBatteryChargingFired = true;
        } else {
          if (BatteryApp.defaultConfiguration.alarmBatteryChargingFired && diference == 3) {
            BatteryApp.defaultConfiguration.alarmBatteryChargingFired = false;
          }
        }
      } 
     }

     /**
      *
      */
      function registerCharge(){
        var change = false,
        actualLevel = Math.floor(battery.level * 100);
        if (battery.charging) {
          if (!BatteryApp.defaultConfiguration.isCharging) {
            BatteryApp.defaultConfiguration.isCharging = true;
            change = true;
          } else {
            if (actualLevel == 100 && !BatteryApp.defaultConfiguration.timeChargeOver) {
              BatteryApp.defaultConfiguration.timeChargeOver = Date.now();
              change = true;
            } else {
              if (actualLevel == 100 && !BatteryApp.defaultConfiguration.overChange) {
                rest = ((Date.now() - BatteryApp.defaultConfiguration.timeChargeOver) / 1000) / 60;
                if (rest >= 30) {
                  BatteryApp.currentChargeRecord.cantOverCharge += 1;
                  BatteryApp.chargeStatics.totalOverCharge += 1;
                  BatteryApp.defaultConfiguration.overChange = true;
                  change = true;
                }
              }
            }
          }
        }else {
          if (BatteryApp.defaultConfiguration.isCharging) {
            BatteryApp.defaultConfiguration.isCharging = false;
            if (actualLevel >= 80 && actualLevel <= 95) {
              BatteryApp.currentChargeRecord.cantNormalCharge += 1;
              BatteryApp.chargeStatics.totalNormalCharge += 1;
            } else {
              if (actualLevel == 100) {
                BatteryApp.currentChargeRecord.cantFullCharge += 1;
                BatteryApp.chargeStatics.totalFullCharge += 1;
              }
            }
            BatteryApp.defaultConfiguration.timeChargeOver = null;
            BatteryApp.defaultConfiguration.overChange = false;
            BatteryApp.defaultConfiguration.isCharging = false;
            change = true;
          }
        }
        if (change && db) {
          saveOsBatteryChargeRecord(BatteryApp.currentChargeRecord, function(
              error, data) {
            updateCurrentDateStaticsCharge();
            updateCalendarStatics();
          });
          saveOsBatteryConfiguration(BatteryApp.defaultConfiguration, function(
              error, data) {

          });
          //updateCalendarStatics();
          //updateCurrentDateStaticsCharge();
        }
      }

      /**
       *
       */
       function checkBattery(){
          async.parallel([ function(callback) {
            fireAlarm();
          }, function(callback) {
            updateBatteryStatus();
          }, function(callback) {
            registerCharge();
          } ], function(err, results) {

          });
       }

 /*Public functions*/
  return {
    defaultConfiguration : {},
    settings : _settings,
    currentChargeRecord : {},
    chargeStatics : {
      totalFullCharge : 0,
      totalNormalCharge : 0,
      totalOverCharge : 0
    },
    timeChargeAlarm : 0,
    timeDischargeAlarm : 6000,

    resetStatics : function(){
      BatteryApp.chargeStatics.totalFullCharge = 0;
      BatteryApp.chargeStatics.totalOverCharge = 0;
      BatteryApp.chargeStatics.totalNormalCharge = 0;
    },

    updateBatteryStatus : function(){
      checkBattery();
    },

    init : function(){
       if(!BatteryApp.defaultConfiguration.loaded)
        run();
    },

    levelChange : function(){
      async.parallel([ function(callback) {
        fireAlarm();
      }, function(callback) {
        levelChange();
      }, function(callback) {
        registerCharge();
      }], function(err, results) {

      });
    },

    putAlarm : function(alarm){
      putAlarm(alarm);
    },

    alarmSet : function(data, interval){
       alarmSet(data, interval);
    },

    saveConfiguration : function(){
      saveOsBatteryConfiguration(BatteryApp.defaultConfiguration, function(
          error, data) {

      });
    }
  }
})(this);



$(document).ready(function(){
   /*Initialize the raphael library*/
   var r = Raphael("battery-canvas", 300, 300);
   BatterySvg.init(r);
   BatteryRecharge.init(Raphael("battery-recharge", 300, 200));
   //initialize the application
   BatteryApp.init();
   /**/

   if(battery){
      BatteryApp.settings.dischargingTimeStart = (new Date()).getTime();
      battery.addEventListener("chargingchange", BatteryApp.updateBatteryStatus, false);
      battery.addEventListener("chargingtimechange", BatteryApp.updateBatteryStatus, false);
      battery.addEventListener("dischargingtimechange", BatteryApp.updateBatteryStatus, false);
      battery.addEventListener("levelchange", BatteryApp.levelChange, false);
   }

   $('#selectBatteryLevel').on('change', function() {
      BatteryApp.putAlarm({
        batteryLevel : this.value
      })
    });

   $('#selectBatteryCharge').on('change', function() {
      BatteryApp.putAlarm({
        batteryCharge : this.value
      })
    });

    $('#adjust').on('click', function(e) {
      e.preventDefault();
      var openSettings = new MozActivity({
      name : "configure",
      data : {
        target : "device"
        }
      });
    });

    window.addEventListener("beforeunload", function() {
      if (BatteryApp.defaultConfiguration.alarmBatteryLevelChange
          || BatteryApp.defaultConfiguration.alarmBatteryChargingChange)
        BatteryApp.alarmSet({type : "appload"},6000);
        db.close();
    }, false);

    window.addEventListener("unload", function() {
      if (BatteryApp.defaultConfiguration.alarmBatteryLevelChange
          || BatteryApp.defaultConfiguration.alarmBatteryChargingChange)
        BatteryApp.alarmSet({type : "appload"},6000);

      db.close();
    }, false);

    if (navigator.mozSetMessageHandler) {
      navigator.mozSetMessageHandler("alarm", function(message) {
        BatteryApp.init();
        BatteryApp.fireAlarm();
        navigator.mozAlarms.remove(message.id);
      });
    }
});