var batteryDB = "osBattery";
var version = 2;

var db;
var request = indexedDB.open(batteryDB, version);

request.onerror = function(event) {
};
request.onsuccess = function(event) {
	db = event.target.result;
};

request.onupgradeneeded = function(event) {

	db = event.target.result;

	if(event.oldVersion <= 1){
		if (!db.objectStoreNames.contains("osBatteryConfiguration")) {

			var objectStore = db.createObjectStore("osBatteryConfiguration", {
				keyPath : "id",
				autoIncrement : true
			});
			objectStore.createIndex("name", "name", {
				unique : false
			});

			var defaultOsBattery = new osBatteryConfiguration();
			objectStore.add(defaultOsBattery);
		}
	}if(event.oldVersion <= 2){
		if (!db.objectStoreNames.contains("osBatteryChargeRecord")) {
			var chargeStore = db.createObjectStore("osBatteryChargeRecord", {
				keyPath : "id",
				autoIncrement : true
			});

			chargeStore.createIndex("day", "day", {
				unique : false
			});
		}
	}
};

/**
 * This osBattery function is used to create new osBattery configurations.
 * 
 * @constructor
 */

function osBatteryConfiguration() {
	this.name = "System";
	this.description = "Default osBattery configuration";
	this.alarmBatteryChargingChange = false;
	this.dataBatteryChargingChange = 0;
	this.alarmBatteryChargingFired = false;
	this.alarmBatteryLevelChange = false;
	this.dataBatteryLevelChange = 0;
	this.alarmBatteryLevelFired = false;
	this.created = Date.now();
	this.modified = Date.now();
	this.currentMonth = null;
	this.registerCharge = false;
}

/**
 * 
 */
function osBatteryChargeRecord() {
	this.day = 0;
	this.cantFullCharge = 0;
	this.cantNormalCharge = 0;
	this.cantOverCharge = 0;
}

/*
 * +
 * 
 */

/**
 * This function is used to save a osBatteryConfiguration into the indexedDB
 * database. It is called on the 'change' event of the text inputs, so it is
 * very aggressive. The idea behind this is that the user never needs to save a
 * osBatteryConfiguration for it is always in the saved state.
 * 
 * @param inosBattery
 * @param inCallback
 */
function saveOsBatteryConfiguration(inosBattery, inCallback) {
	var transaction = db.transaction([ "osBatteryConfiguration" ], "readwrite");

	transaction.oncomplete = function(event) {
		
	};

	transaction.onerror = function(event) {
		inCallback({
			error : event
		}, null);

	};

	var objectStore = transaction.objectStore("osBatteryConfiguration");

	inosBattery.modified = Date.now();

	var request = objectStore.put(inosBattery);
	
	request.onsuccess = function(event) {
		inCallback(null, request.result);
	};
}

function getConfiguration(name, inCallBack) {
    var transaction = db.transaction("osBatteryConfiguration", "readonly");
	
	var store = transaction.objectStore("osBatteryConfiguration");
	var index = store.index("name");
	var request = index.get(name);

	request.onsuccess = function() {
		var matching = request.result;
		if (matching !== 'undefined') {
			inCallBack(null, matching);
		}
	};
}

function saveOsBatteryChargeRecord(data, inCallback) {
	var transaction = db.transaction([ "osBatteryChargeRecord" ], "readwrite");

	transaction.oncomplete = function(event) {
		
	};

	transaction.onerror = function(event) {
		inCallback({
			error : event
		}, null);

	};

	var objectStore = transaction.objectStore("osBatteryChargeRecord");

	data.modified = Date.now();

	var request = objectStore.put(data);

	request.onsuccess = function(event) {
		inCallback(null, request.result);

	};
}

function getOsBatteryChargeRecord(day, inCallBack) {
	var transaction = db.transaction("osBatteryChargeRecord", "readonly");
	
	var store = transaction.objectStore("osBatteryChargeRecord");
	var index = store.index("day");
	var request = index.get(day);

	request.onsuccess = function() {
		var matching = request.result;
		if (matching !== 'undefined') {
			inCallBack(null, matching);
		}
	};
}

function listAllOsBatteryChargeRecord(inCallback) {
    var objectStore = db.transaction("osBatteryChargeRecord").objectStore("osBatteryChargeRecord");

    objectStore.openCursor().onsuccess = function (event) {
        var cursor = event.target.result;
        if (cursor) {
            inCallback(null, cursor.value);
            cursor.continue();
        }
    };
}

function deleteOsBatteryChargeRecord(inId, inCallback) {
    
    var request = db.transaction(["osBatteryChargeRecord"], "readwrite").objectStore("osBatteryChargeRecord").delete(inId);

    request.onsuccess = function (event) {
        inCallback();
    };
}

function deleteAllOsBatteryChargeRecord() {
	listAllOsBatteryChargeRecord(function(err, value) {
		if(value){
			deleteOsBatteryChargeRecord(value.id, function(err, succ) {
				
			});
		}
	});
}