/**
 * --------------------------------------------------------------------
 * jQuery customInput plugin
 * Author: Maggie Costello Wachs maggie@filamentgroup.com, Scott Jehl, scott@filamentgroup.com
 * Copyright (c) 2009 Filament Group 
 * licensed under MIT (filamentgroup.com/examples/mit-license.txt)
 * --------------------------------------------------------------------
 */
jQuery.fn.customInput = function(){
	return $(this).each(function(){	
		if($(this).is('[type=checkbox],[type=radio]')){
			var input = $(this);
			
			// get the associated label using the input's id
			var label = $('label[for='+input.attr('id')+']'),
			select = $('#' + input.attr('select-id'));
			
			// wrap the input + label in a div 
			input.add(label).wrapAll('<div class="custom-'+ input.attr('type') +'"></div>');
			
			// necessary for browsers that don't support the :hover pseudo class on labels
			label.hover(
				function(){ $(this).addClass('hover'); },
				function(){ $(this).removeClass('hover'); }
			);
			
			//bind custom event, trigger it, bind click,focus,blur events					
			input.bind('updateState', function(){	
				if(input.is(':checked')){
					label.addClass('checked');
					select.removeClass('hidden');
					if(BatteryApp.defaultConfiguration.loaded){
						if(input.attr('select-id') == 'selectBatteryLevel'){
							BatteryApp.defaultConfiguration.alarmBatteryLevelChange = true;
							BatteryApp.saveConfiguration();
						}else{
							BatteryApp.defaultConfiguration.alarmBatteryChargingChange = true;
							BatteryApp.saveConfiguration();
						}
					}
				}else{
					label.removeClass('checked checkedHover checkedFocus');
					select.addClass('hidden');
					if(BatteryApp.defaultConfiguration.loaded){
						if(input.attr('select-id') == 'selectBatteryLevel'){
							BatteryApp.defaultConfiguration.alarmBatteryLevelChange = false;
							BatteryApp.saveConfiguration();
						}else{
							BatteryApp.defaultConfiguration.alarmBatteryChargingChange = false;
							BatteryApp.saveConfiguration();
						}
					}
				}
			})
			.trigger('updateState')
			.click(function(){ 
				$('input[name='+ $(this).attr('name') +']').trigger('updateState'); 
			})
			.focus(function(){ 
				label.addClass('focus'); 
				if(input.is(':checked')){  $(this).addClass('checkedFocus'); } 
			})
			.blur(function(){ label.removeClass('focus checkedFocus'); });
		}
	});
};


	
	
