/*
 * OTPWCalc - One time password challenge response calculator client
 * Copyright © 2013 Michael Schloh von Bennewitz <michael@schloh.com>
 * 
 * OTPWCalc is free software: you can redistribute it and/or modify
 * it under the terms of the European Union Public Licence, either
 * version 1.1 of the license, or (at your option) any later version.
 * 
 * OTPWCalc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the European Union Public License for more details.
 * 
 * You should have received a copy of the European Union Public
 * Licence along with OTPWCalc. If not, please refer to
 * <http://joinup.ec.europa.eu/software/page/eupl/>.
 * 
 * This file is part of project OTWPCalc, a one time password challenge
 * response calculator client and is found at http://otpwcalc.europalab.com/
 * 
 * help.js: ECMA JavaScript implementation
 */

// <![CDATA[
//// This doesn't work with AJAX (use pageinit instead)
//// That means JavaScript in the head of any other HTML
//// will be ignored, only the data-role="page" is parsed
//$(document).ready(function() {
    //$.mobile.ajaxLinksEnabled = false;
//});
$(document).on("mobileinit", function() {
    $.extend( $.mobile , {
        pageLoadErrorMessage: 'Either the page cannot be found or it cannot be loaded.'
    });
    //$("#pageid").on("pagebeforeshow", function(event, data) {
    //    alert("the previous page was: " + data.prevPage.attr("id"));
    //});
});
$(document).on("pageinit", "[data-role='page'].type-interior", function() {
    $(".ui-collapsible[data-allow-collapse=false]").off("expand collapse");
});
$(document).on("pageinit", "[data-role='page'].oc-swipage", function() {
    var makepage = "#" + $(this).attr("id"),
        next = $(this).jqmData("next"),  // Next page stored in data-next
        prev = $(this).jqmData("prev");  // Previous page stored in data-prev

    if (next) {  // Check if data-next attribute is indeed set
        //// Prefetch next page
        //$.mobile.loadPage(next);
        // Navigate to next page on swipe left
        $(document).on("swipeleft", makepage, function(inev) {
            inev.stopImmediatePropagation();
            $.mobile.changePage(next, {transition: "slide"});
        });
    }
    else {  // If data-next not set then default to history
        $(document).on("swipeleft", makepage, function(inev) {
            inev.stopImmediatePropagation();
            window.history.forward({transition: "slide"});
        });
    }
    if (prev) {  // Check if data-prev attribute is set
        $(document).on("swiperight", makepage, function(inev) {
            inev.stopImmediatePropagation();
            $.mobile.changePage(prev, {transition: "slide", reverse: true});
        });
    }
    else {  // If data-prev not set then default to history
        $(document).on("swiperight", makepage, function(inev) {
            inev.stopImmediatePropagation();
            //history.back();  // or window.history.back();
            $.mobile.back({transition: "slide", reverse: true});
        });
    }
});
