/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

 $(document).on("mobileinit", function(){
                $.extend( $.mobile , {
                    pageLoadErrorMessage: 'Either the page cannot be found or it cannot be loaded.'
                });
            });
            
            $(function(){

                if( /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent) ) {

                    var ww = ( $(window).width() < window.screen.width ) ? $(window).width() : window.screen.width;
                    
                    var mw = 1080;
                    var ratio =  ww / mw;
                    //alert("O ww: " + ww + "  -" +ratio);
                    if( ww <= mw){
                        $('head').append('<meta name="viewport" content="user-scalable=no, initial-scale=' + ratio + ', maximum-scale=' + ratio + ', minimum-scale=' + ratio + ', width=device-width, height=device-height, user-scalable=0, target-densitydpi=medium-dpi">');
                    }else{
                        $('head').append('<meta name="viewport" content="user-scalable=no, initial-scale=' + ratio + ', maximum-scale=' + ratio + ', minimum-scale=' + ratio + ', width=device-width, height=device-height, target-densitydpi=device-dpi">');
                                                
                        /*$('head').append('<meta name="viewport" content="user-scalable=no, width=device-width, initial-scale=' + ratio + ', maximum-scale=' + ratio + ', minimum-scale=' + ratio + ', user-scalable=0, target-densitydpi=device-dpi">');*/

                        /*$('#viewport').attr('content', 'initial-scale=' + ratio + ', maximum-scale=' + atio + ', minimum-scale=' + ratio + ', user-scalable=no, target-densitydpi=medium-dpi, width=' + ww);*/
                    }
                }
            });


var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicity call 'app.receivedEvent(...);'
    onDeviceReady: function() {
        app.receivedEvent('deviceready');
    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
        var parentElement = document.getElementById(id);
        var listeningElement = parentElement.querySelector('.listening');
        var receivedElement = parentElement.querySelector('.received');

        listeningElement.setAttribute('style', 'display:none;');
        receivedElement.setAttribute('style', 'display:block;');

        console.log('Received Event: ' + id);
    }
};


carregarConfiguracoes();



function validarLocalStorage(){    
    if (typeof(Storage) == "undefined" ){            
        alert("Sorry, does not support Web Storage...\nContact to grupoSepto");
        return false;
    }
    return true;
}

function carregarConfiguracoes(){
    $( "#popUpGameOver" ).popup();
    $( "#popUpErrado" ).popup();
    $( "#popUpCorreto" ).popup();
    if(validarLocalStorage() && localStorage.nivelJogador){
		if(localStorage.modo != "undefined")
			document.getElementById('btnNovoJogo').innerHTML = '<img class="iconesMenu" src="img/jogar.png">Continuar';	
        $('input:radio[name="selecaoModo"]').filter('[value="'+localStorage.modo+'"]').prop('checked', true);		
    }else{
        resetarConfiguracoes();
    }

}

function resetarConfiguracoes(){
    localStorage.erros = 0;
    localStorage.acertos = 0;
    localStorage.nivelJogador = 1;
    localStorage.faseJogador = 0;
    localStorage.pontuacaoJogador = 0;
    localStorage.modo = $("#controleModoJogo :radio:checked").val();
	document.getElementById('btnNovoJogo').innerHTML = '<img class="iconesMenu" src="img/jogar.png">Jogar';
	//Cufon.replace('.fontePersonalizada');
}

$( document ).on( "pageinit", "#paginaPrincipal", function() {
    $( document ).on( "swipeleft swiperight", "#paginaPrincipal", function( e ) {
        // We check if there is no open panel on the page because otherwise
        // a swipe to close the left panel would also open the right panel (and v.v.).
        // We do this by checking the data that the framework stores on the page element (panel: open).
        if ( $.mobile.activePage.jqmData( "panel" ) !== "open" ) {
            if ( e.type === "swipeleft"  ) {
                $( "#painel_direito" ).panel( "open" );
            } 
        }
    });
});


$(document).on("pageinit", "#paginaAjuda", function(){
	
	$(document).on("swipeleft swiperight", "#paginaAjuda", function(e){
		
		if($.mobile.activePage.jqmData("panel") !== "open"){
			if(e.type === "swipeleft"){
				$("#painel_direitoAjuda").panel("open");
			}
		}
		
	});
	
});


$(document).on("pageinit", "#comoFunciona", function(){
	
	$(document).on("swipeleft swiperight", "#comoFunciona", function(e){
		
		if($.mobile.activePage.jqmData("panel") !== "open"){
			if(e.type === "swipeleft"){
				$("#painel_direitoComoFunciona").panel("open");
			}
		}
		
	});
	
});

$(document).on("pageinit", "#comoFuncionaModos", function(){
	
	$(document).on("swipeleft swiperight", "#comoFuncionaModos", function(e){
		
		if($.mobile.activePage.jqmData("panel") !== "open"){
			if(e.type === "swipeleft"){
				$("#painel_direitoModos").panel("open");
			}
		}
		
	});
	
});

$(document).on("pageinit", "#comoFuncionaBiblioteca", function(){
	
	$(document).on("swipeleft swiperight", "#comoFuncionaBiblioteca", function(e){
		
		if($.mobile.activePage.jqmData("panel") !== "open"){
			if(e.type === "swipeleft"){
				$("#painel_direitoComofuncionabiblio").panel("open");
			}
		}
		
	});
	
});


$(document).on("pageinit", "#paginaModosDeJogo", function(){
	
	$(document).on("swipeleft swiperight", "#paginaModosDeJogo", function(e){
		
		if($.mobile.activePage.jqmData("panel") !== "open"){
			if(e.type === "swipeleft"){
				$("#painel_direitoOpcoes").panel("open");
			}
		}
		
	});
	
});


$(document).on("pageinit", "#paginaBiblioteca", function(){
	
	$(document).on("swipeleft swiperight", "#paginaBiblioteca", function(e){
		
		if($.mobile.activePage.jqmData("panel") !== "open"){
			if(e.type === "swipeleft"){
				$("#painel_direitoBiblioteca").panel("open");
			}
		}
		
	});
	
});

$(document).on("pageinit", "#paginaJogar", function(){
	
	$(document).on("swipeleft swiperight", "#paginaJogar", function(e){
		
		if($.mobile.activePage.jqmData("panel") !== "open"){
			if(e.type === "swipeleft"){
				$("#painel_direitoJogar").panel("open");
			}
		}
		
	});
	
});

$(document).on("pageshow","#paginaRanking", function(){
    rankingTop10();
});

