    
    "use strict";    
    
    var lettre  = 'X'; // 1er coup joué
    var case_id = '';
    var gagnant = '';
    var score   = '';
    
    var cases   = ['a1', 'a2', 'a3', 'b1', 'b2', 'b3', 'c1', 'c2', 'c3'];
    // console.log(Array.isArray(cases));
    var cases_jouees    = []; // toutes cases jouées
    var cases_jouees_x  = []; // cases jouées par X
    var cases_jouees_o  = []; // cases jouées par O
    var cases_joueur    = [];
    var cases_valides   = [];
    var cases_gagnantes = [
        ['a1', 'a2', 'a3'], // lignes
        ['b1', 'b2', 'b3'],
        ['c1', 'c2', 'c3'],
        ['a1', 'b1', 'c1'], // colonnes
        ['a2', 'b2', 'c2'],
        ['a3', 'b3', 'c3'],
        ['a1', 'b2', 'c3'], // diagonales
        ['c1', 'b2', 'a3']
    ];
    
    
    $(document).ready(function()
    {
        // Clic sur une case
        $('#plateau td').click(function() {
            case_id = $(this).attr('id');
            if( isCaseEmpty(case_id) )
            {
                addLetter(case_id, lettre);
                
                if(cases_jouees_x.length >= 3 || cases_jouees_x.length >= 3) { // possibilité de victoire
                    checkIfPlayerWins(lettre);
                }
                
                if ( cases_jouees.length < 9 )  { changeLetter(); }
                else                            { endOfGame(); }
            }
        });
        
        // Recommencer la partie
        $('#reset_game').click(function() {
            lettre          = 'X';
            gagnant         = '';
            cases_jouees    = [];
            cases_jouees_x  = [];
            cases_jouees_o  = [];
            cases_valides   = [];
            $('#message').html('&nbsp;');
            $('#plateau td').html('');
            $('#plateau td').removeClass('played won image_x image_o');
        });
        
        // Remise à zéro des scores
        $('#reset_scores').click(function() {
            setNbVictoiresX(0);
            setNbVictoiresO(0);
            setNbEgalites(0);
            $('#scores td').html(0); // td:nth-child(1) = 1e cellule
        });
        
    }); // end $(document).ready(function()
    
    /**
     *  Ajout d'une lettre dans la case
     *  @param  case_id     id de la case
     *  @param  lettre      X ou O
     */
    function addLetter( case_id, lettre )
    {
        // La case indiquée n'existe pas
        if ( cases.indexOf(case_id) == -1 ) {
            return false;
        }
        
        // La lettre n'est pas autorisée
        if ( lettre != 'X' && lettre != 'O' ) {
            return false;
        }
        
        // La case a déjà été jouée
        if( !isCaseEmpty(case_id) ) {
            return false;
        }
        
        // La partie a déjà un gagnant
        if ( hasWinner() ) { return false; }
        
        // Ajout de la lettre (X ou O)
        // $('#'+case_id).html(lettre);
        $('#'+case_id).addClass('played image_'+ lettre.toLowerCase());
        cases_jouees.push(case_id);
        if ( lettre == 'X' )    { cases_jouees_x.push(case_id); }
        else                    { cases_jouees_o.push(case_id); }
        
    } // end addLetter()
    
    /**
     *  Change la lettre qui va être jouée : X ou O
     */
    function changeLetter() {
        if ( lettre == 'X' )    { lettre = 'O'; }
        else                    { lettre = 'X'; }
    } // end changeLetter()
    
    /**
     *  Vérifie si la case est remplie (déjà jouée) ou vide
     *  @param  case_id     id de la case
     */
    function isCaseEmpty(case_id) {
        // Présence d'une lettre (X ou O)
        // if( $('#'+case_id).html() == '' )   return true;
        //else                                return false;
        // Présence d'une image (X ou O)
        if (
            $('#'+case_id).hasClass('image_x') || 
            $('#'+case_id).hasClass('image_o') 
        )       return false;
        else    return true;
    } // end isCaseEmpty()
    
    /**
     *  Vérifie si le joueur a gagné
     *  lettre  X ou O
     */
    function checkIfPlayerWins(lettre)
    {
        if ( hasWinner() ) { return false; } 
        
        if (lettre == 'X') {
            cases_joueur = cases_jouees_x;
        }
        else {
            cases_joueur = cases_jouees_o;
        }
        
        // On vérifie si les cases_jouees dans une des lignes des cases_gagnantes
        $.each(cases_gagnantes, function(index, ligne) {
            cases_valides = [];
            $.each(ligne, function(i, ligne_cases) {
                if (cases_joueur.indexOf(ligne_cases) > -1) {
                    cases_valides.push(ligne_cases);
                }
            });
            if ( cases_valides.length == 3 ) {
                weHaveWinner(lettre, cases_valides);
                return false; // = break
            }
        });
        
    } // end checkIfPlayerWins()
    
    /**
     *  Gestion de la victoire
     *  @param  lettre          Joueur gagnant (X ou O)
     *  @param  cases_valides   3 cases alignées
     */
    function weHaveWinner(lettre, cases_valides) {
        gagnant = lettre;
        $('#plateau td').addClass('played');
        $.each(cases_valides, function (i, case_id) {
            $('#'+case_id).addClass('won');
        });
        endOfGame();
    } // end weHaveWinner()
    
    /**
     *  A-t-on un gagnant ?
     *  renvoie true si gagnant est X ou O
     */
    function hasWinner() {
        return ( gagnant == '' ) ? false : true;
    } // end hasWinner()
    
    /**
     *  Fin du jeu : affichage gagnant + scores
     */
    function endOfGame() {
        if ( hasWinner() )  {
            message = gagnant + ' a gagné !';
            if ( gagnant == 'X' )       { setNbVictoiresX(parseInt(getNbVictoiresX()) + 1); }
            else if ( gagnant == 'O' )  { setNbVictoiresO(parseInt(getNbVictoiresO()) + 1); }
        }
        else {
            message = "Egalité";
            setNbEgalites(parseInt(getNbEgalites()) + 1);
        }
        $('#message').html(message);
        $('#scores').html(getScores());
    } // end endOfGame()
    
    /**
     *  Nombre de victoires de X, de O, et d'égalité
     */
    function getNbVictoiresX() {
        return ( localStorage.getItem('victoires_x') == null ) ? 0 : localStorage.getItem('victoires_x');
    }
    function setNbVictoiresX(nb) {
        localStorage.setItem('victoires_x', parseInt(nb));   
    }
    function getNbVictoiresO() {
        return ( localStorage.getItem('victoires_o') == null ) ? 0 : localStorage.getItem('victoires_o');
    }
    function setNbVictoiresO(nb) {
        localStorage.setItem('victoires_o', parseInt(nb));   
    }
    function getNbEgalites() {
        return ( localStorage.getItem('egalites') == null ) ? 0 : localStorage.getItem('egalites');
    }
    function setNbEgalites(nb) {
        localStorage.setItem('egalites', parseInt(nb));
    }
    function getScores() {
        score    = '<table><thead><tr>';
        score   += '<th>Victoires X</th>';
        score   += '<th>Egalité</th>';
        score   += '<th>Victoires O</th>';
        score   += '</thead><tbody><tr>';
        score   += '<td>'+ getNbVictoiresX() +'</td>';
        score   += '<td>'+ getNbEgalites() +'</td>';
        score   += '<td>'+ getNbVictoiresO() +'</td>';
        score   += '</tr></tbody></table>';
        return score;
    }