
var ctx,can, offset= 30;	
document.addEventListener( "DOMContentLoaded", function(){
	// setup a new canvas for drawing wait for device init
    setTimeout(function(){ newCanvas(); }, 1000);
}, false );
// function to setup a new canvas for drawing
function newCanvas(){
	//define and resize canvas
    document.getElementById("content").style.height = window.innerHeight-offset;
    var canvas = '<canvas id="canvas" width="'+window.innerWidth+'" height="'+(window.innerHeight-offset)+'"></canvas>';
	document.getElementById("content").innerHTML = canvas;
    // setup canvas
    can = document.getElementById("canvas");
	ctx = can.getContext("2d");
    sliderValue(1);
    BrushColor("black");
	// setup to trigger drawing on mouse or touch
    drawTouch();
    drawPointer();
	drawMouse();
}
document.getElementById("new").onclick = function(){
    ctx.clearRect(0, 0, window.innerWidth, window.innerHeight);
};
var range = document.getElementById("Range");
range.onchange = function() {sliderValue(range.value)};
function sliderValue(newValue){ 
    ctx.lineWidth = newValue*2;
    document.getElementById("LabelR").innerHTML = newValue;
}       
var color = document.getElementById("Color");
color.oninput = function() {BrushColor(color.value)};
function BrushColor(colorValue){
    ctx.beginPath();
    ctx.strokeStyle = colorValue;
}
// prototype to	start drawing on touch using canvas moveTo and lineTo
var drawTouch = function() {
	var start = function(e) {
		ctx.beginPath();
		x = e.changedTouches[0].pageX;
		y = e.changedTouches[0].pageY-offset;
		ctx.moveTo(x,y);
	};
	var move = function(e) {
		e.preventDefault();
		x = e.changedTouches[0].pageX;
		y = e.changedTouches[0].pageY-offset;
		ctx.lineTo(x,y);
		ctx.stroke();
	};
    can.addEventListener("touchstart", start, false);
	can.addEventListener("touchmove", move, false);
};   
// prototype to	start drawing on pointer(microsoft ie) using canvas moveTo and lineTo
var drawPointer = function() {
	var start = function(e) {
        e = e.originalEvent;
		ctx.beginPath();
		x = e.pageX;
		y = e.pageY-offset;
		ctx.moveTo(x,y);
	};
	var move = function(e) {
		e.preventDefault();
        e = e.originalEvent;
		x = e.pageX;
		y = e.pageY-offset;
		ctx.lineTo(x,y);
		ctx.stroke();
    };
    can.addEventListener("MSPointerDown", start, false);
	can.addEventListener("MSPointerMove", move, false);
};        
// prototype to	start drawing on mouse using canvas moveTo and lineTo
var drawMouse = function() {
	var clicked = 0;
	var start = function(e) {
		clicked = 1;
		ctx.beginPath();
		x = e.pageX;
		y = e.pageY-offset;
	};
	var move = function(e) {
		if(clicked){
			x = e.pageX;
			y = e.pageY-offset;
			ctx.lineTo(x,y);
			ctx.stroke();
		}
	};
	var stop = function(e) {
		clicked = 0;
	};
    can.addEventListener("mousedown", start, false);
	can.addEventListener("mousemove", move, false);
	document.addEventListener("mouseup", stop, false);
};
