/* Controllers */

parkingManijak.controller('AppCtrl', ['$scope', 'LicensePlateService', 'PlaceService', 'CirilizatorService',

  function AppCtrl($scope, LicensePlateService, PlaceService, CirilizatorService) {

        var calculateLPParts = function () {
            if ($scope.currentLP) {
                $scope.currentLPLeft = $scope.currentLP.substring(0, 2);
                if ($scope.currentLP.length == 8) {
                    $scope.currentLPRight = $scope.currentLP.substring(2, 6) + '·' + $scope.currentLP.substring(6);
                } else {
                    $scope.currentLPRight = $scope.currentLP.substring(2, 5) + '·' + $scope.currentLP.substring(5);
                }

                $scope.currentLPPlaceMark = CirilizatorService.transliterate($scope.currentLPLeft);
            } else {
                $scope.currentLPLeft = "";
                $scope.currentLPRight = "";
                $scope.currentLPPlaceMark = "";
            }
        };

        $scope.currentLP = LicensePlateService.getLicensePlate();
        calculateLPParts();
        $scope.$on("CurrentLPChanged", function (event, x) {
            $scope.currentLP = x;
            calculateLPParts();
        });

        if (!$scope.currentLP || $scope.currentLP.length == 0) {
            alert('Za korišćenje aplikacije neophodno je uneti registarsku oznaku vozila. Dodirom na praznu tablicu u gornjem delu otvara se obrazac za unos registarske oznake. Takođe, na isti način moguće je naknadno promeniti registarsku oznaku.');
        }

        $scope.currentPlace = PlaceService.getPlace();
        $scope.$on("CurrentPlaceChanged", function (event, x) {
            $scope.currentPlace = x;
        });

        $scope.sendSMS = function (zone) {
            if ($scope.currentLP && $scope.currentLP.length <= 8 && $scope.currentLP.length >= 7) {
                var sms = new MozActivity({
                    name: "new", // Possible compose-sms in future versions
                    data: {
                        type: "websms/sms",
                        number: zone.sms_number,
                        body: $scope.currentLP
                    }
                });



                // For test only
                // Fixed data for SMS app intent
                // ------------------------------
                // COMMENT OUT BEFORE PRODUCTION
                // ------------------------------
                //                
                //var sms = new MozActivity({
                //    name: "new", 
                //    data: {
                //        type: "websms/sms",
                //        number: "+46777888999",
                //        body: 'my text message'
                //    }
                //});


            } else {
                alert('SMS ne može biti poslat, potrebno je uneti ispravnu registarsku oznaku.');
            }
        };

  }]);

parkingManijak.controller('ListPlacesCtrl', function ListPlacesCtrl($scope, $location, PlaceService, ParkingManijakAPIFactory) {
    var communicationErrorMessage = "Servis trenutno nije dostupan. Proverite Internet konekciju ili pokušajte kasnije.";

    ParkingManijakAPIFactory.getPlaces().
    success(function (data) {
        $scope.places = data;
    }).
    error(function (data) {
        alert(communicationErrorMessage);
    });

    $scope.setPlace = function (place) {
        PlaceService.setPlace(place);
    }

    $scope.go = function (goToRoute) {
        $location.path(goToRoute);
    };

});

parkingManijak.controller('AddLPCtrl', function AddLPCtrl($scope, $location, LicensePlateService) {
    $scope.currentLP = LicensePlateService.getLicensePlate();
    $scope.$on("CurrentLPChanged", function (event, x) {
        $scope.currentLP = x;
    });

    $scope.changeLicensePlate = function () {
        LicensePlateService.setLicensePlate($scope.currentLP);
        $scope.go('/index');
    };

    $scope.addLetter = function (letter) {
        if (!$scope.currentLP) {
            $scope.currentLP = letter;
        } else if ($scope.currentLP.length < 8) {
            $scope.currentLP = $scope.currentLP + letter;
        }
    };

    $scope.go = function (goToRoute) {
        $location.path(goToRoute);
    };

    $scope.cancelChange = function () {
        if ($scope.currentLP != LicensePlateService.getLicensePlate()) {
            var leave = confirm("Da li želite da poništite promene na registarskoj oznaci?");
            if (leave) {
               $scope.go('/index');
            }
        }else{
            $scope.go('/index');
        }
    };
});

parkingManijak.controller('EditLPCtrl', function EditLPCtrl($scope, $routeParams) {

});

parkingManijak.controller('ListLPCtrl', function ListLPCtrl($scope, $routeParams) {

});

parkingManijak.controller('SettingsCtrl', function SettingsCtrl($scope, $routeParams) {

});