parkingManijak.factory('ParkingManijakAPIFactory', ['http',

   function ParkingManijakAPIFactory(http) {

        var placeListUrl = "places_list",
            placeDetailUrl = "place_data/",
            expirePeriodPlaceList = 10 * 24 * 60 * 60 * 1000, //10 dana
            expirePeriodPlaceDetail = 5 * 24 * 60 * 60 * 1000; //5 dana

        var getFullUrl = function (url) {
            var baseUrl = 'http://api.parkingmanijak.com/api/v1/',
                key = 'LS5622XKZS9AH658SCYRVCCFVLTUMNJD2TZXCS5J',
                urlSuffix = '?X-API-KEY=' + key,
                fullUrl = "";

            fullUrl = baseUrl + url + urlSuffix;

            return fullUrl
        };

        return {
            getPlaces: function () {
                var fullUrl = getFullUrl(placeListUrl);

                return http.get(fullUrl, {
                    idbCache: {
                        cacheKey: placeListUrl,
                        expiresInMs: expirePeriodPlaceList
                    }
                });
            },
            getZones: function (place_id) {
                var fullUrl = getFullUrl(placeDetailUrl + place_id);

                return http.get(fullUrl, {
                    idbCache: {
                        cacheKey: placeDetailUrl + place_id,
                        expiresInMs: expirePeriodPlaceDetail
                    }
                });
            }
        };
    }]);

parkingManijak.service('LicensePlateService', function ($rootScope) {

    var stripAllNonAlfaNumericRSChars = function (inStr) {
        var allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZČĆŽŠĐ0123456789",
            res = "";

        if (inStr) {
            inStr = inStr.toUpperCase();

            for (i = 0; i < inStr.length; i++) {
                if (allowedChars.indexOf(inStr[i]) > -1) {
                    res = res + inStr[i];
                }
            }
        }

        return res;
    };

    return {
        getLicensePlate: function () {
            return localStorage.getItem("licensePlate");
        },
        setLicensePlate: function (licensePlate) {
            var licensePlateStriped = stripAllNonAlfaNumericRSChars(licensePlate);
            localStorage.setItem("licensePlate", licensePlateStriped);
            $rootScope.$broadcast("CurrentLPChanged", licensePlateStriped);
        },
        removeLicensePlate: function () {
            localStorage.removeItem("licensePlate");
        }
    };
});

parkingManijak.service('PlaceService', function ($rootScope, ParkingManijakAPIFactory, ColorService) {
    var communicationErrorMessage = "Servis trenutno nije dostupan. Proverite Internet konekciju ili pokušajte kasnije.";
    var getZones = function () {

        ParkingManijakAPIFactory.getZones(place.place_id).
        success(function (data) {
            place.zones = data.parking_zones;

            if (place.zones) {
                var element;
                for (var i = 0; i < place.zones.length; i++) {
                    element = place.zones[i];
                    element.color = ColorService.getColor(element.color);
                }
            }
        }).
        error(function (data) {
            alert(communicationErrorMessage);
        });
    };

    var place = localStorage.getItem("place");
    if (!place) {
        place = {
            place_id: 2,
            name: "Beograd"
        };
    } else {
        place = JSON.parse(place);
    };
    getZones();

    return {
        getAllPlaces: function () {
            ParkingManijakAPIFactory.getPlaces().
            success(function (data) {
                return data;
            }).
            error(function (data) {
                alert(communicationErrorMessage);
            });
        },
        getPlace: function () {
            return place;
        },
        setPlace: function (newPlace) {
            place = newPlace;
            localStorage.setItem("place", JSON.stringify(place));
            getZones();
            $rootScope.$broadcast("CurrentPlaceChanged", place);
        }
    };
});

parkingManijak.service('ColorService', function () {
    return {
        getColor: function (colorCode) {
            var color = "lightgray";
            switch (colorCode) {
            case "st_blue":
                color = "blue";
                break;
            case "st_white":
                color = "lightgray";
                break;
            case "st_red":
                color = "red";
                break;
            case "st_green":
                color = "green";
                break;
            case "st_yellow":
                color = "yellow";
                break;
            case "st_orange":
                color = "orange";
                break;
            case "st_purple":
                color = "#8506A9";
                break;
            }

            return color;
        }
    };
});

parkingManijak.service('CirilizatorService', function () {

    var getCirilicChar = function (inChar) {

        var outChar;

        switch (inChar) {
        case 'b':
            outChar = 'б';
            break;
        case 'B':
            outChar = 'Б';
            break;
        case 'v':
            outChar = 'в';
            break;
        case 'V':
            outChar = 'В';
            break;
        case 'g':
            outChar = 'г';
            break;
        case 'G':
            outChar = 'Г';
            break;
        case 'd':
            outChar = 'д';
            break;
        case 'D':
            outChar = 'Д';
            break;
        case 'đ':
            outChar = 'ђ';
            break;
        case 'Đ':
            outChar = 'Ђ';
            break;
        case 'ž':
            outChar = 'ж';
            break;
        case 'Ž':
            outChar = 'Ж';
            break;
        case 'z':
            outChar = 'з';
            break;
        case 'Z':
            outChar = 'З';
            break;
        case 'i':
            outChar = 'и';
            break;
        case 'I':
            outChar = 'И';
            break;
        case 'k':
            outChar = 'к';
            break;
        case 'K':
            outChar = 'К';
            break;
        case 'l':
            outChar = 'л';
            break;
        case 'L':
            outChar = 'Л';
            break;
        case 'm':
            outChar = 'м';
            break;
        case 'M':
            outChar = 'М';
            break;
        case 'n':
            outChar = 'н';
            break;
        case 'N':
            outChar = 'Н';
            break;
        case 'p':
            outChar = 'п';
            break;
        case 'P':
            outChar = 'П';
            break;
        case 'r':
            outChar = 'р';
            break;
        case 'R':
            outChar = 'Р';
            break;
        case 's':
            outChar = 'с';
            break;
        case 'S':
            outChar = 'С';
            break;
        case 't':
            outChar = 'т';
            break;
        case 'T':
            outChar = 'Т';
            break;
        case 'ć':
            outChar = 'ћ';
            break;
        case 'Ć':
            outChar = 'Ћ';
            break;
        case 'u':
            outChar = 'у';
            break;
        case 'U':
            outChar = 'У';
            break;
        case 'f':
            outChar = 'ф';
            break;
        case 'F':
            outChar = 'Ф';
            break;
        case 'h':
            outChar = 'х';
            break;
        case 'H':
            outChar = 'Х';
            break;
        case 'c':
            outChar = 'ц';
            break;
        case 'C':
            outChar = 'Ц';
            break;
        case 'č':
            outChar = 'ч';
            break;
        case 'Č':
            outChar = 'Ч';
            break;
        case 'š':
            outChar = 'ш';
            break;
        case 'Š':
            outChar = 'Ш';
            break;

        default:
            outChar = inChar;
            break;
        }

        return outChar;
    };

    return {
        transliterate: function (inStr) {

            var tempStr = inStr,
                outStr = "",
                outChar;

            if (tempStr) {
                tempStr = tempStr.replace("lj", "љ");
                tempStr = tempStr.replace("Lj", "Љ");
                tempStr = tempStr.replace("LJ", "Љ");

                tempStr = tempStr.replace("nj", "њ");
                tempStr = tempStr.replace("Nj", "Њ");
                tempStr = tempStr.replace("NJ", "Њ");

                tempStr = tempStr.replace("dž", "џ");
                tempStr = tempStr.replace("Dž", "Џ");
                tempStr = tempStr.replace("DŽ", "Џ");

                tempStr = tempStr.replace("dj", "ђ");
                tempStr = tempStr.replace("Dj", "Ђ");
                tempStr = tempStr.replace("DJ", "Ђ");

                for (var i = 0; i < tempStr.length; i++) {
                    outStr = outStr + getCirilicChar(tempStr.charAt(i));
                }
            }

            return outStr;
        }
    };
});