var Gamecharades = function() {
	
	this.initialize = function() {
		var self = this;
		this.el = $('<div/>');
		//console.log(pgpath);
		//console.log(phonegap);
		if (phonegap == "android") {
			beepwarn = new Media(pgpath + "content/beepwarn.mp3");
			beepout = new Media(pgpath + "content/beepout.mp3");
			//console.log("android");
		} else if (phonegap == "ios") {
			beepwarn = new Media("content/beepwarn.mp3");
			beepout = new Media("content/beepout.mp3");			
		} else if (phonegap == "wp") {
			beepwarn = new Media("app/www/content/beepwarn.mp3");
			beepout = new Media("app/www/content/beepout.mp3");	
		}
		self.cleanup();
		self.registerEvents();
	},
	
	this.render = function() {
		this.el.html(Gamecharades.template);
        return this;
	},

	this.registerEvents = function() {
		// Declaring all event listeners
		var self = this;
		var rounds = 10;
		var difficulty = 1;
		// Declare HTML for removal button
		var rmbutton = "<span class=\"glyphicon glyphicon-remove teamsx\"></span>"
		this.el.on("click", "#nextcharades", function() {
			if (chteamscores.teams[0].players.length > 0 && chteamscores.teams[1].players.length > 0) {
				$('.charadescontentwrapper').html(charadessettings2);
			}
			else {
				if (chteamscores.teams[0].players.length > 0) {
					app.showAlert("You need to add players to team 2");
				}
				else if (chteamscores.teams[1].players.length > 0) {
					app.showAlert("You need to add players to team 1");
				}
				else {
					app.showAlert("You need to add players to both teams!", "Error");
				}
				return;
			}
		});
		this.el.on("click", "#nextcharades2", function() {
			// Render rules
			$.jStorage.set("diff", difficulty);
			$('.charadescontentwrapper').html(charadeshowto);
		});
		this.el.on("click", "#startcharades", function() {
			//console.log(rounds);
			// Trigger to start & pause audio so it can be autoplayed in iOS & Android
			document.getElementById('beepwarn').play();
			document.getElementById('beepout').play();
			document.getElementById('beepout').pause();
			document.getElementById('beepwarn').pause();
			// Launch a new game
			self.newgame(rounds);
		});
		this.el.on("click", ".endround", function() {
			clearInterval(countdown);
			self.endround();
		});
		this.el.on("click", ".stopcounter", function() {
			clearInterval(countdown);
		});
		this.el.on("click", "#team1", function() {
			clearInterval(countdown);
			var t1s = chteamscores.teams[0].score;
			t1s++;
			chteamscores.teams[0].score = t1s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitStart();
		});
		this.el.on("click", "#team2", function() {
			clearInterval(countdown);
			var t2s = chteamscores.teams[1].score;
			t2s++;
			chteamscores.teams[1].score = t2s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitStart();
		});
		this.el.on("click", ".addteam1", function() {
			var t1addplayer = $('.team1players').val();
			if (t1addplayer.length > 0) {
				chteamscores.teams[0].players.push({ player: t1addplayer });
				//console.log(chteamscores.teams[0].players);
				$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
				$('.team1players').val("");
				$('.team1players').attr("placeholder", "Add another player..");
			} else {
				app.showAlert("You need to type a name first!");
			}
		});
		this.el.on("click", ".addteam2", function() {
			var t2addplayer = $('.team2players').val();
			if (t2addplayer.length > 0) {
				chteamscores.teams[1].players.push({ player: t2addplayer });
				//console.log(chteamscores.teams[1].players);
				$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
				$('.team2players').val("");
				$('.team2players').attr("placeholder", "Add another player..");
			} else {
				app.showAlert("You need to type a name first!");
			}
		});
		this.el.on("keypress", ".team1players", function(event) {
        	var t1addplayer = $('.team1players').val();
        	var p = event.which;
        	if (p == 13) {
        		event.preventDefault();
				if (t1addplayer.length > 0) {
					chteamscores.teams[0].players.push({ player: t1addplayer });
					//console.log(chteamscores.teams[0].players);
					$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
					$('.team1players').val("");
					$('.team1players').attr("placeholder", "Add another player..");
				} else {
					app.showAlert("You need to type a name first!");
				}
			}
       	});
		this.el.on("keypress", ".team2players", function(event) {
        	var t2addplayer = $('.team2players').val();
        	var p = event.which;
        	if (p == 13) { 
        		event.preventDefault();
				if (t2addplayer.length > 0) {
					chteamscores.teams[1].players.push({ player: t2addplayer });
					//console.log(chteamscores.teams[1].players);
					$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
					$('.team2players').val("");
					$('.team2players').attr("placeholder", "Add another player..");
				} else {
					app.showAlert("You need to type a name first!");
				}
			}
       	});
		this.el.on("click", ".teamsx", function() {
			this.detach();
		});
		this.el.on("click", ".cr5", function() {
			rounds = 10;
			$('.selectrounds').text("10");
		});
		this.el.on("click", ".cr10", function() {
			rounds = 20;
			$('.selectrounds').text("20");
		});
		this.el.on("click", ".cr15", function() {
			rounds = 30;
			$('.selectrounds').text("30");
		});
		this.el.on("click", ".cr30", function() {
			rounds = 50;
			$('.selectrounds').text("50");
		});
		this.el.on("click", ".cheasy", function() {
			difficulty = 0;
			$('.selectdifficulty').text("Easy");
		});
		this.el.on("click", ".chmedium", function() {
			difficulty = 1;
			$('.selectdifficulty').text("Medium");
		});
		this.el.on("click", ".chhard", function() {
			difficulty = 2;
			$('.selectdifficulty').text("Hard");
		});
		self.el.on('click', '#startnewround', function() {
			self.startround(chnowplaying);
		});
		self.el.on('click', '.playagain', function() {
			self.playAgain();
		});
	},

	this.waitStart = function() {
		var self = this;
		clearInterval(countdown);
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		if (round == rounds) {
			self.endgame();
		}
		else {
			$('.charadescontentwrapper').html(charadeswaitstart);
			var t1s = chteamscores.teams[0].score;
			var t2s = chteamscores.teams[1].score;
			var t1p = chteamscores.teams[0].players;
			var t2p = chteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			if (round % 2 == 0) {
				var playernm = parseFloat(chteamscores.teams[0].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				chnowplaying = chteamscores.teams[0].players[p1].player;
				$('.playername').append("Next up is <b>" + chnowplaying + ".</b> \n Press start when ready!");
			}
			else if (round % 2 != 0) {
				var playernm = parseFloat(chteamscores.teams[1].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				chnowplaying = chteamscores.teams[1].players[p1].player;
				$('.playername').append("Next up is <b>" + chnowplaying + ".</b> \n Press start when ready!");
			}
		}

	}

	this.playAgain = function() {
		var self = this;
		var rounds = $.jStorage.get("rounds");
		chteamscores.teams[0].score = 0;
		chteamscores.teams[1].score = 0;
		clearInterval(countdown);
		self.newgame(rounds);
	}

	this.cleanup = function() {
		chteamscores.teams[0].players.length = 0;
		chteamscores.teams[1].players.length = 0;
		chteamscores.teams[0].score = 0;
		chteamscores.teams[1].score = 0;
		clearInterval(countdown);
	}

	this.endround = function() {
		var self = this;
		clearInterval(countdown);
		$('.charadescontentwrapper').html(charadesendround);
		var t1s = chteamscores.teams[0].score;
		var t2s = chteamscores.teams[1].score;
		var t1p = chteamscores.teams[0].players;
		var t2p = chteamscores.teams[1].players;
		//console.log(t1p);
		$.each(t1p, function(index, value) {
			//console.log(value.player);
			$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$.each(t2p, function(index, value) {
			//console.log(value.player);
			$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
		$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
		if (t1s > t2s) {
			$('.teamname1').removeClass("label-default").addClass("label-success");
		} else if (t2s > t1s) {
			$('.teamname2').removeClass("label-default").addClass("label-success");
		}
		$('.charadesbottomwrapper').detach();
	}

	this.endgame = function() {
		$.jStorage.deleteKey("round");
		app.hasPlayedGame();
		$('.charadescontentwrapper').html(endofgame);
		var t1s = chteamscores.teams[0].score;
		var t2s = chteamscores.teams[1].score;
		var t1p = chteamscores.teams[0].players;
		var t2p = chteamscores.teams[1].players;
		//console.log(t1p);
		$.each(t1p, function(index, value) {
			//console.log(value.player);
			$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$.each(t2p, function(index, value) {
			//console.log(value.player);
			$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
		$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
		if (t1s > t2s) {
			$('.teamname1').removeClass("label-default").addClass("label-success");
		} else if (t2s > t1s) {
			$('.teamname2').removeClass("label-default").addClass("label-success");
		}
		$('.charadesbottomwrapper').detach();
		if (t1s > t2s) {
			$('.charadeswinningteam').html("<b>Team 1 won with " + t1s + " points over " + t2s + ".</b><br>");
		}
		else if (t2s > t1s) {
			$('.charadeswinningteam').html("<b>Team 2 won with " + t2s + " points over " + t1s + ".</b><br>");
		}
		else {
			$('.charadeswinningteam').html("<b>The game was tied at " + t1s + ".</b><br>")
		}
	}

	this.startround = function(chnowplaying) {
		var self = this;
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		//console.log(round + "," + rounds); 
		if (round == rounds) {
			self.endgame();
			return;
		} else {
			var charadetodisplay = self.getcharade();
			var charadesdata = [{"charade": charadetodisplay}];
			$('.charadescontentwrapper').html(charadesstartround);
			$('.charadeinstructions').html("<b>" + chnowplaying + "</b>, gesture the word <h3><b>" + charadetodisplay + "</b></h3> to your team!");
			var t1s = chteamscores.teams[0].score;
			var t2s = chteamscores.teams[1].score;
			var t1p = chteamscores.teams[0].players;
			var t2p = chteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			$('.charadesbottomwrapper').html("");
			self.timer();
		}
		return;
	}

	this.newgame = function(rounds) {
		var rounds = parseFloat(rounds);
		$.jStorage.set("rounds", rounds);
		$.jStorage.set("round", 0);
		var self = this;
		$('#startcharades').detach();
		this.populateContent();
		this.waitStart();
	},

	this.timer = function() {
		var self = this;
		clearInterval(countdown);
		var timer = 61;
		var width = 100;
		countdown = window.setInterval(function() {
			if (timer > 0 && timer != 5 && timer != 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Time remaining: <b>" + timer + "s</b>");
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				$('.endround').css('visibility', 'visible');
			} else if (timer == 5) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Time remaining: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				if (phonegap) {
					beepwarn.play();
				} else {
					document.getElementById('beepwarn').play();					
				}
				//console.log("audio?");
			} else if (timer == 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Time remaining: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				if (phonegap) {
					beepout.play();
				} else {
					document.getElementById('beepout').play();					
				}
				//console.log("audioout?");
			} else {
				clearInterval(countdown);
				self.endround();
			}
		}, 1000);
	},

	this.getcharade = function() {
		var difficulty = $.jStorage.get("diff");
        if (difficulty == 0) {
        	var length = charadeseasy.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = charadeseasy.splice(generatedid, 1);
	        return charade;
        } else if (difficulty == 1) {
        	var length = charadesmedium.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = charadesmedium.splice(generatedid, 1);
	        return charade;   	
        } else {
        	var length = charadeshard.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = charadeshard.splice(generatedid, 1);
	        return charade;
        }
	},


	this.populateContent = function() {
		//function reloads the variables with content
		charadesmedium = ["Cow","Summer","Rope","Rollerblade","Snowball","Turtle","Table tennis","Beg","Cape","Rain","Saddle","Firefighter",
					"Queen","Zombie","Drunkie","Michael Jackson","James Bond","Pilot","Cricket player",
					"Rich","Money","Fire","DJ","Bartender","Bikini","Engagement ring","Head phones","Britney Spears","Handbag",
					"Afro hair","TV","Unicorn","Lollipop","Candy","Hot dog","Crocodile","Pharmacy","Morning","Hooker",
					"Tourist","Party hat","Hawaii","Donkey","Fox","Poop","Key","Heart broken","Owl","Stylist",
					"Good looking","Fat", "Pajamas","Sick","Motorcycle","Trampoline","Pamela Anderson","Butterfly","In love","Athlete's Foot","Itching","Party",
					"Wine","Redbull Vodka","Blody Mary","Champagne","Dragon","Brat","Shoplifter","Rich","Wizard","Foretell",
				 	"Super hero","Sniffer dog","Gold","Princess","Golf","Fireworks","Poker","Chess","USA",
					"Chlamydia","Mushrooms","Ingrown toenails","Wine tasting","Flirt","Tarzan","Nose spray","Aspirin",
					"Balloon","Slide","Robin hood","Police","Pope","Jesus","Brat","Art","Underwear","Boxing","Showjumping",
					"Wallet","Man bag","iPad","Facebook","Instagram","Selfie","Owl","Letter","Old man","Watchdog","Shot","Nosebleed",
					"Fractions","Magnifier","Carrot","Hanky","ATM","Star","Carousel","Bun","Horsetail","Catwalk",
					"Artist","Has a cold","Penguin","Possum","Fax","Carpenter","Surf","Electrician","Bus driver",
					"Toothache","Miley Cyrus","Wedding","Long johns","Ski","Slalom","Goalkeeper","Optician","Nurse",
					"Doctor","Pirate","Receptionist","Veterinary","Plastic surgeon","Psychologist","Stripper","Bartender","Circus",
					"Cigarette","Hair dryer","Taxi","Prom","Panty liner","Tampon","Swing","Clog","Car mechanic","Driver",
					"Ticket inspectors","Detective","Kleptomaniac","Flasher","Doodle","Mountain Climber"]

		charadeseasy = ["Point","Scissor","Elephant","Jump","Chair","Pinch","Mosquito","Sunglasses",
					"Head","Balloon","Drink","Robot","Chicken","Rock","Camera","Book","Rabbit","Arm",
					"Crayon","Pig","Monkey","Baby","Happy","Hopscotch","Spider","Bird","Doll","Wings","Turtle",
					"Room","Drum","Ear","Cheek","Smile","Jar","Chin","Telephone","Mouth","Basketball","Tail","Airplane","iPhone","Computer",
					"TV","Kitchen","Livingroom","Pistol","Bedroom","Braces","Beer","Wine","Cider",
					"Dog","Cat","Bird","Lion","Tiger","Whale","Seal","Snake","Horse","Dish","Haircut","Flowe","Package","Door","Skin",
					"Heart","Star","Square","Ball","Fireworks","Fire","Dance","Disco","Moonwalk","Fry","Bite","Flirt","Butt","Boobs",
					"Penis","Poop","Pee","Eye","Air","Airplane","Train","Car","Bicycle","Bus","Skate","Figure skating","Circus",
					"Stumble","Fart","Break leg","Foot sprain","Hug","Kiss","Table","Water","Lift","Carry","Gym","Muscle",
					"Number","Letter","Radio","Bed","Sleep","Snore","Dead","Puke","Drunk","Hungry","Sad","Sword","Guitar",
					"Piano","Trumpet","Wax","Wind","Sail","Chocolate","Lollipop","Bag","Ring","Nail polish","Sun","Moon","Rain",
					"Snow","Ice","Wood","Apple","Hat","Bow","Dragon","Ice cream","Castle","Blind","Clock","Wire","Tie",
					"Button","Hair","High Five","Gagnam Style","Crown","Wand","Snot","Earwax","Beard","Coffee","Lice",
					"Botox","Earring","Blond","Lipstick","Mascara","Water pistol","Water balloon","Balloon","Flag",
					"Jumping rope","Braid","Tired","Newspaper","Sausage","Hamburger","Table tennis","Tennis","Football","Long jump"]

		charadeshard = ["Small","Sheet","Trap","Quicksand","Funny","Whisk","Volcano","Eraser","Business","Brain","Blinds",
					"Dryer","Cuff","Flamingo","Basket","Lung","Beggar","Spider web","Carrot","Cowboy","Torch","Sip","Gym",
					"Trip","Beetle","Badge","Knot","Anger","Vegetable","Nightmare","Marble","Washing","Poison","Mouse","Spine",
					"Hair","Wrench","Party","Softball","Pizza","Swordfish","Vest","Stain","Year","Sand","Bobsled","Windmill",
					"Peck","Lawn mower","Doghouse","Cramp","Bubble","Artist","Giraffe","Honey","Scale","Wax","Cast","Sunburn",
					"Bathroom","Stiff","Chess","Shadow","Cloth","Wig","Doctor","Mirror","Alligator","Stop","Christmas","Drunk taxi driver",
					"Spaceship","Grandma","Serial killer","Brad Pitt","3 legged dog","Bride","Angry mom"]
	}

	this.initialize();

};

Gamecharades.template = Handlebars.compile($("#gamecharades").html());
var charadesendround = Handlebars.compile($("#charadesendround").html());
var charadesstartround = Handlebars.compile($("#charadesstartround").html());
var endofgame = Handlebars.compile($("#endofgame").html());
var charadeswaitstart = Handlebars.compile($('#charadeswaitstart').html());
var charadessettings2 = Handlebars.compile($('#charadessettings2').html());
var charadeshowto = Handlebars.compile($('#charadeshowto').html());

var countdown;

var chteamscores = { teams: [ 
	{ team:"Team 1", score:0, players: []},
	{ team:"Team 2", score:0, players: []},
	]};

var charadeseasy;
var charadesmedium;
var charadeshard;

//var beepout = new Media(pgpath + "content/beepout.mp3");
var beepout;
var beepwarn;
var chnowplaying;
